/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.Assembler;
import achtbit.Memory;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class RomAreaDialog
extends JDialog {
    private JTextField beginTextField;
    private JButton cancelButton;
    private JTextField endTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton setButton;

    public RomAreaDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.displayArea();
        this.beginTextField.setInputVerifier(new AdressVerifier());
        this.endTextField.setInputVerifier(new AdressVerifier());
    }

    private void displayArea() {
        Memory mem = Memory.instance();
        if (mem.getBeginRom() < 0 || mem.getEndRom() < 0 || mem.getBeginRom() > mem.getEndRom()) {
            this.beginTextField.setText("----");
            this.endTextField.setText("----");
            return;
        }
        this.beginTextField.setText(Assembler.int2hex(mem.getBeginRom(), 4));
        this.endTextField.setText(Assembler.int2hex(mem.getEndRom(), 4));
    }

    private void initComponents() {
        this.beginTextField = new JTextField();
        this.endTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cancelButton = new JButton();
        this.setButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Set ROM area");
        this.beginTextField.setFont(new Font("Ubuntu Mono", 0, 15));
        this.beginTextField.setText("0000");
        this.endTextField.setFont(new Font("Ubuntu Mono", 0, 15));
        this.endTextField.setText("0000");
        this.jLabel1.setText("-");
        this.jLabel2.setText("ROM Area:");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RomAreaDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.setButton.setText("Set Rom Area");
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RomAreaDialog.this.setButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.beginTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.setButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.beginTextField, -2, -1, -2).addComponent(this.endTextField, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.setButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void setButtonActionPerformed(ActionEvent evt) {
        int bAdr = this.beginTextField.getText().startsWith("-") ? -1 : Assembler.hex2int(this.beginTextField.getText());
        int eAdr = this.endTextField.getText().startsWith("-") ? -1 : Assembler.hex2int(this.endTextField.getText());
        if (bAdr < 0 && eAdr >= 0 || bAdr >= 0 && bAdr < 0) {
            JOptionPane.showMessageDialog(null, "Ein Bereich muss aus zwei Adressen bestehen.\n'-' - '-' gibt den ganzen Speicher als Ram frei.");
            return;
        }
        if (bAdr > eAdr) {
            JOptionPane.showMessageDialog(null, "Die Startadresse muss vor der Endadresse liegen!");
            return;
        }
        Memory.instance().setBeginRom(bAdr);
        Memory.instance().setEndRom(eAdr);
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RomAreaDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(RomAreaDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(RomAreaDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(RomAreaDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RomAreaDialog dialog = new RomAreaDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class AdressVerifier
    extends InputVerifier {
        AdressVerifier() {
        }

        @Override
        public boolean verify(JComponent jc) {
            JTextField ta = (JTextField)jc;
            String s = ta.getText().trim().toLowerCase();
            StringReader sr = new StringReader(s);
            try {
                int c = sr.read();
                if (c == -1) {
                    return true;
                }
                if (c == 45) {
                    while (c != -1) {
                        if (c != 45) {
                            JOptionPane.showMessageDialog(null, "Hexadezimale Adresse oder '-' erwartet.");
                            return false;
                        }
                        c = sr.read();
                    }
                } else {
                    while (c != -1) {
                        if (c < 48 || c > 57 && c < 97 || c > 102) {
                            JOptionPane.showMessageDialog(null, "Hexadezimale Adresse oder '-' erwartet.");
                            return false;
                        }
                        c = sr.read();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }
}

