/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.Assembler;
import achtbit.Bereich;
import achtbit.Memory;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SaveMemDialog
extends JDialog {
    public static String lastFileName = "";
    private JCheckBox assemblerCheckBox;
    private JTextArea bereicheTextArea;
    private JButton browseButton;
    private JButton cancelButton;
    private JTextField filenameTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField progStartTextfield;
    private JButton saveButton;

    public SaveMemDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.bereicheTextArea.setInputVerifier(new BereicheVerifier());
        this.progStartTextfield.setInputVerifier(new StartadresseVerifier());
        this.filenameTextField.setText(lastFileName.isEmpty() ? "memdump.txt" : lastFileName);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.bereicheTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.progStartTextfield = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.filenameTextField = new JTextField();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.browseButton = new JButton();
        this.assemblerCheckBox = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Speicherinhalt speichern");
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.bereicheTextArea.setColumns(9);
        this.bereicheTextArea.setFont(new Font("Nimbus Mono L", 0, 15));
        this.bereicheTextArea.setRows(4);
        this.jScrollPane1.setViewportView(this.bereicheTextArea);
        this.jLabel1.setText("Speicherbereiche:");
        this.progStartTextfield.setFont(new Font("Nimbus Mono L", 0, 15));
        this.progStartTextfield.setText("0000");
        this.jLabel2.setText("Programmstart:");
        this.jLabel4.setText("Datei:");
        this.filenameTextField.setText("memdump.txt");
        this.saveButton.setText("Speichern");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveMemDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Abbrechen");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveMemDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.browseButton.setText("Suchen");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveMemDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.assemblerCheckBox.setText("save as Assembler");
        this.assemblerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveMemDialog.this.assemblerCheckBoxActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Bytes / Line:");
        this.jTextField1.setText("16");
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Ubuntu", 0, 12));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Strings:\n  \"0000-3FFF\nBinary:\n   @0000-3FFF\nHexadecimal:\n   0000-3FFF");
        this.jTextArea1.setBorder(null);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.saveButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2)).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.progStartTextfield, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assemblerCheckBox).addGap(0, 16, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filenameTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(52, 52, 52).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField1, -2, -1, -2))).addComponent(this.jScrollPane1).addComponent(this.jScrollPane2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.progStartTextfield, -2, -1, -2).addComponent(this.assemblerCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.filenameTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        FileNameExtensionFilter f = this.assemblerCheckBox.isSelected() ? new FileNameExtensionFilter("Assembler file (.asm)", "asm") : new FileNameExtensionFilter("Memory dumps (.txt)", "txt");
        fc.setFileFilter(f);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 1) {
            this.setVisible(false);
            return;
        }
        this.filenameTextField.setText(fc.getSelectedFile().getAbsolutePath());
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        int progStart = Assembler.hex2int(this.progStartTextfield.getText().trim());
        List<Bereich> bereiche = this.getBereiche();
        String filename = this.filenameTextField.getText().trim();
        if (this.assemblerCheckBox.isSelected()) {
            Memory.instance().saveToAssembler(filename, progStart, bereiche);
        } else {
            System.out.println("Saving...");
            Memory.instance().saveToFile(filename, progStart, bereiche, new Integer(this.jTextField1.getText()));
        }
        lastFileName = filename;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void assemblerCheckBoxActionPerformed(ActionEvent evt) {
        String e;
        String fn = this.filenameTextField.getText();
        String string = e = this.assemblerCheckBox.isSelected() ? ".asm" : ".txt";
        if (!fn.endsWith(e)) {
            int i = fn.lastIndexOf(46);
            if (i >= 0) {
                fn = fn.substring(0, i);
            }
            fn = fn + e;
            this.filenameTextField.setText(fn);
        }
    }

    List<Bereich> getBereiche() {
        ArrayList<Bereich> e = new ArrayList<Bereich>();
        String s = this.bereicheTextArea.getText().trim().toLowerCase();
        StringReader sr = new StringReader(s);
        try {
            int c = sr.read();
            while (c != -1) {
                int start;
                while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                    c = sr.read();
                }
                Assembler.DefType type = Assembler.DefType.HexadecimalType;
                if (c == 34) {
                    type = Assembler.DefType.StringType;
                    c = sr.read();
                    while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                        c = sr.read();
                    }
                } else if (c == 64) {
                    type = Assembler.DefType.BinaryType;
                    c = sr.read();
                    while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                        c = sr.read();
                    }
                }
                if (c == -1) {
                    return e;
                }
                String h1 = "";
                while (c != -1 && (c >= 48 && c <= 57 || c >= 97 && c <= 102)) {
                    h1 = h1 + (char)c;
                    c = sr.read();
                }
                int end = start = Assembler.hex2int(h1);
                while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                    c = sr.read();
                }
                if (c == 45) {
                    c = sr.read();
                    while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                        c = sr.read();
                    }
                    String h2 = "";
                    while (c != -1 && (c >= 48 && c <= 57 || c >= 97 && c <= 102)) {
                        h2 = h2 + (char)c;
                        c = sr.read();
                    }
                    end = Assembler.hex2int(h2);
                }
                e.add(new Bereich(start, end, type));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return e;
        }
        return e;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SaveMemDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SaveMemDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SaveMemDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SaveMemDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveMemDialog dialog = new SaveMemDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class StartadresseVerifier
    extends InputVerifier {
        StartadresseVerifier() {
        }

        @Override
        public boolean verify(JComponent jc) {
            JTextField ta = (JTextField)jc;
            String s = ta.getText().trim().toLowerCase();
            StringReader sr = new StringReader(s);
            try {
                int c = sr.read();
                while (c != -1) {
                    if (c < 48 || c > 57 && c < 97 || c > 102) {
                        JOptionPane.showMessageDialog(null, "Hexadezimale Adresse erwartet.");
                        return false;
                    }
                    c = sr.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }

    class BereicheVerifier
    extends InputVerifier {
        BereicheVerifier() {
        }

        @Override
        public boolean verify(JComponent jc) {
            JTextArea ta = (JTextArea)jc;
            String s = ta.getText().trim().toLowerCase();
            StringReader sr = new StringReader(s);
            try {
                int c = sr.read();
                while (c != -1) {
                    while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                        c = sr.read();
                    }
                    Assembler.DefType type = Assembler.DefType.HexadecimalType;
                    if (c == 34) {
                        type = Assembler.DefType.StringType;
                        c = sr.read();
                        while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                            c = sr.read();
                        }
                    } else if (c == 64) {
                        type = Assembler.DefType.BinaryType;
                        c = sr.read();
                        while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                            c = sr.read();
                        }
                    }
                    if (c == -1) {
                        return true;
                    }
                    if (c < 48 || c > 57 && c < 97 || c > 102) {
                        JOptionPane.showMessageDialog(null, "Hexadezimale Start-Adresse erwartet. Bitte Bereiche in der Form '01ab-F4C3' eingeben.");
                        return false;
                    }
                    while (c != -1 && (c >= 48 && c <= 57 || c >= 97 && c <= 102)) {
                        c = sr.read();
                    }
                    while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                        c = sr.read();
                    }
                    if (c == -1) {
                        return true;
                    }
                    if (c != 45) continue;
                    c = sr.read();
                    while (c != -1 && (c == 32 || c == 10 || c == 9)) {
                        c = sr.read();
                    }
                    if (c == -1) {
                        return true;
                    }
                    if (c < 48 || c > 57 && c < 97 || c > 102) {
                        JOptionPane.showMessageDialog(null, "Hexadezimale End-Adresse erwartet. Bitte Bereiche in der Form '01ab-F4C3' eingeben.");
                        return false;
                    }
                    while (c != -1 && (c >= 48 && c <= 57 || c >= 97 && c <= 102)) {
                        c = sr.read();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }
}

