/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.Note;
import achtbit.Sound;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public class SoundThread
extends Thread {
    private List<Note> soundList = new LinkedList<Note>();
    private boolean finished = true;
    private Receiver rcvr = null;
    private boolean alive;
    private static SoundThread uniqueInstance = null;

    private SoundThread() {
        try {
            this.rcvr = MidiSystem.getReceiver();
        }
        catch (MidiUnavailableException e1) {
            System.out.println("Sound: error getting the default MIDI receiver.");
        }
        this.start();
    }

    public static SoundThread instance() {
        if (uniqueInstance == null) {
            uniqueInstance = new SoundThread();
        }
        return uniqueInstance;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void awaitSongEnd() {
        while (!this.isFinished()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void kill() {
        this.alive = false;
        this.notify();
    }

    public synchronized void append(Note note) {
        this.soundList.add(note);
        this.finished = false;
        this.notify();
    }

    public synchronized void clear() {
        this.soundList.clear();
        this.finished = true;
        this.notify();
    }

    public synchronized Note getNext() {
        while (this.alive && this.soundList.isEmpty()) {
            this.finished = true;
            this.notify();
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (!this.alive) {
            return null;
        }
        Note note = this.soundList.remove(0);
        return note;
    }

    @Override
    public void run() {
        this.alive = true;
        while (this.alive) {
            Note note = this.getNext();
            if (!this.alive) {
                return;
            }
            if (this.rcvr == null) continue;
            ShortMessage myMsg = new ShortMessage();
            try {
                myMsg.setMessage(144, 0, note.getNote(), note.getLoudness());
                this.rcvr.send(myMsg, -1L);
            }
            catch (InvalidMidiDataException e3) {
                System.out.println("Error in start Midi-Message!");
            }
            try {
                int ms = 60000 / Sound.getBpm() * 4;
                SoundThread.sleep(ms * note.getLength() / note.getLengthUnit());
            }
            catch (InterruptedException e) {
                System.out.println("sleep interrupted");
            }
            try {
                myMsg.setMessage(128, 0, note.getNote(), note.getLoudness());
                this.rcvr.send(myMsg, -1L);
            }
            catch (InvalidMidiDataException e3) {
                System.out.println("Error in stop Midi-Message!");
            }
        }
        if (this.rcvr != null) {
            this.rcvr.close();
        }
    }

    public static void main(String[] args) {
        SoundThread sound = new SoundThread();
        for (int i = 0; i < 4; ++i) {
            sound.append(new Note(60, 2, 4, 100));
            sound.append(new Note(62, 1, 4, 90));
            sound.append(new Note(62, 1, 4, 90));
        }
        System.out.println("Waiting for song end");
        sound.awaitSongEnd();
        System.out.println("kill Thread");
        sound.kill();
        System.out.println("killed...");
    }
}

