/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.Command;
import achtbit.Memory;
import achtbit.Storage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Assembler {
    private int adress;
    private Map<String, Integer> commandNames;
    private Map<String, Integer> flagNames;
    private Map<String, Integer> regNames;
    private Map<String, Integer> symbolTable;
    private Map<Integer, String> unresolvedSymbols;
    private Map<Integer, String> unresolvedJrSymbols;

    public Assembler() {
        this(0);
    }

    public Assembler(int adress) {
        this.adress = adress;
        this.commandNames = new HashMap<String, Integer>();
        this.commandNames.put("NOP", 0);
        this.commandNames.put("HLT", 1);
        this.commandNames.put("CLC", 2);
        this.commandNames.put("SETC", 4);
        this.commandNames.put("RETI", 3);
        this.commandNames.put("LD", 8);
        this.commandNames.put("ADD", 16);
        this.commandNames.put("ADC", 20);
        this.commandNames.put("SUB", 24);
        this.commandNames.put("SBC", 28);
        this.commandNames.put("MUL", 32);
        this.commandNames.put("DIV", 36);
        this.commandNames.put("AND", 40);
        this.commandNames.put("OR", 44);
        this.commandNames.put("XOR", 48);
        this.commandNames.put("CMP", 52);
        this.commandNames.put("MOD", 56);
        this.commandNames.put("JP", 64);
        this.commandNames.put("JR", 80);
        this.commandNames.put("CALL", 72);
        this.commandNames.put("RET", 88);
        this.commandNames.put("PUSH", 96);
        this.commandNames.put("POP", 112);
        this.commandNames.put("SHL", 128);
        this.commandNames.put("SHR", 144);
        this.commandNames.put("RHL", 160);
        this.commandNames.put("RHR", 176);
        this.commandNames.put("INC", 192);
        this.commandNames.put("DEC", 208);
        this.commandNames.put("IN", 224);
        this.commandNames.put("OUT", 240);
        this.flagNames = new HashMap<String, Integer>();
        this.flagNames.put("", 0);
        this.flagNames.put("Z", 1);
        this.flagNames.put("C", 2);
        this.flagNames.put("P", 3);
        this.flagNames.put("NZ", 5);
        this.flagNames.put("NC", 6);
        this.flagNames.put("NP", 7);
        this.regNames = new HashMap<String, Integer>();
        this.regNames.put("A", 1);
        this.regNames.put("F", 0);
        this.regNames.put("AF", 10);
        this.regNames.put("B", 3);
        this.regNames.put("C", 2);
        this.regNames.put("BC", 11);
        this.regNames.put("D", 5);
        this.regNames.put("E", 4);
        this.regNames.put("DE", 12);
        this.regNames.put("H", 7);
        this.regNames.put("L", 6);
        this.regNames.put("HL", 13);
        this.regNames.put("SPH", 9);
        this.regNames.put("SPL", 8);
        this.regNames.put("SP", 14);
        this.regNames.put("IX", 15);
        this.symbolTable = new HashMap<String, Integer>();
        this.unresolvedSymbols = new HashMap<Integer, String>();
        this.unresolvedJrSymbols = new HashMap<Integer, String>();
    }

    public int getAdress() {
        return this.adress;
    }

    public void setAdress(int adress) {
        this.adress = adress;
    }

    public static int bin2int(String bin) {
        int e = 0;
        for (int i = 0; i < bin.length(); ++i) {
            char c = bin.charAt(i);
            if (c != '0' && c != '1' && c != '-' && c != '*') continue;
            e <<= 1;
            if (c != '1' && c != '*') continue;
            ++e;
        }
        return e;
    }

    public static String long2hex(long value, int n) {
        String e = "";
        while (n > 0) {
            long d = value & 0xFL;
            value /= 16L;
            e = (char)(d < 10L ? d + 48L : d - 10L + 65L) + e;
            --n;
        }
        return e;
    }

    public static String int2hex(int value, int n) {
        value &= 0xFFFF;
        String e = "";
        while (n > 0) {
            int d = value & 0xF;
            value /= 16;
            e = (char)(d < 10 ? d + 48 : d - 10 + 65) + e;
            --n;
        }
        return e;
    }

    public static int hex2int(String hex) {
        int e = 0;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c >= '0' && c <= '9') {
                e = (e << 4) + c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                e = (e << 4) + c - 97 + 10;
                continue;
            }
            if (c < 'A' || c > 'F') continue;
            e = (e << 4) + c - 65 + 10;
        }
        return e;
    }

    public static int dez2int(String dez) {
        int e = 0;
        boolean neg = dez.startsWith("-");
        for (int i = 0; i < dez.length(); ++i) {
            char c = dez.charAt(i);
            if (c < '0' || c > '9') continue;
            e = e * 10 + c - 48;
        }
        if (neg) {
            if (e > 128) {
                return 65536 - e;
            }
            return 256 - e;
        }
        return e;
    }

    public static String int2bin(int value, int n) {
        value &= 0xFFFF;
        String e = "";
        while (n > 0) {
            int d = value & 1;
            value >>= 1;
            e = (char)(d + 48) + e;
            --n;
        }
        return e;
    }

    public static String int2dez(int value, int n) {
        value &= 0xFFFF;
        String e = "";
        while (n > 0) {
            int d = value % 10;
            value /= 10;
            e = (char)(48 + d) + e;
            --n;
        }
        return e;
    }

    public String com2String(int com) {
        for (String s : this.commandNames.keySet()) {
            if (this.commandNames.get(s) != com) continue;
            return s;
        }
        return "[" + Assembler.int2hex(com, 2) + "]";
    }

    public String reg2String(int reg) {
        for (String s : this.regNames.keySet()) {
            if (this.regNames.get(s) != reg) continue;
            return s;
        }
        return "?" + Assembler.int2hex(reg, 1) + "?";
    }

    public String flag2String(int flag) {
        for (String s : this.flagNames.keySet()) {
            if (this.flagNames.get(s) != flag) continue;
            return s;
        }
        return "?" + Assembler.int2hex(flag, 1) + "?";
    }

    public static int abs(int x) {
        return x < 0 ? -x : x;
    }

    public String dest2String(Storage storage) {
        int type = storage.getStoreType();
        int dest = storage.getDestination();
        switch (type) {
            case 4: {
                return "(0x" + Assembler.int2hex(dest, 4) + ")";
            }
            case 5: 
            case 6: {
                if (dest == 15) {
                    return "(" + this.reg2String(dest) + (storage.getOffset() >= 0 ? "+" : "-") + "0x" + Assembler.int2hex(Assembler.abs(storage.getOffset()), 2) + ")";
                }
                return "(" + this.reg2String(dest) + ")";
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.reg2String(dest);
            }
        }
        return "?" + Assembler.int2hex(dest, storage.isByte() ? 2 : 4) + "?";
    }

    public String src2String(Storage storage) {
        int type = storage.getStoreType();
        int src = storage.getSource();
        switch (type) {
            case 1: 
            case 6: {
                return "0x" + Assembler.int2hex(src, storage.isByte() ? 2 : 4);
            }
            case 2: {
                return "(0x" + Assembler.int2hex(src, 4) + ")";
            }
            case 0: 
            case 4: 
            case 5: {
                return this.reg2String(src);
            }
            case 3: {
                if (src == 15) {
                    return "(" + this.reg2String(src) + (storage.getOffset() >= 0 ? "+" : "-") + "0x" + Assembler.int2hex(Assembler.abs(storage.getOffset()), 2) + ")";
                }
                return "(" + this.reg2String(src) + ")";
            }
        }
        return "?" + Assembler.int2hex(src, storage.isByte() ? 2 : 4) + "?";
    }

    public String dasmDefh(int width) {
        String e = "";
        for (int i = 0; i < width; ++i) {
            if (i != 0) {
                e = e + " ";
            }
            e = e + "0x" + Assembler.int2hex(Memory.instance().getByte(this.adress), 2);
            ++this.adress;
        }
        e = e + "\n";
        return e;
    }

    public String dasmDefb(int width) {
        String e = "";
        for (int i = 0; i < width; ++i) {
            if (i != 0) {
                e = e + " ";
            }
            e = e + "@" + Assembler.int2bin(Memory.instance().getByte(this.adress), 8);
            ++this.adress;
        }
        e = e + "\n";
        return e;
    }

    public String dasmDefs(int width) {
        String e = "";
        boolean cite = false;
        for (int i = 0; i < width; ++i) {
            int c = Memory.instance().getByte(this.adress);
            if (c < 32 || c == 127 || c == 155 || c == 34) {
                if (cite) {
                    e = e + "\" ";
                }
                e = e + "0x" + Assembler.int2hex(c, 2) + " ";
                cite = false;
            } else {
                if (!cite) {
                    e = e + "\"";
                    cite = true;
                }
                e = e + (char)c;
            }
            ++this.adress;
        }
        if (cite) {
            e = e + "\"";
        }
        e = e + "\n";
        return e;
    }

    public String dasmDef(DefType type, int width, boolean outAdr) {
        String e = "";
        if (outAdr) {
            e = e + "0x" + Assembler.int2hex(this.adress, 4) + ". ";
        }
        e = e + "db ";
        switch (type) {
            case BinaryType: {
                return e + this.dasmDefb(width);
            }
            case HexadecimalType: {
                return e + this.dasmDefh(width);
            }
            case StringType: {
                return e + this.dasmDefs(width);
            }
        }
        return e + this.dasmDefh(width);
    }

    public String dasmDef(int adress, DefType type, int width, boolean outAdr) {
        this.adress = adress;
        return this.dasmDef(type, width, outAdr);
    }

    public String dasm(int adress) {
        this.adress = adress;
        return this.dasm();
    }

    public String dasm() {
        String e = "";
        Command command = new Command(this.adress);
        e = e + this.com2String(command.getCom());
        switch (command.getCom()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 8: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: {
                e = e + " " + this.dest2String(command.getStorage()) + "," + this.src2String(command.getStorage());
                break;
            }
            case 64: 
            case 72: {
                String fl = this.flag2String(command.getStorage().getFlags());
                if (!fl.equals("")) {
                    e = e + " " + fl;
                }
                e = e + " 0x" + Assembler.int2hex(command.getStorage().getSource(), 4);
                break;
            }
            case 80: {
                int d;
                String fl = this.flag2String(command.getStorage().getFlags());
                if (!fl.equals("")) {
                    e = e + " " + fl;
                }
                if ((d = command.getStorage().getSource()) > 127) {
                    d -= 256;
                }
                e = e + " 0x" + Assembler.int2hex(command.getAdress() + d, 4);
                break;
            }
            case 88: {
                String fl = this.flag2String(command.getStorage().getFlags());
                if (fl.equals("")) break;
                e = e + " " + fl;
                break;
            }
            case 96: 
            case 112: 
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 192: 
            case 208: {
                e = e + " " + this.reg2String(command.getStorage().getSource());
                break;
            }
            case 224: {
                e = e + " " + this.reg2String(command.getStorage().getDestination()) + ",(" + Assembler.int2hex(command.getStorage().getSource(), 2) + ")";
                break;
            }
            case 240: {
                e = e + " (" + Assembler.int2hex(command.getStorage().getDestination(), 2) + ")," + this.reg2String(command.getStorage().getSource());
                break;
            }
        }
        this.adress = command.getAdress();
        return e;
    }

    public int str2com(String s) {
        String t = s.toUpperCase().trim();
        if (this.commandNames.containsKey(t)) {
            return this.commandNames.get(t);
        }
        throw new IllegalArgumentException("Command " + t + " does not exist.");
    }

    public int str2reg(String s) {
        String t = s.toUpperCase();
        if (this.regNames.containsKey(t)) {
            return this.regNames.get(t);
        }
        throw new IllegalArgumentException("Unknown register " + t);
    }

    public int str2flag(String s) {
        String t = s.toUpperCase();
        if (this.flagNames.containsKey(t)) {
            return this.flagNames.get(t);
        }
        throw new IllegalArgumentException("Unknown flag " + t);
    }

    public static boolean isLiteral(String s) {
        if (s == null || s.length() < 1) {
            return false;
        }
        return s.charAt(0) >= '0' && s.charAt(0) <= '9' || s.charAt(0) == '-' || s.charAt(0) == '@' || s.toUpperCase().startsWith("0X") || s.startsWith("'") || s.startsWith("\"") || s.endsWith(":");
    }

    public static boolean constIsByte(String s) {
        if (s.equals("")) {
            return true;
        }
        if (s.toUpperCase().startsWith("0X")) {
            return s.length() <= 4;
        }
        if (s.startsWith("@")) {
            return s.length() <= 10;
        }
        if (s.startsWith("'")) {
            return true;
        }
        if (s.endsWith(":")) {
            return false;
        }
        return Assembler.dez2int(s) <= 255;
    }

    public int str2const(String s) {
        if (s.equals("")) {
            return 0;
        }
        if (s.endsWith(":")) {
            if (this.symbolTable.containsKey(s)) {
                return this.symbolTable.get(s);
            }
            return -1;
        }
        if (s.toUpperCase().startsWith("0X")) {
            return Assembler.hex2int(s.substring(2));
        }
        if (s.startsWith("@")) {
            return Assembler.bin2int(s.substring(1));
        }
        if (s.startsWith("'")) {
            return s.charAt(1);
        }
        return Assembler.dez2int(s);
    }

    public Storage str2storage(String dest, String src) {
        String ofs;
        if (src.equals("")) {
            throw new IllegalArgumentException("missing source");
        }
        int source = 0;
        int destination = 0;
        int sourceType = -1;
        int destinationType = -1;
        int offset = 0;
        String pd = dest;
        String ps = src;
        if (!pd.equals("")) {
            destinationType = 0;
            if (pd.charAt(0) == '(') {
                if (pd.charAt(pd.length() - 1) != ')') {
                    throw new IllegalArgumentException("Wrong syntax '" + pd + "': missing ')'.");
                }
                if ((pd = pd.substring(1, pd.length() - 1)).length() > 2 && (pd.charAt(2) == '+' || pd.charAt(2) == '-')) {
                    ofs = pd.substring(3);
                    offset = this.str2const(ofs);
                    if (pd.charAt(2) == '-') {
                        offset = -offset;
                    }
                    pd = pd.substring(0, 2);
                }
                destinationType = 2;
            }
            if (Assembler.isLiteral(pd)) {
                destination = this.str2const(pd);
            } else {
                destination = this.str2reg(pd);
                ++destinationType;
            }
        }
        sourceType = 0;
        if (ps.charAt(0) == '(') {
            if (ps.charAt(ps.length() - 1) != ')') {
                throw new IllegalArgumentException("Wrong systax '" + ps + "': missing ')'.");
            }
            if ((ps = ps.substring(1, ps.length() - 1)).length() > 2 && (ps.charAt(2) == '+' || ps.charAt(2) == '-')) {
                ofs = ps.substring(3);
                offset = this.str2const(ofs);
                if (ps.charAt(2) == '-') {
                    offset = -offset;
                }
                ps = ps.substring(0, 2);
            }
            sourceType = 2;
        }
        if (Assembler.isLiteral(ps)) {
            source = this.str2const(ps);
        } else {
            source = this.str2reg(ps);
            ++sourceType;
        }
        int storageType = 0;
        block0 : switch (destinationType) {
            case 0: {
                throw new IllegalArgumentException("Destination must not be a constant!");
            }
            case 2: {
                switch (sourceType) {
                    case 1: {
                        storageType = 4;
                        break block0;
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        throw new IllegalArgumentException("(adress) must be followed by a register!");
                    }
                }
                throw new IllegalArgumentException("Missing source!");
            }
            case 3: {
                switch (sourceType) {
                    case 0: {
                        storageType = 6;
                        break block0;
                    }
                    case 1: {
                        storageType = 5;
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        throw new IllegalArgumentException("(adress) must be followed by a constant or a register!");
                    }
                }
                throw new IllegalArgumentException("Missing source!");
            }
            default: {
                switch (sourceType) {
                    case 0: {
                        storageType = 1;
                        break block0;
                    }
                    case 1: {
                        storageType = 0;
                        break block0;
                    }
                    case 2: {
                        storageType = 2;
                        break block0;
                    }
                    case 3: {
                        storageType = 3;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Missing source!");
            }
        }
        Storage stor = new Storage(storageType, destination, source);
        stor.setOffset(offset);
        return stor;
    }

    public static int storeString(String s, int adr) {
        int adresse = adr;
        for (int i = 0; i < s.length(); ++i) {
            Memory.instance().setByte(adresse, s.charAt(i));
            ++adresse;
        }
        return adresse;
    }

    public int storeDef(String s, int adr) {
        return this.storeDef(s, adr, true);
    }

    public int storeDef(String s, int adr, boolean defByte) {
        int adresse = adr;
        Memory mem = Memory.instance();
        int p = 0;
        block0: while (p < s.length()) {
            char c = s.charAt(p);
            if (s.charAt(p) == ' ') {
                ++p;
                continue;
            }
            if (c == '\"' || c == '\'') {
                char bound = c;
                boolean masked = false;
                ++p;
                while (p < s.length()) {
                    c = s.charAt(p);
                    if (c == '\\') {
                        masked = true;
                    } else {
                        if (c == bound && !masked) {
                            ++p;
                            continue block0;
                        }
                        masked = false;
                        if (defByte) {
                            mem.setByte(adresse, c, true);
                            ++adresse;
                        } else {
                            mem.setWord(adresse, c, true);
                            adresse += 2;
                        }
                    }
                    ++p;
                }
                continue;
            }
            String s0 = "";
            while (p < s.length() && s.charAt(p) != ' ') {
                s0 = s0 + s.charAt(p);
                ++p;
            }
            int z = this.str2const(s0);
            if (z < 0) {
                this.unresolvedSymbols.put(adresse, s0);
                if (defByte) {
                    mem.setByte(adresse, 1, true);
                    ++adresse;
                    continue;
                }
                mem.setWord(adresse, 0, true);
                adresse += 2;
                continue;
            }
            if (defByte) {
                Memory.instance().setByte(adresse, z, true);
                ++adresse;
                continue;
            }
            Memory.instance().setWord(adresse, z, true);
            adresse += 2;
        }
        return adresse;
    }

    public int asm(String eingabe, int adr) {
        int adresse = adr;
        String e = eingabe.trim();
        String sadr = Assembler.int2hex(adresse, 4);
        int i = e.indexOf("//");
        if (i >= 0) {
            e = e.substring(0, i);
        }
        if (e.startsWith(".")) {
            String[] s = e.split("[\t ,]+");
            if (s[0].toLowerCase().equals(".org")) {
                if (s.length != 2) {
                    throw new IllegalArgumentException(sadr + ": Syntax is: '.org stor_adress'");
                }
                return this.str2const(s[1]);
            }
            if (s[0].toLowerCase().equals(".run")) {
                if (s.length != 2) {
                    throw new IllegalArgumentException(sadr + ": Syntax is: '.run start_adress'");
                }
                this.adress = this.str2const(s[1]);
                return adr;
            }
            if (s[0].toLowerCase().equals(".def")) {
                if (s.length != 3) {
                    throw new IllegalArgumentException(sadr + ": Syntax is: '.def label: value'");
                }
                String label = s[1];
                int value = this.str2const(s[2]);
                if (this.symbolTable.containsKey(label)) {
                    throw new IllegalArgumentException(sadr + ": Label '" + label + "' already defined.");
                }
                this.symbolTable.put(label, value);
                return adr;
            }
            throw new IllegalArgumentException(sadr + ": Unknown compiler command '" + s[0] + "'.");
        }
        if (e.length() > 4 && e.charAt(4) == '.') {
            adresse = Assembler.hex2int(e.substring(0, 4));
            e = e.substring(6);
        }
        for (i = 0; i < e.length() && e.charAt(i) != ':' && e.charAt(i) != ' '; ++i) {
        }
        if (i < e.length() && e.charAt(i) == ':') {
            String label = e.substring(0, i + 1).trim();
            if (this.symbolTable.containsKey(label)) {
                throw new IllegalArgumentException(sadr + ": Label '" + label + "' already defined.");
            }
            this.symbolTable.put(label, adresse);
            e = e.substring(i + 1).trim();
        }
        if (e.isEmpty()) {
            return adresse;
        }
        if (e.startsWith("db ")) {
            return this.storeDef(e.substring(3), adr);
        }
        if (e.startsWith("dw ")) {
            return this.storeDef(e.substring(3), adr, false);
        }
        String[] s = e.split("[\t ,]+");
        String command = s[0];
        int com = this.str2com(command);
        String pd = "";
        String ps = "";
        if (s.length == 2) {
            ps = s[1];
        } else if (s.length >= 3) {
            pd = s[1];
            ps = s[2];
        }
        Memory mem = Memory.instance();
        block0 : switch (com) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                mem.setByte(adresse, com, true);
                ++adresse;
                break;
            }
            case 8: {
                Storage storage = this.str2storage(pd, ps);
                mem.setByte(adresse, 8 + storage.getStoreType(), true);
                ++adresse;
                switch (storage.getStoreType()) {
                    case 0: {
                        mem.setByte(adresse, storage.getDestination() * 16 + storage.getSource(), true);
                        ++adresse;
                        break block0;
                    }
                    case 3: {
                        mem.setByte(adresse, storage.getDestination() * 16 + storage.getSource(), true);
                        ++adresse;
                        if (storage.getSource() != 15) break block0;
                        mem.setByte(adresse, storage.getOffset() + 128, true);
                        ++adresse;
                        break block0;
                    }
                    case 5: {
                        mem.setByte(adresse, storage.getDestination() * 16 + storage.getSource(), true);
                        ++adresse;
                        if (storage.getDestination() != 15) break block0;
                        mem.setByte(adresse, storage.getOffset() + 128, true);
                        ++adresse;
                        break block0;
                    }
                    case 1: {
                        mem.setByte(adresse, storage.getDestination(), true);
                        ++adresse;
                        if (storage.getSource() < 0) {
                            this.unresolvedSymbols.put(adresse, ps);
                            if (storage.isByte()) {
                                mem.setByte(adresse, 1, true);
                                ++adresse;
                                break block0;
                            }
                            mem.setWord(adresse, 0, true);
                            adresse += 2;
                            break block0;
                        }
                        if (storage.isByte()) {
                            mem.setByte(adresse, storage.getSource(), true);
                            ++adresse;
                            break block0;
                        }
                        mem.setWord(adresse, storage.getSource(), true);
                        adresse += 2;
                        break block0;
                    }
                    case 2: {
                        mem.setByte(adresse, storage.getDestination(), true);
                        ++adresse;
                        if (storage.getSource() < 0) {
                            this.unresolvedSymbols.put(adresse, ps);
                            mem.setWord(adresse, 0, true);
                            adresse += 2;
                            break block0;
                        }
                        mem.setWord(adresse, storage.getSource(), true);
                        adresse += 2;
                        break block0;
                    }
                    case 4: {
                        mem.setByte(adresse, storage.getSource(), true);
                        ++adresse;
                        if (storage.getDestination() < 0) {
                            this.unresolvedSymbols.put(adresse, pd);
                            mem.setWord(adresse, 0, true);
                            adresse += 2;
                            break block0;
                        }
                        mem.setWord(adresse, storage.getDestination(), true);
                        adresse += 2;
                        break block0;
                    }
                    case 6: {
                        mem.setByte(adresse, storage.getDestination(), true);
                        ++adresse;
                        if (storage.getDestination() == 15) {
                            mem.setByte(adresse, storage.getOffset() + 128, true);
                            ++adresse;
                        }
                        if (storage.getSource() < 0) {
                            this.unresolvedSymbols.put(adresse, ps);
                            if (storage.isByte()) {
                                mem.setByte(adresse, 1, true);
                                ++adresse;
                                break block0;
                            }
                            mem.setWord(adresse, 0, true);
                            adresse += 2;
                            break block0;
                        }
                        mem.setByte(adresse, storage.getSource(), true);
                        ++adresse;
                        break block0;
                    }
                }
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: {
                Storage storage = this.str2storage(pd, ps);
                mem.setByte(adresse, com + storage.getStoreType(), true);
                ++adresse;
                switch (storage.getStoreType()) {
                    case 0: {
                        mem.setByte(adresse, storage.getDestination() * 16 + storage.getSource(), true);
                        ++adresse;
                        break block0;
                    }
                    case 3: {
                        mem.setByte(adresse, storage.getDestination() * 16 + storage.getSource(), true);
                        ++adresse;
                        if (storage.getSource() != 15) break block0;
                        mem.setByte(adresse, storage.getOffset() + 128, true);
                        ++adresse;
                        break block0;
                    }
                    case 1: {
                        mem.setByte(adresse, storage.getDestination(), true);
                        ++adresse;
                        if (storage.getSource() < 0) {
                            this.unresolvedSymbols.put(adresse, ps);
                            if (storage.isByte()) {
                                mem.setByte(adresse, 1, true);
                                ++adresse;
                                break block0;
                            }
                            mem.setWord(adresse, 0, true);
                            adresse += 2;
                            break block0;
                        }
                        if (storage.isByte()) {
                            mem.setByte(adresse, storage.getSource(), true);
                            ++adresse;
                            break block0;
                        }
                        mem.setWord(adresse, storage.getSource(), true);
                        adresse += 2;
                        break block0;
                    }
                    case 2: {
                        mem.setByte(adresse, storage.getDestination(), true);
                        ++adresse;
                        if (storage.getSource() < 0) {
                            this.unresolvedSymbols.put(adresse, ps);
                            mem.setWord(adresse, 0, true);
                            adresse += 2;
                            break block0;
                        }
                        mem.setWord(adresse, storage.getSource(), true);
                        adresse += 2;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(sadr + ": destination must be a register!");
            }
            case 64: 
            case 72: {
                int flag = this.str2flag(pd);
                mem.setByte(adresse, com + flag, true);
                ++adresse;
                int u = this.str2const(ps);
                if (u < 0) {
                    this.unresolvedSymbols.put(adresse, ps);
                    mem.setWord(adresse, 0, true);
                    adresse += 2;
                    break;
                }
                mem.setWord(adresse, u, true);
                adresse += 2;
                break;
            }
            case 80: {
                int flag = this.str2flag(pd);
                mem.setByte(adresse, com + flag, true);
                ++adresse;
                int u = this.str2const(ps);
                if (u < 0) {
                    this.unresolvedJrSymbols.put(adresse, ps);
                    mem.setByte(adresse, 0, true);
                    ++adresse;
                    break;
                }
                int d = u - (adresse + 1);
                if (d < -128 || d > 127) {
                    throw new IllegalArgumentException(sadr + ": Relative Jump " + d + " is too far!");
                }
                if (d < 0) {
                    d += 256;
                }
                mem.setByte(adresse, d, true);
                ++adresse;
                break;
            }
            case 88: {
                int flag = this.str2flag(ps);
                mem.setByte(adresse, com + flag, true);
                ++adresse;
                break;
            }
            case 96: 
            case 112: 
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 192: 
            case 208: {
                mem.setByte(adresse, com + this.str2reg(ps), true);
                ++adresse;
                break;
            }
            case 224: {
                int reg = this.str2reg(pd);
                mem.setByte(adresse, com + reg, true);
                ++adresse;
                if (!ps.startsWith("(") || !ps.endsWith(")")) {
                    throw new IllegalArgumentException("'(port)' expected");
                }
                mem.setByte(adresse, this.str2const(ps.substring(1, ps.length() - 1)), true);
                ++adresse;
                break;
            }
            case 240: {
                int reg = this.str2reg(ps);
                mem.setByte(adresse, com + reg, true);
                ++adresse;
                if (!pd.startsWith("(") || !pd.endsWith(")")) {
                    throw new IllegalArgumentException("'(port)' expected");
                }
                mem.setByte(adresse, this.str2const(pd.substring(1, pd.length() - 1)), true);
                ++adresse;
                break;
            }
        }
        return adresse;
    }

    public void testAsm(String zeile) {
        int b = this.asm(zeile, this.adress);
        System.out.print(Assembler.int2hex(this.adress, 4) + " " + zeile + " -> ");
        for (int i = this.adress; i < b; ++i) {
            System.out.print(" " + Assembler.int2hex(Memory.instance().getByte(i), 2));
        }
        System.out.println(" -> " + this.dasm(this.adress));
        this.adress = b;
    }

    public void resolveLabels() {
        String label;
        Memory mem = Memory.instance();
        for (Integer i : this.unresolvedSymbols.keySet()) {
            label = this.unresolvedSymbols.get(i);
            if (label.startsWith("(")) {
                label = label.substring(1, label.length() - 1);
            }
            if (!this.symbolTable.containsKey(label)) {
                throw new IllegalArgumentException(Assembler.int2hex(i, 4) + ": Label '" + label + "' could not be found!");
            }
            if (mem.getByte(i) == 0) {
                mem.setWord(i, this.symbolTable.get(label), true);
                continue;
            }
            mem.setByte(i, this.symbolTable.get(label), true);
        }
        this.unresolvedSymbols.clear();
        for (Integer i : this.unresolvedJrSymbols.keySet()) {
            label = this.unresolvedJrSymbols.get(i);
            if (label.startsWith("(")) {
                label = label.substring(1, label.length() - 1);
            }
            if (!this.symbolTable.containsKey(label)) {
                throw new IllegalArgumentException(Assembler.int2hex(i, 4) + ": Label for relative jump '" + label + "' could not be found!");
            }
            int d = this.symbolTable.get(label) - (i + 1);
            if (d < -128 || d > 127) {
                throw new IllegalArgumentException(Assembler.int2hex(i, 4) + ": Relative Jump " + d + " is too far!");
            }
            if (d < 0) {
                d += 256;
            }
            mem.setByte(i, d, true);
        }
        this.unresolvedJrSymbols.clear();
    }

    public String labels2string() {
        String e = "";
        LinkedList<String> label = new LinkedList<String>();
        for (String l : this.symbolTable.keySet()) {
            label.add(".def " + l + " 0x" + Assembler.int2hex(this.symbolTable.get(l), 4));
        }
        Collections.sort(label);
        for (String l : label) {
            e = e + l + "\n";
        }
        return e;
    }

    public static void main(String[] args) {
        Assembler a = new Assembler();
        int adr = 0;
        adr = a.asm(".org 0x8000", adr);
        adr = a.asm(".run 0x8005", adr);
        adr = a.asm("jr start:", adr);
        adr = a.asm("LD (hl),0", adr);
        adr = a.asm("start:   ld hl,name:", adr);
        adr = a.asm("name:    db 'Christian' 0", adr);
        a.resolveLabels();
        System.out.print(a.dasmDef(32768, DefType.StringType, 8, true));
        System.out.print(a.dasmDef(DefType.StringType, 8, false));
        System.out.print(a.dasmDef(DefType.StringType, 8, false));
        System.out.print(a.dasmDef(DefType.StringType, 8, false));
    }

    public static enum DefType {
        BinaryType,
        HexadecimalType,
        StringType;

    }
}

