/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.AchtbitPanel;
import achtbit.Assembler;
import achtbit.Memory;
import achtbit.UpdateRequest;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class AssemblerPanel
extends JPanel
implements Observer,
AchtbitPanel {
    private int startAdress = 0;
    private Assembler assembler = new Assembler(this.startAdress);
    private UpdateRequest updateRequest;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public AssemblerPanel() {
        this.initComponents();
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.updateRequest = new UpdateRequest(this);
        Memory.instance().addObserver(this);
        this.update();
    }

    @Override
    public void paint(Graphics g) {
        this.drawMem(this.startAdress);
        super.paint(g);
    }

    @Override
    public void update() {
        this.repaint();
    }

    public int getStartAdress() {
        return this.startAdress;
    }

    public void setStartAdress(int startAdress) {
        this.startAdress = startAdress;
        this.update();
    }

    public int getMaxLines() {
        int maxLines = this.jTextArea1.getHeight() / this.jTextArea1.getFontMetrics(this.jTextArea1.getFont()).getHeight() - 1;
        return maxLines;
    }

    void drawMem(int adress) {
        this.assembler.setAdress(adress);
        String txt = "";
        int maxLines = this.getMaxLines();
        for (int i = 0; i < maxLines; ++i) {
            txt = txt + Assembler.int2hex(this.assembler.getAdress(), 4) + " " + this.assembler.dasm();
            if (i + 1 >= maxLines) continue;
            txt = txt + "\n";
        }
        this.jTextArea1.setText(txt);
    }

    @Override
    public void update(Observable o, Object o1) {
        if (!this.isVisible()) {
            return;
        }
        if (!(o instanceof Memory)) {
            return;
        }
        if (!(o1 instanceof Integer)) {
            return;
        }
        Memory mem = (Memory)o;
        int adr = (Integer)o1;
        if (adr < this.startAdress || adr >= this.startAdress + this.getMaxLines() * 4) {
            return;
        }
        if (this.updateRequest.isDone()) {
            this.updateRequest.setDone(false);
            EventQueue.invokeLater(this.updateRequest);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(15);
        this.jTextArea1.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00\n0000 - 00 00 00 00 00 00 00 00");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jTextField1.setFont(new Font("Monospaced", 0, 12));
        this.jTextField1.setText("0000");
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssemblerPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jTextField2.setFont(new Font("Monospaced", 0, 12));
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssemblerPanel.this.jTextField2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -1, 177, Short.MAX_VALUE)).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 368, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jTextField2, -2, -1, -2))));
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.setStartAdress(Assembler.hex2int(this.jTextField1.getText()));
        this.jTextField1.transferFocus();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        int adress = Assembler.hex2int(this.jTextField1.getText());
        String d = this.jTextField2.getText();
        Assembler asm = new Assembler();
        try {
            adress = asm.asm(d, adress);
            this.jTextField1.setText(Assembler.int2hex(adress, 4));
            this.jTextField2.setText("");
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        this.update();
    }
}

