/*
 * Decompiled with CFR 0.152.
 */
package achtbit;

import achtbit.Assembler;
import achtbit.Memory;

public class Storage {
    static final int RegisterRegister = 0;
    static final int RegisterConstant = 1;
    static final int RegisterAdress = 2;
    static final int RegisterPointer = 3;
    static final int AdressRegister = 4;
    static final int PointerRegister = 5;
    static final int PointerConstant = 6;
    private int storeType;
    private int destination;
    private int source;
    private int flags;
    private int offset;

    public Storage() {
        this.storeType = 0;
        this.destination = 0;
        this.source = 0;
        this.flags = 0;
    }

    public int init(int storeType, int adr) {
        this.storeType = storeType;
        int adress = adr;
        Memory mem = Memory.instance();
        switch (storeType) {
            case 4: {
                this.source = mem.getByte(adress);
                this.destination = mem.getWord(adress + 1);
                adress += 3;
                break;
            }
            case 0: {
                this.source = mem.getByte(adress) & 0xF;
                this.destination = mem.getByte(adress) / 16;
                ++adress;
                break;
            }
            case 5: {
                this.source = mem.getByte(adress) & 0xF;
                this.destination = mem.getByte(adress) / 16;
                ++adress;
                if (this.destination != 15) break;
                this.offset = mem.getByte(adress) - 128;
                ++adress;
                break;
            }
            case 3: {
                this.source = mem.getByte(adress) & 0xF;
                this.destination = mem.getByte(adress) / 16;
                ++adress;
                if (this.source != 15) break;
                this.offset = mem.getByte(adress) - 128;
                ++adress;
                break;
            }
            case 6: {
                this.destination = mem.getByte(adress);
                ++adress;
                if (this.destination == 15) {
                    this.offset = mem.getByte(adress) - 128;
                    ++adress;
                }
                this.source = mem.getByte(adress);
                ++adress;
                break;
            }
            case 1: {
                this.destination = mem.getByte(adress);
                if (this.destination < 10) {
                    this.source = mem.getByte(adress + 1);
                } else {
                    this.source = mem.getWord(adress + 1);
                    ++adress;
                }
                adress += 2;
                break;
            }
            case 2: {
                this.destination = mem.getByte(adress);
                this.source = mem.getWord(adress + 1);
                adress += 3;
                break;
            }
            default: {
                this.source = 0;
                this.destination = 0;
            }
        }
        this.flags = 0;
        return adress;
    }

    public Storage(int storeType, int destination, int source) {
        this.storeType = storeType;
        this.destination = destination;
        this.source = source;
        this.flags = 0;
    }

    public Storage(int storeType, int source) {
        this.storeType = storeType;
        this.destination = source;
        this.source = source;
        this.flags = 0;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean tryFlags() {
        return Memory.instance().hasFlag(this.flags);
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isByte() {
        switch (this.storeType) {
            case 0: 
            case 4: 
            case 5: {
                return this.source < 10;
            }
            case 1: 
            case 2: 
            case 3: {
                return this.destination < 10;
            }
            case 6: {
                return true;
            }
        }
        return true;
    }

    public boolean isWord() {
        return !this.isByte();
    }

    public int get() {
        Memory mem = Memory.instance();
        switch (this.storeType) {
            case 0: 
            case 4: 
            case 5: {
                return mem.getReg(this.source);
            }
            case 3: {
                if (this.source == 15) {
                    return mem.getWord(mem.getReg(this.source) + this.offset);
                }
                return mem.getWord(mem.getReg(this.source));
            }
            case 1: 
            case 6: {
                return this.source;
            }
            case 2: {
                if (this.isByte()) {
                    return mem.getByte(this.source);
                }
                return mem.getWord(this.source);
            }
        }
        return 0;
    }

    public int getMinus() {
        return this.minus(this.get());
    }

    public int minus(int e) {
        if (this.isByte()) {
            return 512 - e;
        }
        return 131072 - e;
    }

    public int dec(int value) {
        if (value > 0) {
            return value - 1;
        }
        return this.minus(-(value - 1));
    }

    public void set(int val) {
        Memory mem = Memory.instance();
        int value = val;
        while (value < 0) {
            if (this.isByte()) {
                value += 256;
                continue;
            }
            value += 65536;
        }
        int pointer = 0;
        switch (this.storeType) {
            case 4: {
                if (this.source < 10) {
                    mem.setByte(this.destination, value);
                    break;
                }
                mem.setWord(this.destination, value);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                mem.setReg(this.destination, value);
                break;
            }
            case 5: {
                pointer = mem.getReg(this.destination);
                if (this.destination == 15) {
                    pointer += this.offset;
                }
                if (this.source < 10) {
                    mem.setByte(pointer, value);
                    break;
                }
                mem.setWord(pointer, value);
                break;
            }
            case 6: {
                if (this.destination == 15) {
                    mem.setByte(mem.getReg(this.destination) + this.offset, value);
                    break;
                }
                mem.setByte(mem.getReg(this.destination), value);
                break;
            }
        }
    }

    public void checkAndSetFlags(int val) {
        Memory mem = Memory.instance();
        if (this.isByte()) {
            mem.setCFlag(val < 0 || val > 255);
        } else {
            mem.setCFlag(val < 0 || val > 65535);
        }
        int value = val;
        while (value < 0) {
            if (this.isByte()) {
                value += 256;
                continue;
            }
            value += 65536;
        }
        mem.setPFlag((value & 1) == 0);
        switch (this.storeType) {
            case 4: {
                if (this.source < 10) {
                    mem.setZFlag((value & 0xFF) == 0);
                    break;
                }
                mem.setZFlag((value & 0xFFFF) == 0);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (this.destination < 10) {
                    mem.setZFlag((value & 0xFF) == 0);
                    break;
                }
                mem.setZFlag((value & 0xFFFF) == 0);
                break;
            }
            case 5: {
                if (this.source < 10) {
                    mem.setZFlag((value & 0xFF) == 0);
                    break;
                }
                mem.setZFlag((value & 0xFFFF) == 0);
                break;
            }
            case 6: {
                mem.setCFlag(value > 65535);
                break;
            }
        }
    }

    public int getDestinationValue() {
        Memory mem = Memory.instance();
        switch (this.storeType) {
            case 4: {
                if (this.source < 10) {
                    return mem.getByte(this.destination);
                }
                return mem.getWord(this.destination);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return mem.getReg(this.destination);
            }
            case 5: {
                if (this.destination == 15) {
                    return mem.getByte(mem.getReg(this.destination) + this.offset);
                }
                if (this.source < 10) {
                    return mem.getByte(this.destination);
                }
                return mem.getWord(this.destination);
            }
            case 6: {
                if (this.destination == 15) {
                    return mem.getByte(mem.getReg(this.destination) + this.offset);
                }
                return mem.getWord(mem.getReg(this.destination));
            }
        }
        return 0;
    }

    public int getStoreType() {
        return this.storeType;
    }

    public void setStoreType(int storeType) {
        this.storeType = storeType;
    }

    public int getDestination() {
        return this.destination;
    }

    public void setDestination(int destination) {
        this.destination = destination;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public String toString() {
        return "storetype=" + Assembler.int2hex(this.storeType, 2) + " dest=" + Assembler.int2hex(this.destination, 4) + " src=" + Assembler.int2hex(this.source, 4) + " flags=" + Assembler.int2hex(this.flags, 2);
    }
}

