// ************************** S N A K E ****************************

.import ../roms/achtBit_rom

.org 0x4000

.include snake_charset

.run 0x4000
.org 0x4000

snake:
	CALL snake_init:
snake_loop_intro:
	CALL snake_intro_screen:
snake_loop1:
	CALL snake_sound_stop:
	CALL snake_main_menu: 
snake_loop1a:
	// returns A=menu option
	// 0=new game
	// 1=view highscore
	// 2=customize keys
	OR A,A // ==0?
	JR NZ snake_next1:
	// start a new game
	CALL snake_init_player:
	CALL snake_game_loop:
	JR snake_loop1:
snake_next1:
	DEC A // ==1?
	JR NZ snake_next2:
	CALL snake_highscore_table_display:
	JR snake_loop1:

snake_next2:
	DEC A // ==1?
	JR NZ snake_next3:
	CALL snake_customize_keys:
	JR snake_loop1:

snake_next3:
	DEC A // ==2?
	JR NZ snake_next7:
	LD HL,(snake_main_menu_difficulty:)
	CMP HL,snake_string_beginner:
	JR NZ snake_next4:
	LD HL,snake_string_intermediate:
	LD A,5
	JR snake_next6:
snake_next4:
	CMP HL,snake_string_intermediate:
	JR NZ snake_next5:
	LD HL,snake_string_advanced:
	LD A,3
	JR snake_next6:
snake_next5:
	LD HL,snake_string_beginner:
	LD A,10
snake_next6:
	LD (snake_main_menu_difficulty:),HL
	LD (snake_delay:),A
	CALL snake_main_menu_continue:
	JR snake_loop1a:
snake_next7:
	DEC A // == 3?
	JR NZ snake_loop1:
	JR snake_loop_intro:

.include ../irishTunes
.include snake_sound
.include snake_intro_screen
.include snake_help_screen
.include snake_gameover_screen
.include snake_winner_screen
.include snake_menu
.include snake_display
.include snake_highscore
.include snake_display_level
.include snake_control
.include snake_snake
.include snake_level
.include snake_screen
.include snake_fruit

// *************************** game loop **********************
snake_game_loop:
	CALL snake_level_intro_screen:
	CALL snake_game_init:
snake_game_loop_loop1:
	LD A,(snake_table:) // player active?
	OR A,A
	JR Z snake_game_loop_death:
	// check if any fruits left
	LD A,(snake_fruit_count:)
	OR A,A
	JR NZ snake_game_loop_loop1:
// next level
	CALL snake_game_stop:
	LD A,(snake_lost_a_snake:)
	OR A,A
	JR NZ snake_game_loop_next1:
	LD A,(snake_player_lives:)
	CMP A,5
	JR Z snake_game_loop_next1:
	INC A
	LD (snake_player_lives:),A
snake_game_loop_next1:	
	LD A,(snake_player_level:)
	INC A
	LD (snake_player_level:),A
	CMP A,snake_max_level:
	JP NZ snake_game_loop:
	CALL snake_winner_screen:

snake_game_loop_stop:
	CALL snake_game_stop:
	CALL snake_highscore_new:
	CALL snake_highscore_table_display:
	RET

snake_game_loop_death:
	// no lives left?
	LD A,(snake_player_lives:)
	OR A,A
	JR Z snake_game_over:
	DEC A
	LD (snake_player_lives:),A
	CALL snake_display_lives:
	LD A,1
	LD (snake_lost_a_snake:),A
	// else start a new snake
	LD B,(snake_player_level:)
	CALL snake_get_level_index:
	LD HL,(IX+1)
	LD A,(IX+3)
	LD DE,0
	LD C,2
	CALL snake_new_snake:
	JP snake_game_loop_loop1:	


snake_game_over:
	CALL snake_game_stop:
	CALL snake_gameover_screen:
	CALL snake_highscore_new:
	CALL snake_highscore_table_display:
	RET

// ***************** init ****************

snake_init:
	
	CALL snake_highscore_table_init:
	// screen mode text
	xor a,a
	LD (sys_screen_mode:),a
	
	// cursor off
	LD (sys_enable_cursor:),a
	
	// game off
	LD (snake_game_is_running:),A

	// keys
	LD A,'w'
	LD (snake_player_key_up:),A
	LD A,'s'
	LD (snake_player_key_down:),A
	LD A,'a'
	LD (snake_player_key_left:),A
	LD A,'d'
	LD (snake_player_key_right:),A
	LD A,0x20
	LD (snake_player_key_action:),A
	
	// interrupt (50 Hz)
	LD HL,sys_screen_interrupt:
	INC HL
	LD DE,snake_interrupt_loop:
	LD (HL),DE
	DEC HL
	LD (HL),0x40
	
	RET

// ********************* init player *******************
snake_init_player:
	XOR A,A
	LD (snake_player_level:),A
	LD A,5
	LD (snake_player_lives:),A
	LD HL,0
	LD (snake_player_score:),HL
	RET

// ****************** add score *****************
// IN: DE = score to add
snake_add_score:
	ADD DE,(snake_player_score:)
	LD (snake_player_score:),DE
	CALL snake_display_score:
	RET
	
// ***************** game init ****************	
snake_game_init:
	XOR A,A
	LD (snake_lost_a_snake:),A
	CALL snake_table_clear:
	CALL snake_display_screen:
	LD B,(snake_player_level:)
	CALL snake_get_level_index:
	CALL snake_display_level:
	CALL snake_display_lives:
	CALL snake_display_level_no:
	CALL snake_display_score:
	LD A,(IX+4)
	LD (snake_fruit_count:),A
	LD B,A
	CALL snake_fruit_status_fill:
	CALL snake_fruit_status_clear:
	LD HL,(IX+1)
	LD A,(IX+3)
	LD DE,0
	LD C,2
	CALL snake_new_snake:
	CALL snake_set_fruit:

	LD A,1
	LD (snake_game_is_running:),A
	RET
// ***************** snake table clear *************

snake_table_clear:
	LD IX,snake_table:
	LD C,snake_max_snakes:
snake_table_clear_loop1:
	LD (IX),0 // set inactive
	LD (IX+8),0 // program pointer (low)
	LD (IX+9),0 // program pointer (high)
	ADD IX,snake_table_width:
	DEC C
	JR NZ snake_table_clear_loop1:
	RET

// ***************** game_stop **********
snake_game_stop:
	LD A,0
	LD (snake_game_is_running:),A
	RET


// ****************** game interrupt ***********************

snake_game_is_running:
	db 0x00
snake_delay:
	db 7
snake_delay_count:
	db 1
snake_lost_a_snake:
	db 0

snake_interrupt_loop:
	PUSH AF
	PUSH BC
	PUSH DE
	PUSH HL
	PUSH IX
	LD A,(snake_game_is_running:)
	OR A,A
	JR Z snake_game_not_running:


	LD A,(snake_delay_count:)
	DEC A
	LD (snake_delay_count:),A
	JR NZ snake_game_not_running:

	CALL snake_fruit_countdown:
	LD A,(snake_delay:)
	LD (snake_delay_count:),A
	CALL snake_move_all_snakes:
snake_game_not_running:
	POP IX
	POP HL
	POP DE
	POP BC
	POP AF
	RETI
	
// ******************** player vars *************************

snake_player_score:
	dw 0
snake_player_level:
	db 0
snake_player_lives:
	db 5


// ******************** calc pos ********************

snake_calc_pos: // HL=x,y -> DE=Adress
	PUSH HL
	ADD HL,0x0204
	LD E,L
	LD D,0xe0
	LD L,H
	XOR H,H
	MUL HL,40
	ADD DE,HL
	POP HL
	RET
