// *************************** snake main menu ***************

snake_string_new_game:		db "NEW GAME" 0
snake_string_highscore:		db "HIGHSCORE" 0
snake_string_customize_keys:	db "CUSTOMIZE KEYS" 0
snake_string_beginner:		db "WORM       " 0
snake_string_intermediate:	db "PYTHON     " 0
snake_string_advanced:		db "BLACK MAMBA" 0
snake_string_intro:			db "INTRO" 0
snake_main_menu_entries:
	db 5
	dw snake_string_new_game:
	dw snake_string_highscore:
	dw snake_string_customize_keys:
snake_main_menu_difficulty:
	dw snake_string_intermediate:
	dw snake_string_intro:

snake_main_menu:
	CALL snake_display_screen:
	LD IX,snake_main_menu_entries:
	JP snake_menu:	
snake_main_menu_continue:
	LD IX,snake_main_menu_entries:
	JP snake_menu_continue:	

// ************************ snake menu ***********************
// IN:	IX: -> menu entries
// OUT:	A: selected entry

snake_menu_cursor:
	db 0
	
snake_menu:
	XOR A,A
	LD (snake_menu_cursor:),A
snake_menu_continue:
snake_menu_loop:
	CALL snake_menu_display:
snake_menu_loop1:
	IN A,(0)
	OR A,A
	JR Z snake_menu_loop1:
	
	CMP A,0x16
	JR Z snake_menu_next0a:
	CMP A,(snake_player_key_up:)
	JR NZ snake_menu_next1:
snake_menu_next0a:
	LD A,(snake_menu_cursor:)
	OR A,A
	JR Z snake_menu_loop1:
	DEC A
	LD (snake_menu_cursor:),A
	JR snake_menu_loop:
	
snake_menu_next1:
	CMP A,0x18
	JR Z snake_menu_next1a:
	CMP A,(snake_player_key_down:)
	JR NZ snake_menu_next2:
snake_menu_next1a:
	LD A,(snake_menu_cursor:)
	INC A
	CMP A,(IX+0)
	JR Z snake_menu_loop1:
	LD (snake_menu_cursor:),A
	JR snake_menu_loop:

snake_menu_next2:
	CMP A,0x0a
	JR Z snake_menu_next2a:
	CMP A,(snake_player_key_action:)
	JR NZ snake_menu_loop1:
snake_menu_next2a:
	LD A,(snake_menu_cursor:)
	RET

snake_menu_display:
	LD B,(IX+0)
	LD C,0
snake_menu_display_loop1:
	CMP C,(snake_menu_cursor:)
	JR Z snake_menu_display_next1:
	LD A,0x01
	JR snake_menu_display_next2:
snake_menu_display_next1:
	LD A,0x03
snake_menu_display_next2:
	LD (sys_text_color:),A
	CALL snake_menu_display_entry:
	INC C
	CMP C,B
	JR NZ snake_menu_display_loop1:	
	RET

snake_menu_display_entry:
	PUSH IX
	PUSH BC
	INC IX
	LD HL,0x0808
	ADD H,C
	SHL C
	ADD IX,C
	LD (sys_cursor_x:),HL
	PUSH HL
	LD HL,(IX+0)
	CALL print_str:
	POP HL
	POP BC
	POP IX
	RET
	