// *************** display lives **********
snake_string_ssnakes:
	db "Ssnakes:" 0
snake_display_lives:
	LD HL,0x1205
	LD (sys_cursor_x:),HL
	LD A,0x01
	LD (sys_text_color:),A
	LD HL,snake_string_ssnakes:
	CALL print_str:
	CALL cursor_adr:
	LD DE,HL
	ADD HL,sys_screen_color:
	ADD DE,sys_screen:
	LD B,(snake_player_lives:)
	OR B,B
	JR Z snake_display_lives_next1:
snake_display_lives_loop1:
	LD (DE),0x20
	LD (HL),0x01
	INC DE
	INC HL
	LD (DE),snake_sprite_tail_e:
	LD (HL),0x01
	INC DE
	INC HL
	LD (DE),snake_sprite_body_h:
	LD (HL),0x01
	INC DE
	INC HL
	LD (DE),snake_sprite_head_e:
	LD (HL),0x09
	INC DE
	INC HL
	DEC B
	JR NZ snake_display_lives_loop1:
snake_display_lives_next1:
	LD B,5
	SUB B,(snake_player_lives:)
	MUL B,4
	OR B,B
	RET Z
snake_display_lives_loop2:
	LD (DE),0x20
	LD (HL),0x01
	INC DE
	INC HL
	DEC B
	JR NZ snake_display_lives_loop2:
	RET

// ***************** display level no *******************
snake_string_level_no:
	db "Level: " 0
snake_display_level_no:
	LD HL,0x0104
	LD (sys_cursor_x:),HL
	LD A,0x01
	LD (sys_text_color:),A
	LD HL,snake_string_level_no:
	CALL print_str:
	LD L,(snake_player_level:)
	XOR H,H
	INC HL
	LD B,2
	CALL word_dec:
	RET

// ***************** display score *******************
snake_string_score:
	db "Score: " 0
snake_display_score:
	LD HL,0x0118
	LD (sys_cursor_x:),HL
	LD A,0x01
	LD (sys_text_color:),A
	LD HL,snake_string_score:
	CALL print_str:
	LD HL,(snake_player_score:)
	LD B,5
	CALL word_dec:
	RET

// *************** fruit status ****************

snake_fruit_status_cols:
	db 2 37 1 38
snake_fruit_status_count:
	db 0
snake_fruit_status_clear:
	XOR A,A
	LD (snake_fruit_status_count:),A
	RET
	
// A=fruit number
// C=0: color c!=0: use this color
snake_fruit_status_add:
	LD L,A
	LD H,0
	MUL HL,3
	ADD HL,snake_fruit_table:
	LD B,(HL)
	INC HL
	OR C,C
	JR NZ snake_fruit_status_add_next1:
	LD C,(HL)

snake_fruit_status_add_next1:	
	LD A,(snake_fruit_status_count:)
	LD L,A
	AND L,0x03
	LD H,0
	ADD HL,snake_fruit_status_cols:
	LD L,(HL)
	LD H,13
	SHR A
	SHR A
	SUB H,A
	LD (sys_cursor_x:),HL
	CALL cursor_adr:
	ADD HL,sys_screen:
	LD (HL),B
	ADD HL,0x400
	LD (HL),C
	LD A,(snake_fruit_status_count:)
	INC A
	LD (snake_fruit_status_count:),A
	RET
	
// B=number of fruits
snake_fruit_status_fill:
	CALL snake_fruit_status_clear:
snake_fruit_status_fill_loop:
	PUSH B
	IN L,(1)
	LD H,0
	MUL HL,6
	LD A,H
	LD C,0x08 // dark grey
	CALL snake_fruit_status_add:
	POP B
	DEC B
	JR NZ snake_fruit_status_fill_loop:
	RET
	