// *************** highscore table ***********
	.def snake_highscore_table_height: 10
	.def snake_highscore_table_width: 17

snake_highscore_table_default_name:
	db "JOHN SMITH"
snake_highscore_table:
	// +0: score (2 byte)
	// +2: day (1 byte)
	// +3: month (1 byte)
	// +4: year (2 byte)
	// +6: name (11 byte)

	db 0 0 0 0 0 0 "          " 0
	db 0 0 0 0 0 0 "          " 0
	db 0 0 0 0 0 0 "          " 0
	db 0 0 0 0 0 0 "          " 0
	db 0 0 0 0 0 0 "          " 0
	db 0 0 0 0 0 0 "          " 0
	db 0 0 0 0 0 0 "          " 0
	db 0 0 0 0 0 0 "          " 0
	db 0 0 0 0 0 0 "          " 0
	db 0 0 0 0 0 0 "          " 0

// *************** highscore table init***********

snake_highscore_table_init:
	LD IX, snake_highscore_table:
	LD B,snake_highscore_table_height:
	LD HL,450 // score
snake_highscore_table_loop1:
	LD (IX+0),HL
	LD D,15
	LD (IX+2),D
	LD D,10
	LD (IX+3),D
	LD DE,1980
	LD (IX+4),DE
	PUSH HL
	
	LD HL,snake_highscore_table_default_name:
	LD DE,IX
	ADD DE,6
	LD C,10
snake_highscore_table_loop2:
	LD A,(HL)
	LD (DE),A
	INC HL
	INC DE
	DEC C
	JR NZ snake_highscore_table_loop2:	
	POP HL
	LD (IX+22),0
	ADD IX,snake_highscore_table_width:
	SUB HL,50
	DEC B
	JR NZ snake_highscore_table_loop1:
	RET

// *************** highscore table display ***********

snake_highscore_table_display:
	CALL snake_display_screen:
	LD IX,snake_highscore_table:
	LD HL,0x0404
	LD B,0
snake_highscore_table_display_loop:
	LD (sys_cursor_x:),HL
	LD A,0x01
	LD (sys_text_color:),A
	PUSH HL
	PUSH B

	// position
	LD L,B
	LD H,0
	INC HL
	LD B,2
	CALL word_dec:
	
	LD A,0x20
	CALL print_char:
	LD A,'-'
	CALL print_char:
	LD A,0x20
	CALL print_char:

	// name
	LD HL,IX
	ADD HL,6
	CALL print_str:

	LD A,0x20
	CALL print_char:

	// score
	LD HL,(IX)
	LD B,5
	CALL word_dec:

	LD A,0x20
	CALL print_char:
		
	// day
	LD L,(IX+2)
	LD H,0
	LD B,2
	CALL word_dec:

	LD A,'.'
	CALL print_char:

	// month
	LD L,(IX+3)
	LD H,0
	LD B,2
	CALL word_dec:

	LD A,'.'
	CALL print_char:

	// year
	LD HL,(IX+4)
	LD B,4
	CALL word_dec:

	POP B
	POP HL
	INC H
	ADD IX,snake_highscore_table_width:
	INC B
	CMP B,snake_highscore_table_height:
	JP NZ snake_highscore_table_display_loop:
	
	INC H
	INC L
	LD (sys_cursor_x:),HL
	LD HL,snake_string_press_key:
	CALL print_str:
snake_highscore_table_display_loop2:
	IN A,(0)
	CMP A,(snake_player_key_action:)
	RET Z
	CMP A,0x0a
	JR NZ snake_highscore_table_display_loop2:

	RET

// ******************* highscore new ****************

// HL=position, C=color
snake_highscore_print_key:
	LD A,H
	MUL A,6
	ADD A,L
	CMP A,26
	JR NC snake_highscore_print_key_next1:
	ADD A,'A'
	JR snake_highscore_print_key_next2:
snake_highscore_print_key_next1:
	JR NZ snake_highscore_print_key_next3:
	LD A,0x20
	JR snake_highscore_print_key_next2:	
snake_highscore_print_key_next3:
	CMP A,27
	JR NZ snake_highscore_print_key_next4:
	LD A,'-'
	JR snake_highscore_print_key_next2:	
snake_highscore_print_key_next4:
	CMP A,28
	JR NZ snake_highscore_print_key_next5:
	LD A,0x98
	JR snake_highscore_print_key_next2:	
snake_highscore_print_key_next5:
	LD A,0x81

snake_highscore_print_key_next2:
	MUL L,4
	MUL H,2
	ADD HL,0x0508
	LD (sys_cursor_x:),HL
	LD (sys_text_color:),C
	PUSH A
	LD A,0x20
	CALL print_char:
	POP A
	CALL print_char:
	LD A,0x20
	CALL print_char:
	RET

snake_highscore_find:
	LD HL,(snake_player_score:)
	LD B,0
	LD IX,snake_highscore_table:
snake_highscore_find_loop1:
	LD DE,(IX+0)
	CMP DE,HL
	RET C
	ADD IX,snake_highscore_table_width:
	INC B
	CMP B,snake_highscore_table_height:
	JR NZ snake_highscore_find_loop1:
	CLC
	RET

snake_string_enter_name:
	db "Please enter your name:" 0

snake_highscore_name:
	db "          "
snake_highscore_name_cursor:
	db 0

snake_highscore_new:
	// is the score a highscore?
	CALL snake_highscore_find:
	JR C snake_highscore_new_next0:
	RET

snake_highscore_new_next0:
	PUSH B
	CALL snake_display_screen:
	POP B

	LD HL,0x0308
	LD (sys_cursor_x:),HL
	LD A,0x01
	LD (sys_text_color:),A
	LD HL,snake_string_enter_name:
	CALL print_str:
	
	LD H,0
snake_highscore_new_loop1:
	LD L,0
snake_highscore_new_loop2:
	LD C,0xa1
	PUSH HL
	CALL snake_highscore_print_key:
	POP HL
	INC L
	CMP L,6
	JR NZ snake_highscore_new_loop2:
	INC H
	CMP H,5
	JR NZ snake_highscore_new_loop1:
	LD HL,0x0f0e
	LD (sys_cursor_x:),HL
	LD A,0xa1
	LD (sys_text_color:),A
	LD B,0x0a
	LD HL,snake_highscore_name:
snake_highscore_new_loop4:
	LD A,(HL)
	PUSH HL
	CALL print_char:
	POP HL
	INC HL
	DEC B
	JR NZ snake_highscore_new_loop4:
	
	LD HL,0
snake_highscore_new_loop5:
	PUSH HL
	LD C,0xb1
	CALL snake_highscore_print_key:
	POP HL
snake_highscore_new_loop6:
	IN A,(0)
	OR A,A
	JR Z snake_highscore_new_loop6:
	PUSH A
	PUSH HL
	LD C,0xa1
	CALL snake_highscore_print_key:
	POP HL
	POP A

	CMP A,0x16
	JR Z snake_highscore_new_next0a:
	CMP A,(snake_player_key_up:)
	JR NZ snake_highscore_new_next1:
snake_highscore_new_next0a:
	OR H,H
	JR Z snake_highscore_new_loop5:
	DEC H
	JR snake_highscore_new_loop5:
snake_highscore_new_next1:
	CMP A,0x18
	JR Z snake_highscore_new_next1a:
	CMP A,(snake_player_key_down:)
	JR NZ snake_highscore_new_next2:
snake_highscore_new_next1a:
	CMP H,4
	JR Z snake_highscore_new_loop5:
	INC H
	JR snake_highscore_new_loop5:
snake_highscore_new_next2:
	CMP A,0x15
	JR Z snake_highscore_new_next2a:
	CMP A,(snake_player_key_left:)
	JR NZ snake_highscore_new_next3:
snake_highscore_new_next2a:
	OR L,L
	JR Z snake_highscore_new_loop5:
	DEC L
	JR snake_highscore_new_loop5:
snake_highscore_new_next3:
	CMP A,0x17
	JR Z snake_highscore_new_next3a:
	CMP A,(snake_player_key_right:)
	JR NZ snake_highscore_new_next4:
snake_highscore_new_next3a:
	CMP L,5
	JR Z snake_highscore_new_loop5:
	INC L
	JR snake_highscore_new_loop5:
snake_highscore_new_next4:
	CMP A,0x0a
	JR Z snake_highscore_new_loop4a:
	CMP A,(snake_player_key_action:)
	JP NZ snake_highscore_new_loop5:
snake_highscore_new_loop4a:
	LD A,H
	MUL A,6
	ADD A,L
	CMP A,26
	JR NC snake_highscore_new_next5:
	ADD A,'A'
	JR snake_highscore_new_addchar:

snake_highscore_new_addchar:
	LD B,(snake_highscore_name_cursor:)
	CMP B,10
	JP Z snake_highscore_new_loop5:

	LD DE,snake_highscore_name:
	ADD DE,B
	LD (DE),A
	LD DE,0x0f0e
	ADD E,B
	LD (sys_cursor_x:),DE
	LD C,0xa1
	LD (sys_text_color:),C
	INC B
	LD (snake_highscore_name_cursor:),B
	PUSH HL
	CALL print_char:
	POP HL
	JP snake_highscore_new_loop5:
	
snake_highscore_new_next5:
	CMP A,26
	JR NZ snake_highscore_new_next6:
	LD A,0x20
	JP snake_highscore_new_addchar:
snake_highscore_new_next6:
	CMP A,27
	JR NZ snake_highscore_new_next7:
	LD A,'-'
	JR snake_highscore_new_addchar:
snake_highscore_new_next7:
	CMP A,28
	JR NZ snake_highscore_new_next8:
	
	LD B,(snake_highscore_name_cursor:)
	OR B,B
	JP Z snake_highscore_new_loop5:
	DEC B
	LD (snake_highscore_name_cursor:),B
	
	LD DE,snake_highscore_name:
	ADD DE,B
	LD (DE),0x20
	LD DE,0x0f0e
	ADD E,B
	LD (sys_cursor_x:),DE
	LD C,0xa1
	LD (sys_text_color:),C
	LD A,0x20
	PUSH HL
	CALL print_char:
	POP HL
	JP snake_highscore_new_loop5:

snake_highscore_new_next8:
	CALL snake_highscore_find:
	LD L,snake_highscore_table_width:
	LD H,0
	MUL HL,snake_highscore_table_height:
	DEC HL
	ADD HL,snake_highscore_table:
	LD DE,HL
	SUB DE,snake_highscore_table_width:
snake_highscore_new_loop7:
	LD A,(DE)
	LD (HL),A
	DEC HL
	DEC DE
	CMP DE,IX
	JR NC snake_highscore_new_loop7:
	
	LD HL,(snake_player_score:)
	LD (IX+0),HL
	LD A,(sys_date_day:)
	LD (IX+2),A
	LD A,(sys_date_month:)
	LD (IX+3),A
	LD HL,(sys_date_year:)
	LD (IX+4),HL
	ADD IX,6
	LD HL,snake_highscore_name:
	LD B,10
snake_highscore_new_loop8:
	LD A,(HL)
	LD (IX+0),A
	INC HL
	INC IX
	DEC B
	JR NZ snake_highscore_new_loop8:
	RET
