//******************** snake intro screen ****************
snake_string_copyright:
	db "  (c) 2012  Christian Wahlmann  " 0

snake_intro_screen:
	CALL snake_display_screen:
	LD A,3
	LD (snake_delay:),A
	CALL snake_table_clear:
	LD BC,0xffff
	LD (snake_fruit_timeout:),BC
	LD B,0
	LD IX,snake_intro_tab:
snake_intro_screen_loop1:
	LD HL,(IX+0)
	LD A,(IX+2)
	LD DE,(IX+3)
	LD C,(IX+5) // tail wait
	PUSH IX
	CALL snake_new_snake:
	POP IX
	ADD IX,snake_intro_tab_width:
	INC B
	CMP B,snake_intro_tab_length:
	JR NZ snake_intro_screen_loop1:	

	LD A,1
	LD (snake_game_is_running:),A
	
	// wait until no programm is running
snake_intro_screen_loop2:
	CALL snake_sound_crawl:

	LD A,0
	LD IX,snake_table:
	LD B,snake_max_snakes:
snake_intro_screen_loop3:
	OR A,(IX+0)
	ADD IX,snake_table_width:
	DEC B
	JR NZ snake_intro_screen_loop3:
	OR A,A
	JR NZ snake_intro_screen_loop2:
	//
	LD A,0
	LD (snake_game_is_running:),A
	
	LD HL,0x0c04
	LD (sys_cursor_x:),HL
	LD A,0xd2
	LD (sys_text_color:),A
	LD HL,snake_string_copyright:
	CALL print_str:

	LD H,0
	LD A,0x80
	CALL snake_intro_print_line:
	INC H
	LD A,0x90
	CALL snake_intro_print_line:
	INC H
	LD A,0x10
	CALL snake_intro_print_line:

	LD H,0x0c
	LD A,0x50
	CALL snake_intro_print_line:
	INC H
	LD A,0xA0
	CALL snake_intro_print_line:
	INC H
	LD A,0xF0
	CALL snake_intro_print_line:
	INC H
	LD A,0xc0
	CALL snake_intro_print_line:

	CALL snake_sound_title:
	
snake_intro_screen_loop4:
	IN A,(0)
	OR A,A
	JR Z snake_intro_screen_loop4:
	CALL snake_help_screen:
	
	CALL snake_sound_stop:
	RET

snake_intro_print_line:
	PUSH H
	LD L,4
	ADD H,0x02
	LD (sys_cursor_x:),HL
	LD (sys_text_color:),A
	LD B,32
snake_intro_print_line_loop1:
	PUSH B
	LD A,0x20
	CALL print_char:
	POP B
	DEC B
	JR NZ snake_intro_print_line_loop1:
	POP H
	LD A,7
	LD (snake_delay:),A
	RET
//******************** snake intro programs *************

snake_program_S:
	db 3 1 1 3 1 1 1 3 2 2 3 3
	db 3 3 3 1 1 0 1 1 3 3 3 3 3 3 3 3 3
	db 0xff
	db 0x7f
snake_program_s:
	db 1 0 0 0 0 1 1 3 3 1 1 1
	db 3 3 1 0 0 1 3 3
	db 0xff
	db 0x7f
snake_program_n:
	db 0 0 1 3 1 1 0 0 1 1 1
	db 1 1 3 3 2 2
	db 0xff
	db 0x7f
snake_program_a:
	db 3 1 1 0 0 1 3 1 1 1
	db 0 0 1 1 3 3 2
	db 0xff
	db 0x7f
snake_program_k0:
	db 1 0 1 1 1 1 0 0 1
	db 1 1 1 1
	db 0xff
	db 0x7f
snake_program_k1:
	db 3 3 2 0 2 2 0 0 0 2 2
	db 3 1
	db 0xff
	db 0x7f
snake_program_k2:
	db 2 2 2 2 2 2 2
	db 2 3
	db 0xff
	db 0x7f

snake_program_e:
	db 1 1 1 0 2 2 0 1 1 1 0 0 0 
	db 0 0 0 1 1 3 3 2 0
	db 0xff
	db 0x7f


// ***************** snake intro tab ******************
.def snake_intro_tab_length: 8
.def snake_intro_tab_width: 6
snake_intro_tab:
	dw 0x0b00
	db snake_east:
	dw snake_program_S:
	db 16 // tail wait
	
	dw 0x0F0c
	db snake_north:
	dw snake_program_s:
	db 7 // tail wait

	dw 0x0F10
	db snake_north:
	dw snake_program_n:
	db 5 // tail wait

	dw 0x0F12
	db snake_north:
	dw snake_program_a:
	db 6 // tail wait

	dw 0x0F16
	db snake_north:
	dw snake_program_k0:
	db 3 // tail wait

	dw 0x0016
	db snake_south:
	dw snake_program_k1:
	db 1 // tail wait

	dw 0x0F14
	db snake_south:
	dw snake_program_k2:
	db 1 // tail wait
	
	dw 0x0c1f
	db snake_west:
	dw snake_program_e:
	db 8 // tail wait
