// ******************** snake directions *************************

.def	snake_west: 0
.def	snake_north: 1
.def	snake_south: 2
.def	snake_east: 3

// ******************** snake table *************************

.def snake_table_width: 10
.def snake_max_snakes: 10
snake_table: // for 10 snakes
	// 0: active (0=inactive),
	// 1: posx, 2: posy, 3: oldDir, 4: dir, 5: tail_wait, 6: color1, 7: color2,
	// 8,9: program pointer
	db 0 0 0 0 0 0 0x01 0x09   0x00 0x00 // human
	db 0 0 0 0 0 0 0x02 0x0A   0x00 0x00 // computer...
	db 0 0 0 0 0 0 0x03 0x02   0x00 0x00 
	db 0 0 0 0 0 0 0x04 0x08   0x00 0x00
	db 0 0 0 0 0 0 0x05 0x0D   0x00 0x00 
	db 0 0 0 0 0 0 0x06 0x0E   0x00 0x00
	db 0 0 0 0 0 0 0x07 0x0F   0x00 0x00
	db 0 0 0 0 0 0 0x08 0x04   0x00 0x00
	db 0 0 0 0 0 0 0x08 0x03   0x00 0x00
	db 0 0 0 0 0 0 0x0A 0x06   0x00 0x00

// ******************** new snake ************************
snake_new_snake: 
	// HL = start pos
	// DE = program start
	// C = tail wait
	// A = dir
	// -> C-Flag, when all snakes busy
	// -> B=snake
	// find free place
	LD IX,snake_table:
	PUSH DE
	PUSH C
	LD B,0
snake_new_snake_loop1:
	LD C,(IX)
	OR C,C
	JR Z snake_new_snake_found1:
	ADD IX,snake_table_width:
	INC B
	CMP B,snake_max_snakes:
	JR NZ snake_new_snake_loop1:
	SETC
	POP C
	POP DE
	RET // all snakes busy
snake_new_snake_found1:
	// check if position is free
	POP C
	PUSH BC
	LD B,32 // check max 32 positions. If there is no space, lets have chaos!
snake_new_loop1:
	CALL snake_calc_pos:
	LD B,(DE)
	CMP B,0x20
	JR NZ snake_new_check1:
	CALL snake_move_pos:
	CALL snake_calc_pos:
	LD B,(DE)
	CMP B,0x20
	JR Z snake_new_check2:
snake_new_check1:
	CALL snake_move_pos:
	DEC B
	JR NZ snake_new_loop1:
snake_new_check2:
	XOR A,3
	CALL snake_move_pos:
	XOR A,3

	POP BC
	POP DE
	//
	PUSH BC
	LD (IX),1 // set active
	CALL snake_move_pos:
	LD (IX+1),HL  // pos
	LD (IX+3),A // oldDir
	LD (IX+4),A // dir
	LD (IX+5),C // tail_wait
	LD (IX+8),DE // prog pointer
	// draw snake
	CALL snake_calc_pos:
	LD B,snake_sprite_head_w:
	ADD B,A
	LD (DE),B
	XOR A,3
	CALL snake_move_pos:
	CALL snake_calc_pos:
	XOR A,3
	LD B,snake_sprite_tail_w:
	ADD B,A
	LD (DE),B
	POP BC // B=snake #, C=player
	RET	

// ******************* move all snakes *****************

snake_move_all_snakes: 
	LD B,0
snake_move_all_snakes_loop1:
	CALL snake_move_snake_n:
	INC B
	CMP B,snake_max_snakes:
	JR NZ snake_move_all_snakes_loop1:
	RET
	

// ****************** move snake # B ******************
snake_move_snake_n: // B = no. snake
	PUSH B
	LD IX,B
	MUL IX,snake_table_width:
	ADD IX, snake_table:
	LD A,(IX) // alive?
	OR A,A
	JR Z snake_move_snake_n_next1:
	// is human?
	OR B,B
	JR Z move_snake_n_next1a:
	
	CALL snake_control_computer:
	JR move_snake_n_next1b:
	
move_snake_n_next1a:
	CALL snake_control_human:

move_snake_n_next1b:
	LD A,(IX)
	OR A,A
	JR Z snake_move_snake_n_next1:
	CALL snake_collision:
	LD A,(IX)
	OR A,A
	JR Z snake_move_snake_n_next1:
	LD HL,(IX+1) // pos
	LD D,(IX+3) // oldDir
	LD A,(IX+4) // dir
	LD E,(IX+5) // tail_wait
	LD (snake_move_tail_wait:),E
	LD BC,(IX+6) // colors
	
	CALL snake_move_snake:
	
	LD E,(snake_move_tail_wait:)
	LD (IX+5),E // tail_wait
	LD (IX+4),A // dir
	LD (IX+3),A // old_dir
	LD (IX+1),HL // pos	
snake_move_snake_n_next1:
	POP B
	RET

// ****************** collision ********************
// IX -> snake table n
snake_collision:
	LD HL,(IX+1) // pos
	LD A,(IX+4) // dir
	CALL snake_move_pos:
	CALL snake_calc_pos:
	LD A,(DE)
	CMP A,0x20
	RET Z
	CMP A,snake_sprite_apple:
	JR Z snake_collision_next1:
	CMP A,snake_sprite_pear:
	JR Z snake_collision_next1:
	CMP A,snake_sprite_banana:
	JR Z snake_collision_next1:
	CMP A,snake_sprite_cherry:
	JR NZ snake_collision_next2:
	
snake_collision_next1:
	CALL snake_sound_eat:
	LD (DE),0x20
	CMP IX,snake_table:
	RET NZ
	LD L,(snake_fruit_type:)
	LD H,0
	MUL HL,3
	ADD HL,snake_fruit_table:
	INC HL
	INC HL
	LD E,(HL) // tail wait!
	LD (IX+5),E
	// *5 = score
	LD D,0
	MUL DE,5
	CALL snake_add_score:
	LD A,(snake_fruit_type:)
	XOR C,C
	CALL snake_fruit_status_add:
	LD A,(snake_fruit_count:)
	DEC A
	LD (snake_fruit_count:),A
	CALL snake_set_fruit:
	RET
snake_collision_next2:
	// snake dies!!!
	CMP A,snake_sprite_chip:
	JR Z snake_collision_next3:
	CMP A,snake_sprite_fungus:
	JR NZ snake_collision_next4:

	CALL snake_sound_eat_fungus:
	JR snake_collision_next3a:
snake_collision_next3:
	CALL snake_sound_eat_glass:

snake_collision_next3a:
	LD (DE),0x20
	CALL snake_set_fruit:
	JR snake_collision_next4a:
	
snake_collision_next4:
	CMP A,snake_sprite_stone:
	JR Z snake_collision_next4b:
	CMP A,snake_sprite_hedge:
	JR NZ snake_collision_next4c:
	
	CALL snake_sound_hit_hedge:
	JR snake_collision_next4a:

snake_collision_next4b:
	CALL snake_sound_hit_stone:
	JR snake_collision_next4a:

snake_collision_next4c:
	CALL snake_sound_hit_snake:

snake_collision_next4a:
	LD (IX),0 // inactive
	LD HL,(IX+1)
	LD A,(IX+3)
	XOR A,3
	CALL snake_calc_pos:
	LD (DE),0x20
	CALL snake_move_pos:
snake_collision_loop1:
	CALL snake_find_dir:
	JR Z snake_collision_next5:
	JR C snake_collision_next5:
	CALL snake_calc_pos:
	LD (DE),0x20
	CALL snake_move_pos:
	JR snake_collision_loop1:
snake_collision_next5:
	CALL snake_calc_pos:
	LD (DE),0x20	
	RET
	
// **************** move table ***********************

snake_move_table_west:
	db snake_sprite_body_h: // west
	db snake_sprite_body_sw: // north
	db snake_sprite_body_nw: // south
	db '*' // east
snake_move_table_north:
	db snake_sprite_body_ne: // west
	db snake_sprite_body_v: // north
	db '*' // south
	db snake_sprite_body_nw: // east
snake_move_table_south:
	db snake_sprite_body_se: // west
	db '*' // north
	db snake_sprite_body_v: // south
	db snake_sprite_body_sw: // east
snake_move_table_east:
	db '*' // west
	db snake_sprite_body_se: // north
	db snake_sprite_body_ne: // south
	db snake_sprite_body_h: // east

// ************** move snake *****************

snake_move_color1:
	db 0xc1
snake_move_color2:
	db 0xc4
snake_move_col_count:
	db 0x02
snake_move_tail_wait:
	db 0x00
snake_move_snake:
	// BC = colors, HL=x,y of head - D= oldDir - A=Newdir
	// -> HL=new pos, A=dir

	LD (snake_move_color1:),BC
	
	PUSH A
	// set next body tile
	LD E,A
	SHL E
	SHL E
	ADD E,D
	LD D,0
	ADD DE,snake_move_table_west:
	LD A,(DE)
	CALL snake_calc_pos:
	LD (DE),A
	POP A

	PUSH A
	// set head
	CALL snake_move_pos:
	ADD A,snake_sprite_head_w:
	CALL snake_calc_pos:
	LD (DE), A
	POP A
	
	PUSH HL
	PUSH A
	
	
	// colorize
	LD D,2
	LD (snake_move_col_count:),D
	// reverse direction
	XOR A,3
	// head color
	CALL snake_calc_pos:
	ADD DE,0x0400
	LD B,(DE)
	AND B,0xF0
	OR B,(snake_move_color2:)
	LD (DE),B
snake_move_loop1:
	CALL snake_move_pos:
	CALL snake_calc_pos:
	ADD DE,0x0400
	LD B,(DE)
	AND B,0xF0
	OR B,(snake_move_color1:)
	LD (DE),B
	// color flip???
	LD D,(snake_move_col_count:)
	DEC D
	JR NZ snake_move_next1:
	LD D,2
	LD C,(snake_move_color2:)
	LD (snake_move_color2:),B
	LD (snake_move_color1:),C
snake_move_next1:
	LD (snake_move_col_count:),D
	
	CALL snake_find_dir:
	JR Z snake_move_next2: // found tail
	JR C snake_move_next4: // lost trail	
	JR snake_move_loop1:
	
snake_move_next2:
	LD B,(snake_move_tail_wait:)
	OR B,B
	JR Z snake_move_next3:
	DEC B
	LD (snake_move_tail_wait:),B
	JR snake_move_next4:
snake_move_next3:
	CALL snake_calc_pos:
	// set tail
	LD (DE),0x20
	XOR A,3
	CALL snake_move_pos:
	CALL snake_find_dir:
	CALL snake_calc_pos:
	ADD A,snake_sprite_tail_w:
	LD (DE),A
snake_move_next4:
	POP A
	POP HL
	RET

// ***************** move pos *****************

snake_move_pos: // HL=x,y; A=dir
	        // -> HL=new pos, A=dir
	AND A,3
	CMP A, snake_west:
	JR NZ snake_move_pos_next1:
	ADD L,31 // +32-1
	MOD L,32
	RET
snake_move_pos_next1:	
	CMP A, snake_north:
	JR NZ snake_move_pos_next2:
	ADD H,15 // +16-1
	MOD H,16
	RET
snake_move_pos_next2:	
	CMP A, snake_east:
	JR NZ snake_move_pos_next3:
	INC L
	MOD L,32
	RET
snake_move_pos_next3:
	// south
	INC H
	MOD H,16
	RET

// *************** find dir ******************

snake_find_dir:
	// from head to tail
	// HL=x,y, A=oldDir
	// -> A=newDir, Z = tail found, C = lost trail
	AND A,3
	CALL snake_calc_pos:
	LD B,(DE)
	// ----------- WEST --------------
	CMP A,snake_west:
	JR NZ snake_find_next1:
	CMP B,snake_sprite_body_h:
	JR Z snake_find_ende: // nothing changes
	CMP B,snake_sprite_tail_e:
	RET Z // find tail
	CMP B,snake_sprite_body_ne:
	JR NZ snake_find_next2:
	LD A,snake_north:
	JR Z snake_find_ende:
snake_find_next2:
	CMP B,snake_sprite_body_se:
	JP NZ snake_lost_trail:
	LD A,snake_south:
	JR Z snake_find_ende:
snake_find_next1:
	// ----------- EAST --------------
	CMP A,snake_east:
	JR NZ snake_find_next3:
	CMP B,snake_sprite_body_h:
	JR Z snake_find_ende: // nothing changes
	CMP B,snake_sprite_tail_w:
	RET Z // find tail
	CMP B,snake_sprite_body_nw:
	JR NZ snake_find_next4:
	LD A,snake_north:
	JR Z snake_find_ende:
snake_find_next4:
	CMP B,snake_sprite_body_sw:
	JP NZ snake_lost_trail:
	LD A,snake_south:
	JR Z snake_find_ende:
snake_find_next3:
	// ----------- NORTH --------------
	CMP A,snake_north:
	JR NZ snake_find_next5:
	CMP B,snake_sprite_body_v:
	JR Z snake_find_ende: // nothing changes
	CMP B,snake_sprite_tail_s:
	RET Z // find tail
	CMP B,snake_sprite_body_se:
	JR NZ snake_find_next6:
	LD A,snake_east:
	JR Z snake_find_ende:
snake_find_next6:
	CMP B,snake_sprite_body_sw:
	JR NZ snake_lost_trail:
	LD A,snake_west:
	JR Z snake_find_ende:
snake_find_next5:
	// ----------- SOUTH --------------
	// last possibility: snake_south!
	CMP B,snake_sprite_body_v:
	JR Z snake_find_ende: // nothing changes
	CMP B,snake_sprite_tail_n:
	RET Z // find tail
	CMP B,snake_sprite_body_ne:
	JR NZ snake_find_next7:
	LD A,snake_east:
	JR Z snake_find_ende:
snake_find_next7:
	CMP B,snake_sprite_body_nw:
	JR NZ snake_lost_trail:
	LD A,snake_west:
	JR Z snake_find_ende:
	
snake_lost_trail:
	SETC
	RET

snake_find_ende:
	OR B,1
	RET
