// ***************** keys ***************************

snake_player_key_up:
	db 'w'
snake_player_key_down:
	db 's'
snake_player_key_left:
	db 'a'
snake_player_key_right:
	db 'd'
snake_player_key_action:
	db 0x20

// ****************** control human ****************

snake_control_human: // IX -> snake_table #n
	// execute a running program
	PUSH DE
	LD DE,(IX+8)
	OR DE,DE
	JR NZ snake_run_program:
	POP DE

	IN A,(0x00)
	OR A,A
	RET Z
	PUSH DE // will be used
	LD D,0xff
	OUT (0),D // clear puffer

	// TODO: use controls according to the player #
	
	LD D,(IX+3) // oldDir
	
	CMP A,(snake_player_key_left:)
	JR NZ snake_control_next1:
	CMP D,snake_east:
	JR Z snake_control_human_end:
	LD (IX+4),snake_west:
	JR snake_control_human_end:
snake_control_next1:
	CMP A,(snake_player_key_right:)
	JR NZ snake_control_next2:
	CMP D,snake_west:
	JR Z snake_control_human_end:
	LD (IX+4),snake_east:
	JR snake_control_human_end:
snake_control_next2:
	CMP A,(snake_player_key_up:)
	JR NZ snake_control_next3:
	CMP D,snake_south:
	JR Z snake_control_human_end:
	LD (IX+4),snake_north:
	JR snake_control_human_end:
snake_control_next3:
	CMP A,(snake_player_key_down:)
	JR NZ snake_control_human_end:
	CMP D,snake_north:
	JR Z snake_control_human_end:
	LD (IX+4),snake_south:
snake_control_human_end:
	POP DE // was used
	RET

// ****************** control computer ********************
snake_control_computer:
	// execute a running program
	PUSH DE
	LD DE,(IX+8)
	OR DE,DE
	JR NZ snake_run_program:
	POP DE
	
	// or: move towards food and avoid obstacles and other snakes
	RET

snake_run_program:
	LD A,(DE)
	CMP A,0x7f // end of program
	JR Z snake_run_program_next2:
	CMP A,0xff // stop the snake and leave the body
	JR NZ snake_run_program_next1:
	LD (IX+0),0
	JR snake_run_program_next3:
snake_run_program_next1:	
	LD (IX+4),A // set next direction
	INC DE
	JR snake_run_program_next4:
snake_run_program_next2:
	LD DE,0
snake_run_program_next4:
	LD (IX+8),DE
snake_run_program_next3:
	POP DE
	RET
	
// ****************** customize keys **********************

snake_string_up:
	db "UP     - <" 
snake_string_key_up:
	db "w>" 0
snake_string_down:
	db "DOWN   - <" 
snake_string_key_down:
	db "s>" 0
snake_string_left:
	db "LEFT   - <" 
snake_string_key_left:
	db "a>" 0
snake_string_right:
	db "RIGHT  - <" 
snake_string_key_right:
	db "d>" 0
snake_string_action:
	db "ACTION - <" 
snake_string_key_action:
	db " >" 0
snake_string_load_default:
	db "LOAD DEFAULT" 0
snake_string_main_menu:
	db "BACK TO MAIN MENU" 0
	
snake_customize_keys_entries:
	db 7
	dw snake_string_up:
	dw snake_string_down:
	dw snake_string_left:
	dw snake_string_right:
	dw snake_string_action:
	dw snake_string_load_default:
	dw snake_string_main_menu:

snake_customize_keys:
	CALL snake_display_screen:
	XOR A,A
	LD (snake_menu_cursor:),A
snake_customize_keys_loop1:
	LD IX,snake_customize_keys_entries:
	CALL snake_menu_continue:	
	CMP A,6
	JP Z snake_customize_keys_set:
	CMP A,5
	JR NZ snake_customize_keys_next1:
	LD A,'w'
	LD (snake_string_key_up:),A
	LD A,'s'
	LD (snake_string_key_down:),A
	LD A,'a'
	LD (snake_string_key_left:),A
	LD A,'d'
	LD (snake_string_key_right:),A
	LD A,0x20
	LD (snake_string_key_action:),A
	JR snake_customize_keys_loop1:
snake_customize_keys_next1:
	PUSH A
	LD C,(snake_menu_cursor:)
	LD A,0x83
	LD (sys_text_color:),A
	CALL snake_menu_display_entry:
	POP A
	
	IN B,(0)
	OR B,B
	JR Z snake_customize_keys_next1:
	CMP B,0x20
	JR NC snake_customize_keys_next1b:
	CMP B,0x15
	JR C snake_customize_keys_next1a:
	CMP B,0x19
	JR NC snake_customize_keys_next1a:
	ADD B,0x83
	JR snake_customize_keys_next1c:
snake_customize_keys_next1a:
	CMP B,0x0a
	JR NZ snake_customize_keys_loop1:
	LD B,0x81
	JR snake_customize_keys_next1c:
snake_customize_keys_next1b:
	CMP B,0x7f
	JR Z snake_customize_keys_loop1:
	CMP B,0x9B
	JR Z snake_customize_keys_loop1:
snake_customize_keys_next1c:
	CMP A,0
	JR NZ snake_customize_keys_next2:
	LD (snake_string_key_up:),B
	JP snake_customize_keys_loop1:
snake_customize_keys_next2:
	CMP A,1
	JR NZ snake_customize_keys_next3:
	LD (snake_string_key_down:),B
	JP snake_customize_keys_loop1:
snake_customize_keys_next3:
	CMP A,2
	JR NZ snake_customize_keys_next4:
	LD (snake_string_key_left:),B
	JP snake_customize_keys_loop1:
snake_customize_keys_next4:
	CMP A,3
	JR NZ snake_customize_keys_next5:
	LD (snake_string_key_right:),B
	JP snake_customize_keys_loop1:
snake_customize_keys_next5:
	LD (snake_string_key_action:),B
	JP snake_customize_keys_loop1:

snake_customize_keys_set:
	LD A,(snake_string_key_up:)
	CALL snake_char2key:
	LD (snake_player_key_up:),A

	LD A,(snake_string_key_down:)
	CALL snake_char2key:
	LD (snake_player_key_down:),A

	LD A,(snake_string_key_left:)
	CALL snake_char2key:
	LD (snake_player_key_left:),A

	LD A,(snake_string_key_right:)
	CALL snake_char2key:
	LD (snake_player_key_right:),A

	LD A,(snake_string_key_action:)
	CALL snake_char2key:
	LD (snake_player_key_action:),A
	RET

snake_char2key:
	CMP A,0x81
	JR NZ snake_char2key_next1:
	LD A,0x0a
	RET
snake_char2key_next1:
	CMP A,0x98
	RET C
	CMP A,0x9c
	RET NC
	SUB A,0x83
	RET
