// ****************** fruit *****************************

.def snake_fruit_timeout_default: 80
snake_fruit_type:
	db 0
snake_fruit_count:
	db 0
snake_fruit_pos:
	dw 0xffff
snake_fruit_timeout:
	dw 0

// *************** fruit table **************************
// sprite, color, grow amount
snake_fruit_table:
	db snake_sprite_apple:
	db snake_sprite_apple_color:
	db 2
	db snake_sprite_pear:
	db snake_sprite_pear_color:
	db 3
	db snake_sprite_fungus:
	db snake_sprite_fungus_color:
	db 0
	db snake_sprite_banana:
	db snake_sprite_banana_color:
	db 4
	db snake_sprite_chip:
	db snake_sprite_chip_color:
	db 0
	db snake_sprite_cherry:
	db snake_sprite_cherry_color:
	db 5

// ***************** set fruit **********************
snake_set_fruit:
	PUSH HL
	PUSH DE
	PUSH IX
snake_set_fruit_loop:
	LD A,32
	CALL random:
	LD L,A
	LD A,16
	CALL random:
	LD H,A
	CALL snake_calc_pos:
	LD A,(DE)
	CMP A,0x20
	JR NZ snake_set_fruit_loop:
	LD (snake_fruit_pos:),HL
	CALL snake_get_level_index:
	LD A,(IX+5)
	CALL random:
	LD (snake_fruit_type:),A
	LD HL,snake_fruit_timeout_default:
	CMP A,2
	JR Z snake_set_fruit_next1:
	CMP A,4
	JR NZ snake_set_fruit_next2:
snake_set_fruit_next1:
	SHR HL
snake_set_fruit_next2:
	LD (snake_fruit_timeout:),HL
	LD L,A
	LD H,0
	MUL HL,0x0003
	ADD HL,snake_fruit_table:
	LD A,(HL)
	LD (DE),A
	ADD DE,0x400
	LD A,(DE)
	AND A,0xf0
	INC HL
	OR A,(HL)
	LD (DE),A
	POP IX
	POP DE
	POP HL
	RET

// ***************** fruit countdown ********************
snake_fruit_countdown:
	LD HL,(snake_fruit_timeout:)
	OR HL,HL
	JR Z snake_fruit_countdown_next1:
	DEC HL
	LD (snake_fruit_timeout:),HL
	RET
snake_fruit_countdown_next1:
	// change fruit
	LD HL,(snake_fruit_pos:)
	CALL snake_calc_pos:
	LD A,(snake_fruit_type:)
	CMP A,2
	JR Z snake_fruit_countdown_next3:
	CMP A,4
	JR Z snake_fruit_countdown_next3:
	LD (DE),0x20
snake_fruit_countdown_next3:
	CALL snake_set_fruit:
	RET
	