/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.JFrame;

public class SnxChip8
extends JFrame {
    private static Boolean[] keyPress = new Boolean[16];
    private static int H = 360;
    private static int W = 680;
    private static int delay = 1;
    private int[] V;
    private int[] mem;
    private Boolean[][] screen;
    private int[] stack;
    private int I;
    private int DT;
    private int ST;
    private int sp;
    private Boolean needDraw;
    private int HScreen = 32;
    private int WScreen = 64;
    private int PC;
    private AudioInputStream stream;
    private AudioFormat format;
    private DataLine.Info info;
    private Clip clip;
    private static String errorMsg = "";
    private static Boolean error = false;
    private int[] chip8_fontset = new int[]{240, 144, 144, 144, 240, 32, 96, 32, 32, 112, 240, 16, 240, 128, 240, 240, 16, 240, 16, 240, 144, 144, 240, 16, 16, 240, 128, 240, 16, 240, 240, 128, 240, 144, 240, 240, 16, 32, 64, 64, 240, 144, 240, 144, 240, 240, 144, 240, 16, 240, 240, 144, 240, 144, 144, 224, 144, 224, 144, 224, 240, 128, 128, 128, 240, 224, 144, 144, 144, 224, 240, 128, 240, 128, 240, 240, 128, 240, 128, 128};

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Use: java -jar SnxChip8.jar RomName");
            System.exit(0);
        }
        SnxChip8 emu = new SnxChip8();
        SnxChip8.createWindows(emu);
        emu.loadRom(args[0]);
        emu.start();
    }

    public SnxChip8() {
        int i;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                switch (e.getKeyChar()) {
                    case '1': {
                        keyPress[1] = true;
                        break;
                    }
                    case '2': {
                        keyPress[2] = true;
                        break;
                    }
                    case '3': {
                        keyPress[3] = true;
                        break;
                    }
                    case '4': {
                        keyPress[12] = true;
                        break;
                    }
                    case 'q': {
                        keyPress[4] = true;
                        break;
                    }
                    case 'w': {
                        keyPress[5] = true;
                        break;
                    }
                    case 'e': {
                        keyPress[6] = true;
                        break;
                    }
                    case 'r': {
                        keyPress[13] = true;
                        break;
                    }
                    case 'a': {
                        keyPress[7] = true;
                        break;
                    }
                    case 's': {
                        keyPress[8] = true;
                        break;
                    }
                    case 'd': {
                        keyPress[9] = true;
                        break;
                    }
                    case 'f': {
                        keyPress[14] = true;
                        break;
                    }
                    case 'z': {
                        keyPress[10] = true;
                        break;
                    }
                    case 'x': {
                        keyPress[0] = true;
                        break;
                    }
                    case 'c': {
                        keyPress[11] = true;
                        break;
                    }
                    case 'v': {
                        keyPress[15] = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyPressed(e);
                switch (e.getKeyChar()) {
                    case '1': {
                        keyPress[1] = false;
                        break;
                    }
                    case '2': {
                        keyPress[2] = false;
                        break;
                    }
                    case '3': {
                        keyPress[3] = false;
                        break;
                    }
                    case '4': {
                        keyPress[12] = false;
                        break;
                    }
                    case 'q': {
                        keyPress[4] = false;
                        break;
                    }
                    case 'w': {
                        keyPress[5] = false;
                        break;
                    }
                    case 'e': {
                        keyPress[6] = false;
                        break;
                    }
                    case 'r': {
                        keyPress[13] = false;
                        break;
                    }
                    case 'a': {
                        keyPress[7] = false;
                        break;
                    }
                    case 's': {
                        keyPress[8] = false;
                        break;
                    }
                    case 'd': {
                        keyPress[9] = false;
                        break;
                    }
                    case 'f': {
                        keyPress[14] = false;
                        break;
                    }
                    case 'z': {
                        keyPress[10] = false;
                        break;
                    }
                    case 'x': {
                        keyPress[0] = false;
                        break;
                    }
                    case 'c': {
                        keyPress[11] = false;
                        break;
                    }
                    case 'v': {
                        keyPress[15] = false;
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.mem = new int[4096];
        this.V = new int[16];
        this.stack = new int[16];
        this.screen = new Boolean[this.HScreen][this.WScreen];
        this.needDraw = false;
        this.sp = 0;
        for (i = 0; i < 16; ++i) {
            this.V[i] = 0;
            this.stack[i] = 0;
            SnxChip8.keyPress[i] = false;
        }
        for (i = 0; i < this.HScreen; ++i) {
            for (int j = 0; j < this.WScreen; ++j) {
                this.screen[i][j] = false;
            }
        }
        System.arraycopy(this.chip8_fontset, 0, this.mem, 0, 80);
        this.PC = 512;
    }

    private static void createWindows(SnxChip8 c) {
        c.setVisible(true);
        c.setBounds(0, 0, W, H);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, W, H);
        g.setColor(Color.white);
        for (int i = 0; i < this.screen.length; ++i) {
            for (int j = 0; j < this.screen[i].length; ++j) {
                if (!this.screen[i][j].booleanValue()) continue;
                g.fillRect(10 * j + 10, 10 * i + 25, 10, 10);
            }
        }
        if (error.booleanValue()) {
            g.setColor(Color.white);
            g.drawString(errorMsg, 15, 45);
        }
    }

    public void loadRom(String rom) {
        File file = new File(rom);
        try {
            FileInputStream is = new FileInputStream(file);
            long length = file.length();
            byte[] buffer = new byte[(int)length];
            ((InputStream)is).read(buffer);
            for (int i = 0; i < buffer.length; ++i) {
                this.mem[i + 512] = buffer[i];
            }
            ((InputStream)is).close();
        }
        catch (Exception e) {
            error = true;
            errorMsg = "Error: Rom can't be loaded";
        }
    }

    public void start() {
        while (true) {
            try {
                Thread.sleep(delay);
            }
            catch (Exception e) {
                error = true;
                errorMsg = "Error " + e.toString();
            }
            if (this.needDraw.booleanValue()) {
                this.repaint();
                this.needDraw = false;
            }
            this.execute();
            if (this.DT > 0) {
                --this.DT;
            }
            if (this.ST <= 0) continue;
            if (this.ST == 1) {
                try {
                    this.stream = AudioSystem.getAudioInputStream(new File("beep.wav"));
                    this.format = this.stream.getFormat();
                    this.info = new DataLine.Info(Clip.class, this.stream.getFormat());
                    this.clip = (Clip)AudioSystem.getLine(this.info);
                    this.clip.open(this.stream);
                    this.clip.start();
                }
                catch (Exception e) {
                    error = true;
                    errorMsg = "Error: Can't play sound";
                }
            }
            --this.ST;
        }
    }

    private void execute() {
        int opcode = (this.mem[this.PC] & 0xFF) << 8 | this.mem[this.PC + 1] & 0xFF;
        int op_1 = opcode >> 8 & 0xF;
        int op_2 = opcode >> 4 & 0xF;
        int op_3 = opcode & 0xF;
        int op_23 = opcode & 0xFF;
        int op_123 = opcode & 0xFFF;
        block0 : switch (opcode & 0xF000) {
            case 0: {
                switch (opcode & 0xFF) {
                    case 224: {
                        this.FN_CLS();
                        break;
                    }
                    case 238: {
                        this.FN_RET();
                    }
                }
                break;
            }
            case 4096: {
                this.FN_JP_Addr(op_123);
                break;
            }
            case 8192: {
                this.FN_CALL_Addr(op_123);
                break;
            }
            case 12288: {
                this.FN_SE_VX_KK(op_1, op_23);
                break;
            }
            case 16384: {
                this.FN_SNE_VX_KK(op_1, op_23);
                break;
            }
            case 20480: {
                this.FN_SE_VX_VY(op_1, op_2);
                break;
            }
            case 24576: {
                this.FN_LD_VX_KK(op_1, op_23);
                break;
            }
            case 28672: {
                this.FN_ADD_VX_KK(op_1, op_23);
                break;
            }
            case 32768: {
                switch (opcode & 0xF) {
                    case 0: {
                        this.FN_LD_VX_VY(op_1, op_2);
                        break;
                    }
                    case 1: {
                        this.FN_OR_VX_VY(op_1, op_2);
                        break;
                    }
                    case 2: {
                        this.FN_AND_VX_VY(op_1, op_2);
                        break;
                    }
                    case 3: {
                        this.FN_XOR_VX_VY(op_1, op_2);
                        break;
                    }
                    case 4: {
                        this.FN_ADD_VX_VY(op_1, op_2);
                        break;
                    }
                    case 5: {
                        this.FN_SUB_VX_VY(op_1, op_2);
                        break;
                    }
                    case 6: {
                        this.FN_SHR_VX(op_1);
                        break;
                    }
                    case 7: {
                        this.FN_SUBN_VX_VY(op_1, op_2);
                        break;
                    }
                    case 14: {
                        this.FN_SHL_VX(op_1);
                    }
                }
                break;
            }
            case 36864: {
                this.FN_SNE_VX_VY(op_1, op_2);
                break;
            }
            case 40960: {
                this.FN_LD_I_NNN(op_123);
                break;
            }
            case 45056: {
                this.FN_JMP_NNN(op_123);
                break;
            }
            case 49152: {
                this.FN_RND_VX_NN(op_1, op_23);
                break;
            }
            case 53248: {
                this.FN_DRW_VX_VY_N(op_1, op_2, op_3);
                break;
            }
            case 57344: {
                switch (opcode & 0xFF) {
                    case 158: {
                        this.FN_SKP_VX(op_1);
                        break;
                    }
                    case 161: {
                        this.FN_SKPN_VX(op_1);
                    }
                }
                break;
            }
            case 61440: {
                switch (opcode & 0xFF) {
                    case 7: {
                        this.FN_LD_VX_DT(op_1);
                        break block0;
                    }
                    case 10: {
                        this.FN_LD_VX_K_WAIT(op_1);
                        break block0;
                    }
                    case 21: {
                        this.FN_LD_DT_VX(op_1);
                        break block0;
                    }
                    case 24: {
                        this.FN_LD_ST_VX(op_1);
                        break block0;
                    }
                    case 30: {
                        this.FN_LD_I_VX(op_1);
                        break block0;
                    }
                    case 41: {
                        this.FN_LD_F_VX(op_1);
                        break block0;
                    }
                    case 51: {
                        this.FN_LD_B_VX(op_1);
                        break block0;
                    }
                    case 85: {
                        this.FN_LD_I_V0_VX(op_1);
                        break block0;
                    }
                    case 101: {
                        this.FN_LD_V0_VX_I(op_1);
                    }
                }
            }
        }
    }

    private void FN_CLS() {
        for (int i = 0; i < this.HScreen; ++i) {
            for (int j = 0; j < this.WScreen; ++j) {
                this.screen[i][j] = false;
            }
        }
        this.needDraw = true;
        this.PC += 2;
    }

    private void FN_RET() {
        --this.sp;
        this.PC = this.stack[this.sp];
        this.PC += 2;
    }

    private void FN_JP_Addr(int nnn) {
        this.PC = nnn & 0xFFF;
    }

    private void FN_CALL_Addr(int nnn) {
        this.stack[this.sp] = this.PC;
        ++this.sp;
        this.PC = nnn & 0xFFF;
    }

    private void FN_SE_VX_KK(int x, int kk) {
        this.PC += this.V[x] == kk ? 4 : 2;
    }

    private void FN_SNE_VX_KK(int x, int kk) {
        this.PC += this.V[x] != kk ? 4 : 2;
    }

    private void FN_SE_VX_VY(int x, int y) {
        this.PC += this.V[x] == this.V[y] ? 4 : 2;
    }

    private void FN_LD_VX_KK(int x, int kk) {
        this.V[x] = kk;
        this.PC += 2;
    }

    private void FN_ADD_VX_KK(int x, int kk) {
        this.V[x] = this.V[x] + kk & 0xFF;
        this.PC += 2;
    }

    private void FN_LD_VX_VY(int x, int y) {
        this.V[x] = this.V[y];
        this.PC += 2;
    }

    private void FN_OR_VX_VY(int x, int y) {
        this.V[x] = this.V[x] | this.V[y];
        this.PC += 2;
    }

    private void FN_AND_VX_VY(int x, int y) {
        this.V[x] = this.V[x] & this.V[y];
        this.PC += 2;
    }

    private void FN_XOR_VX_VY(int x, int y) {
        this.V[x] = this.V[x] ^ this.V[y];
        this.PC += 2;
    }

    private void FN_ADD_VX_VY(int x, int y) {
        this.V[15] = (this.V[x] + this.V[y] & 0xFFFFFF00) != 0 ? 1 : 0;
        this.V[x] = this.V[x] + this.V[y] & 0xFF;
        this.PC += 2;
    }

    private void FN_SUB_VX_VY(int x, int y) {
        this.V[15] = this.V[y] > this.V[x] ? 0 : 1;
        this.V[x] = this.V[x] - this.V[y] & 0xFF;
        this.PC += 2;
    }

    private void FN_SHR_VX(int x) {
        this.V[15] = this.V[x] & 1;
        this.V[x] = this.V[x] >> 1 & 0xFF;
        this.PC += 2;
    }

    private void FN_SUBN_VX_VY(int x, int y) {
        this.V[15] = this.V[x] > this.V[y] ? 0 : 1;
        this.V[x] = this.V[y] - this.V[x] & 0xFF;
        this.PC += 2;
    }

    private void FN_SHL_VX(int x) {
        this.V[15] = (this.V[x] & 0x80) == 0 ? 0 : 1;
        this.V[x] = this.V[x] << 1 & 0xFF;
        this.PC += 2;
    }

    private void FN_SNE_VX_VY(int x, int y) {
        this.PC += this.V[x] != this.V[y] ? 4 : 2;
    }

    private void FN_LD_I_NNN(int nnn) {
        this.I = nnn;
        this.PC += 2;
    }

    private void FN_JMP_NNN(int nnn) {
        this.PC = nnn + this.V[0] & 0xFFF;
    }

    private void FN_RND_VX_NN(int x, int n) {
        Random generator = new Random();
        this.V[x] = generator.nextInt() & n;
        this.PC += 2;
    }

    private void FN_DRW_VX_VY_N(int op1, int op2, int n) {
        int x = this.V[op1];
        int y = this.V[op2];
        this.V[15] = 0;
        for (int nbyte = 0; nbyte < n; ++nbyte) {
            int pixel = this.mem[this.I + nbyte];
            for (int p = 0; p < 8; ++p) {
                if ((pixel & 128 >> p) == 0) continue;
                if (this.screen[(y + nbyte) % 32][(x + p) % 64].booleanValue()) {
                    this.V[15] = 1;
                }
                Boolean[] booleanArray = this.screen[(y + nbyte) % 32];
                int n2 = (x + p) % 64;
                Boolean.valueOf(booleanArray[n2] ^ true);
            }
        }
        this.needDraw = true;
        this.PC += 2;
    }

    private void FN_SKP_VX(int x) {
        this.PC += keyPress[this.V[x]] != false ? 4 : 2;
    }

    private void FN_SKPN_VX(int x) {
        this.PC += keyPress[this.V[x]] == false ? 4 : 2;
    }

    private void FN_LD_VX_DT(int x) {
        this.V[x] = this.DT;
        this.PC += 2;
    }

    private void FN_LD_VX_K_WAIT(int x) {
        Boolean kpress = false;
        for (int i = 0; i < keyPress.length; ++i) {
            if (!keyPress[i].booleanValue()) continue;
            this.V[x] = i;
            kpress = true;
        }
        if (!kpress.booleanValue()) {
            return;
        }
        this.PC += 2;
    }

    private void FN_LD_DT_VX(int x) {
        this.DT = this.V[x];
        this.PC += 2;
    }

    private void FN_LD_ST_VX(int x) {
        this.ST = this.V[x];
        this.PC += 2;
    }

    private void FN_LD_I_VX(int x) {
        this.I = this.I + this.V[x] & 0xFFF;
        this.PC += 2;
    }

    private void FN_LD_F_VX(int x) {
        this.I = this.V[x] * 5;
        this.PC += 2;
    }

    private void FN_LD_B_VX(int x) {
        this.mem[this.I] = this.V[x] / 100;
        this.mem[this.I + 1] = this.V[x] / 10 % 10;
        this.mem[this.I + 2] = this.V[x] % 100 % 10;
        this.PC += 2;
    }

    private void FN_LD_I_V0_VX(int x) {
        for (int i = 0; i <= x; ++i) {
            this.mem[this.I + i] = (byte)this.V[i];
        }
        this.I += x + 1;
        this.PC += 2;
    }

    private void FN_LD_V0_VX_I(int x) {
        for (int i = 0; i <= x; ++i) {
            this.V[i] = this.mem[this.I + i] & 0xFF;
        }
        this.PC += 2;
    }
}

