/**
 * @file	cmmidiout32.h
 * @brief	MIDI OUT win32 NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <vector>
#include "cmmidiout.h"

/**
 * @brief MIDI OUT win32 NX
 */
class CComMidiOut32 : public CComMidiOut
{
public:
	static CComMidiOut32* CreateInstance(LPCTSTR lpMidiOut);

	CComMidiOut32(HMIDIOUT hMidiOut);
	virtual ~CComMidiOut32();
	virtual void Short(UINT32 nMessage);
	virtual void Long(const UINT8* lpMessage, UINT cbMessage);
	static bool GetId(LPCTSTR lpMidiOut, UINT* pId);

private:
	HMIDIOUT m_hMidiOut;					/*!< MIDIOUT nh */
	MIDIHDR m_midihdr;						/*!< MIDIHDR */
	bool m_bWaitingSentExclusive;			/*!< GNXN[VM */
	std::vector<char> m_excvbuf;			/*!< GNXN[V obt@ */

	void WaitSentExclusive();
};
