/**
 * @file	cmmidioutvst.h
 * @brief	MIDI OUT VST NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#if defined(SUPPORT_VSTi)

#include "cmmidiout.h"
#include "sound.h"
#include "vsthost\vstbuffer.h"
#include "vsthost\vsteditwnd.h"
#include "vsthost\vsteffect.h"
#include "vsthost\vstmidievent.h"

/**
 * @brief MIDI OUT VST NX
 */
class CComMidiOutVst : public CComMidiOut
{
public:
	static bool IsEnabled();
	static CComMidiOutVst* CreateInstance();

	CComMidiOutVst();
	virtual ~CComMidiOutVst();
	virtual void Short(UINT32 nMessage);
	virtual void Long(const UINT8* lpMessage, UINT cbMessage);

private:
	UINT m_nBlockSize;			/*!< ubN TCY */
	UINT m_nIndex;				/*!< ǂݎCfbNX */
	CVstEffect m_effect;		/*!< GtFNg */
	CVstEditWnd m_wnd;			/*!< EBhE */
	CVstMidiEvent m_event;		/*!< Cxg */
	CVstBuffer m_input;			/*!< ̓obt@ */
	CVstBuffer m_output;		/*!< o̓obt@ */

	bool Initialize(LPCTSTR lpPath);
	static void SOUNDCALL GetPcm(CComMidiOutVst*, SINT32* lpBuffer, UINT nBufferCount);
	void Process32(SINT32* lpBuffer, UINT nBufferCount);
};

#endif	// defined(SUPPORT_VSTi)
