/**
 * @file	PropProc.cpp
 * @brief	vpeB V[g NX̓̒`s܂
 */

#include "compiler.h"
#include "PropProc.h"

#if !defined(__GNUC__)
#pragma comment(lib, "comctl32.lib")
#endif	// !defined(__GNUC__)

// ---- vpeB y[W

/**
 * RXgN^
 * @param[in] nIDTemplate ̃y[WɎgpev[g ID
 * @param[in] nIDCaption ̃y[W̃^uɐݒ肳閼O ID
 */
CPropPageProc::CPropPageProc(UINT nIDTemplate, UINT nIDCaption)
{
	Construct(MAKEINTRESOURCE(nIDTemplate), nIDCaption);
}

/**
 * RXgN^
 * @param[in] lpszTemplateName ̃y[W̃ev[g̖O܂ޕւ̃|C^[
 * @param[in] nIDCaption ̃y[W̃^uɐݒ肳閼O ID
 */
CPropPageProc::CPropPageProc(LPCTSTR lpszTemplateName, UINT nIDCaption)
{
	Construct(lpszTemplateName, nIDCaption);
}

/**
 * fXgN^
 */
CPropPageProc::~CPropPageProc()
{
	if (m_lpCaption)
	{
		free(m_lpCaption);
	}
}

/**
 * RXgNg
 * @param[in] nIDTemplate ̃y[WɎgpev[g ID
 * @param[in] nIDCaption ̃y[W̃^uɐݒ肳閼O ID
 */
void CPropPageProc::Construct(UINT nIDTemplate, UINT nIDCaption)
{
	Construct(MAKEINTRESOURCE(nIDTemplate), nIDCaption);
}

/**
 * RXgNg
 * @param[in] lpszTemplateName ̃y[W̃ev[g̖O܂ޕւ̃|C^[
 * @param[in] nIDCaption ̃y[W̃^uɐݒ肳閼O ID
 */
void CPropPageProc::Construct(LPCTSTR lpszTemplateName, UINT nIDCaption)
{
	ZeroMemory(&m_psp, sizeof(m_psp));
	m_psp.dwSize = sizeof(m_psp);
	m_psp.dwFlags = PSP_USECALLBACK;
	m_psp.hInstance = FindResourceHandle(lpszTemplateName, RT_DIALOG);
	m_psp.pszTemplate = lpszTemplateName;
	m_psp.pfnDlgProc = DlgProc;
	m_psp.lParam = reinterpret_cast<LPARAM>(this);
	m_psp.pfnCallback = PropPageCallback;

	m_lpCaption = NULL;
	if (nIDCaption)
	{
		std::tstring rTitle(LoadTString(nIDCaption));
		m_lpCaption = _tcsdup(rTitle.c_str());
		m_psp.pszTitle = m_lpCaption;
		m_psp.dwFlags |= PSP_USETITLE;
	}
}

/**
 * vpeB y[W vV[W
 * @param[in] hWnd EBhE nh
 * @param[in] message bZ[W
 * @param[in] pPropPage ̃vpeB V[g y[W̃|C^
 * @return 0
 */
UINT CALLBACK CPropPageProc::PropPageCallback(HWND hWnd, UINT message, LPPROPSHEETPAGE pPropPage)
{
	switch (message)
	{
		case PSPCB_CREATE:
			HookWindowCreate(reinterpret_cast<CPropPageProc*>(pPropPage->lParam));
			return TRUE;

		case PSPCB_RELEASE:
			UnhookWindowCreate();
			break;
	}
	return 0;
}

/**
 * t[[ŃACxgRg[ɔꍇARg[ꕔ̎ނ̏vRg[eEBhEɒʒm邽߂ɁÃo[֐Ăяo܂
 * @param[in] wParam bZ[WRg[炻̃bZ[W𑗐MRg[ʂ܂
 * @param[in] lParam ʒmR[hƒǉ܂ޒʒmbZ[W (NMHDR) ̍\̂ւ̃|C^[
 * @param[out] pResult bZ[WꂽƂʂi[R[h LRESULT ̕ϐւ̃|C^[
 * @retval TRUE bZ[W
 * @retval FALSE bZ[WȂ
 */
BOOL CPropPageProc::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	NMHDR* pNMHDR = reinterpret_cast<NMHDR*>(lParam);

	// allow message map to override
	if (CDlgProc::OnNotify(wParam, lParam, pResult))
	{
		return TRUE;
	}

	// don't handle messages not from the page/sheet itself
	if (pNMHDR->hwndFrom != m_hWnd && pNMHDR->hwndFrom != ::GetParent(m_hWnd))
	{
		return FALSE;
	}

	// handle default
	switch (pNMHDR->code)
	{
		case PSN_APPLY:
			*pResult = OnApply() ? PSNRET_NOERROR : PSNRET_INVALID_NOCHANGEPAGE;
			break;

		case PSN_RESET:
			OnReset();
			break;

		default:
			return FALSE;   // not handled
	}

	return TRUE;    // handled
}

/**
 * ̃o[֐́At[[Nɂ OnKillActivet[[NĂяoɃ[U[[OK]I邩AXVɌĂяo܂
 * @retval TRUE ύXFꂽ
 * @retval FALSE ύXFȂ
 */
BOOL CPropPageProc::OnApply()
{
	OnOK();
	return TRUE;
}

/**
 * ̃o[֐́At[[Nɂă[U[[LZ]IƂɌĂяo܂B
 */
void CPropPageProc::OnReset()
{
	OnCancel();
}

/**
 * ̃o[֐́At[[Nɂ OnKillActivet[[NĂяoɃ[U[[OK]I邩AXVɌĂяo܂
 */
void CPropPageProc::OnOK()
{
}

/**
 * ̃o[֐́At[[N[LZ]{^IꂽƂɌĂяo܂
 */
void CPropPageProc::OnCancel()
{
}

// ---- vpeB V[g

/**
 * RXgN^
 */
CPropSheetProc::CPropSheetProc()
{
	CommonConstruct(NULL, 0);
}

/**
 * RXgN^
 * @param[in] nIDCaption LvV
 * @param[in] hwndParent eEBhE
 * @param[in] iSelectPage X^[g y[W
 */
CPropSheetProc::CPropSheetProc(UINT nIDCaption, HWND hwndParent, UINT iSelectPage)
{
	m_strCaption = LoadTString(nIDCaption);
	CommonConstruct(hwndParent, iSelectPage);
}

/**
 * RXgN^
 * @param[in] pszCaption LvV
 * @param[in] hwndParent eEBhE
 * @param[in] iSelectPage X^[g y[W
 */
CPropSheetProc::CPropSheetProc(LPCTSTR pszCaption, HWND hwndParent, UINT iSelectPage)
{
	m_strCaption = pszCaption;
	CommonConstruct(hwndParent, iSelectPage);
}

/**
 * RXgNg
 * @param[in] hwndParent eEBhE
 * @param[in] iSelectPage X^[g y[W
 */
void CPropSheetProc::CommonConstruct(HWND hwndParent, UINT iSelectPage)
{
	ZeroMemory(&m_psh, sizeof(m_psh));
	m_psh.dwSize = sizeof(m_psh);
	m_psh.hwndParent = hwndParent;
	m_psh.hInstance = CWndProc::GetResourceHandle();
	m_psh.nStartPage = iSelectPage;
}

/**
 * [_
 * @return Ug R[h
 */
INT_PTR CPropSheetProc::DoModal()
{
	m_psh.pszCaption = m_strCaption.c_str();
	m_psh.nPages = static_cast<UINT>(m_pages.size());
	m_psh.phpage = new HPROPSHEETPAGE[m_psh.nPages];
	for (UINT i = 0; i < m_pages.size(); i++)
	{
		m_psh.phpage[i] = ::CreatePropertySheetPage(&m_pages[i]->m_psp);
	}

	const INT_PTR r = ::PropertySheet(&m_psh);

	delete[] m_psh.phpage;
	m_psh.phpage = NULL;

	return r;
}

/**
 * y[W̒ǉ
 * @param[in] pPage y[W
 */
void CPropSheetProc::AddPage(CPropPageProc* pPage)
{
	m_pages.push_back(pPage);
}
