
// fXNgbvp 308x90 (SUPPORT_SOFTKBD == 0 / PC-9801-106)

static const UINT8 np2kbd_bmp[3129] = {
		0x4e,0x37,0x00,0x06,0x05,0x42,0x4d,0x4e,0x37,0x00,0x00,0x04,0x76,
		0x00,0xc2,0x41,0x28,0x00,0xc2,0x34,0x01,0x00,0x00,0x5a,0x01,0xc2,
		0x13,0x01,0x00,0x04,0x05,0xc4,0xd8,0x36,0x07,0xc5,0x00,0x03,0x50,
		0x10,0x00,0xc2,0x0a,0x00,0xc2,0x30,0x30,0x30,0x00,0x00,0x52,0x52,
		0x52,0x00,0x7b,0x7b,0x7b,0x00,0x00,0x94,0x94,0x94,0x00,0xa5,0xad,
		0xad,0x00,0x00,0xb5,0xb5,0xb5,0x00,0xe7,0xe7,0xe7,0x00,0x11,0xff,
		0xff,0xff,0x07,0xc4,0x11,0xaa,0x11,0x0e,0x09,0xbf,0x00,0x0e,0x77,
		0x00,0x3f,0x00,0x3f,0x00,0x18,0x26,0xff,0x00,0x3f,0x26,0xde,0x22,
		0x23,0x33,0x00,0x0a,0x46,0x31,0x11,0x00,0x02,0x13,0x4c,0x56,0x01,
		0x86,0x33,0x21,0x01,0xc3,0x02,0x42,0x35,0x64,0xd9,0x02,0x46,0x00,
		0x23,0x14,0x0d,0xca,0x1b,0x8d,0x63,0x33,0x06,0x47,0x1a,0x11,0x33,
		0x33,0x06,0xc2,0x15,0x45,0x45,0x01,0x8d,0x63,0xa4,0x07,0xc4,0x35,
		0x26,0xc3,0x36,0x66,0x00,0x02,0x06,0x00,0x44,0x60,0x01,0x83,0x66,
		0x33,0x35,0x01,0x43,0x63,0x43,0x90,0x01,0x86,0x64,0x46,0x05,0x44,
		0x66,0x53,0x65,0x44,0x4a,0x67,0x3c,0x29,0x74,0x53,0x0d,0xc9,0x57,
		0x06,0x4c,0x36,0x46,0x66,0x06,0x47,0x65,0x36,0x66,0x06,0xc2,0x15,
		0x45,0x45,0x92,0x01,0x8d,0x33,0x56,0x08,0x03,0x34,0x57,0x26,0xc4,
		0x00,0x02,0x06,0x66,0x06,0x60,0x66,0x06,0x04,0x43,0x31,0xc8,0x0e,
		0x45,0x01,0x86,0x33,0x63,0x01,0xc5,0x66,0x66,0x36,0x57,0x17,0x63,
		0x6b,0x43,0x0d,0xc9,0x47,0x26,0xce,0x06,0x48,0x02,0x02,0x2a,0x47,
		0x77,0x15,0x45,0x74,0x01,0x8d,0x16,0x07,0xc5,0x47,0xbf,0x26,0xc7,
		0x60,0x26,0xff,0x26,0xff,0x26,0xda,0xec,0x43,0x26,0xff,0x26,0xf4,
		0x7e,0x70,0xe3,0x02,0x26,0xdb,0x00,0x02,0x9b,0x42,0x4d,0xc6,0x9e,
		0x44,0x31,0x02,0x60,0x00,0x60,0x06,0x06,0x06,0x26,0xc2,0x06,0x05,
		0x60,0x06,0x00,0x06,0x06,0x26,0xf1,0x60,0x0d,0xc6,0xed,0x26,0xd4,
		0x1a,0x83,0x26,0xc6,0x07,0x00,0x42,0x25,0x03,0x07,0x26,0xcb,0xff,
		0xbe,0xc3,0x26,0xc9,0x00,0x07,0x26,0xc2,0x77,0x43,0x26,0xc2,0x26,
		0x82,0x26,0xc4,0xfb,0x02,0x02,0x54,0x42,0x26,0xf1,0x0d,0xc6,0x26,
		0xd3,0x60,0x68,0x83,0x26,0xce,0x6d,0x70,0x26,0xc5,0x51,0x43,0x16,
		0x71,0x42,0x26,0xcb,0x00,0x4b,0x82,0xa3,0x33,0x43,0x31,0x9e,0x45,
		0x31,0x60,0x60,0x79,0x02,0x26,0xc3,0x7f,0x00,0x02,0x04,0x74,0xf2,
		0x89,0x43,0x4d,0xd6,0x3d,0x42,0x26,0xd0,0x76,0x86,0xef,0x26,0xc5,
		0x20,0x83,0x9b,0xc9,0x06,0x2a,0x82,0x26,0xc5,0x9e,0x44,0x26,0xc2,
		0xff,0x74,0xc9,0x12,0x83,0x4d,0xf4,0x74,0xeb,0x9b,0xce,0x26,0xcc,
		0x27,0x02,0x4d,0xc6,0xff,0x06,0x03,0x74,0xc2,0x03,0xc2,0x26,0xc5,
		0xc9,0x44,0x9b,0xf2,0x0d,0xc5,0x26,0xdf,0xff,0xc2,0xd6,0x26,0xce,
		0xa0,0x03,0xe9,0xff,0xe9,0xf1,0x25,0x0b,0x26,0xd3,0x9b,0xc3,0xdd,
		0x95,0xc2,0x4d,0xc4,0x56,0x26,0xc5,0x01,0x85,0x26,0xca,0x26,0x26,
		0xff,0xb5,0x26,0xcf,0x54,0x26,0xc3,0x15,0x45,0x74,0x01,0x8d,0x15,
		0x2e,0xc5,0xa5,0xe9,0xd0,0x34,0x03,0x44,0x64,0x24,0x01,0x86,0x64,
		0x28,0xc5,0x09,0x66,0x64,0x53,0x44,0x26,0xaa,0x75,0x34,0x0d,0xc9,
		0x94,0x06,0x4d,0x46,0x66,0x06,0x47,0x66,0x29,0x82,0x77,0x77,0xe9,
		0x15,0x45,0x17,0x06,0x01,0x87,0x43,0x07,0xc4,0x42,0x77,0x26,0xc2,
		0x20,0x23,0x33,0x00,0x0a,0x47,0x41,0x13,0x33,0x33,0x12,0x32,0x12,
		0x67,0x01,0x86,0x43,0x11,0x05,0x44,0x32,0x04,0x12,0x36,0x74,0x12,
		0x44,0x00,0x27,0x43,0x13,0xc7,0x0d,0xca,0x26,0xcd,0x74,0x33,0x33,
		0x06,0x45,0x01,0x83,0x06,0xc2,0xb9,0x15,0x44,0x31,0x17,0x05,0x01,
		0x89,0x08,0x83,0x21,0x26,0x26,0xc3,0x58,0x63,0x11,0x03,0x11,0x00,
		0x05,0x24,0x42,0x33,0x35,0x64,0x5f,0x21,0x02,0x83,0x45,0x01,0xbf,
		0x01,0x85,0x17,0x42,0x02,0x04,0x00,0x02,0xb3,0x16,0x82,0x63,0x02,
		0x04,0x01,0x87,0x77,0x77,0x0c,0x95,0x07,0x46,0xa8,0x74,0xc6,0x44,
		0x5a,0x06,0x53,0x00,0xc2,0x65,0x44,0x67,0xb0,0x38,0x83,0x45,0x01,
		0xbf,0x01,0x85,0x36,0x66,0x64,0x46,0x82,0x16,0xc5,0x65,0x36,0x66,
		0x65,0x33,0x74,0x44,0x34,0x9f,0x01,0x86,0x57,0x77,0x0c,0x94,0x07,
		0x47,0x26,0xc6,0x9c,0xc8,0x02,0x03,0xff,0xcf,0x14,0x01,0xb7,0xe6,
		0x4d,0xe0,0x83,0x02,0x02,0x01,0x86,0xe9,0xda,0xc2,0xca,0xe2,0x26,
		0xff,0x26,0xff,0x26,0xea,0x00,0x00,0x07,0x0a,0x43,0x07,0xcb,0x00,
		0x42,0x01,0x82,0x70,0x00,0x0d,0xc5,0x07,0x01,0x84,0x0c,0x42,0xfc,
		0x06,0xca,0x01,0x86,0x26,0xfa,0x15,0x47,0x1a,0x89,0x26,0xcf,0x60,
		0x00,0x07,0x60,0x60,0x60,0x66,0x06,0x26,0xc6,0x0b,0xc2,0x1f,0xd1,
		0x3f,0x70,0x70,0x05,0x12,0x26,0xc7,0x18,0x45,0x25,0x06,0x0f,0x86,
		0x26,0xc8,0x2b,0x00,0x06,0x00,0x02,0x60,0x26,0xc6,0x60,0x26,0xc5,
		0x01,0x83,0xff,0x26,0xca,0x16,0xc2,0x13,0x88,0x4d,0xd0,0x26,0xcc,
		0x0a,0x46,0x23,0x48,0x03,0x4d,0xb7,0x25,0x05,0x70,0x26,0xcc,0x06,
		0xc5,0x77,0x54,0xc5,0x0f,0x86,0x42,0xc4,0xab,0x26,0xc3,0x60,0x26,
		0xcb,0x06,0x4d,0xc6,0x06,0x26,0xcc,0x37,0x08,0x9d,0x26,0xc4,0x00,
		0x00,0x07,0x43,0x4d,0xc9,0x27,0x02,0x06,0x26,0xc7,0xef,0x0c,0x0d,
		0x51,0x4d,0x74,0xc7,0x07,0x26,0xcc,0x7d,0x86,0x7f,0x4c,0x4d,0xc9,
		0xbf,0x4e,0x02,0x00,0x26,0xc6,0x1a,0x02,0x26,0xc3,0x01,0x84,0x26,
		0xcb,0x37,0x06,0xfe,0x01,0x83,0x74,0xd0,0x00,0x03,0x4d,0xc8,0x0a,
		0x46,0x4d,0xcd,0x71,0x4d,0x00,0xff,0x03,0x46,0x28,0x85,0x9a,0x0e,
		0x1a,0x06,0x26,0xc7,0x4d,0x83,0x4d,0xdf,0x86,0xca,0xfd,0x4d,0xd1,
		0x26,0xc2,0x32,0xc2,0xe9,0xc7,0x94,0xd2,0x01,0x94,0x00,0x76,0x85,
		0xff,0xc1,0x0f,0x05,0x09,0x9b,0xc7,0x1b,0x82,0x9b,0xd4,0x0f,0xc2,
		0x86,0xcf,0xe9,0xf2,0xfc,0x74,0xce,0xe9,0xff,0xc2,0xce,0x15,0x45,
		0x1e,0x04,0x26,0xd6,0x65,0x46,0xba,0x01,0x02,0x26,0x15,0x45,0x01,
		0xbf,0x26,0xc7,0x62,0x26,0xc7,0x54,0x19,0x66,0x66,0x15,0x1d,0x85,
		0x01,0x86,0x47,0x77,0x0c,0x94,0xe8,0x07,0x47,0x26,0xc2,0x23,0x83,
		0x45,0x36,0x89,0x66,0x63,0x44,0xb0,0x08,0x84,0x53,0x01,0xbf,0x01,
		0x85,0x46,0x66,0x64,0x56,0x94,0x64,0xc8,0x63,0x43,0x02,0x04,0x42,
		0x01,0x86,0x77,0x77,0xe0,0x0c,0x94,0x07,0x47,0x26,0xc2,0x74,0x33,
		0x33,0x33,0x31,0x60,0x13,0x01,0x02,0x01,0x86,0x36,0x74,0x12,0x44,
		0x44,0x31,0x44,0x31,0x01,0xbf,0x01,0x87,0x33,0x33,0x11,0x16,0xc4,
		0x93,0x01,0x83,0x36,0x74,0x02,0xc3,0x21,0x26,0x01,0x86,0x48,0xc2,
		0xe5,0x0c,0x94,0x07,0x46,0x26,0xc2,0x63,0x11,0x00,0x03,0x35,0x01,
		0x86,0x2c,0x64,0x21,0x01,0x83,0x45,0x01,0xbf,0x01,0x8c,0x63,0x31,
		0x87,0x16,0xc4,0x11,0x12,0x35,0x63,0x1d,0x02,0x02,0xc5,0x1f,0xc2,
		0x1d,0x35,0x77,0x77,0x0b,0x95,0x22,0x45,0x26,0xc3,0x33,0x5c,0xc4,
		0x4b,0x34,0x01,0x86,0x44,0x67,0x55,0xc3,0x45,0x01,0xbf,0x01,0x8c,
		0x41,0x35,0xb3,0x86,0x64,0x45,0x36,0x66,0x64,0x90,0x83,0x83,0xb6,
		0x43,0x36,0x66,0x65,0x57,0x77,0x0b,0x94,0x22,0x46,0x7a,0x57,0x26,
		0xc2,0xce,0xcd,0xdc,0xdb,0x01,0xb7,0x33,0xc3,0x47,0x36,0xfe,0xed,
		0x4d,0xe9,0xc4,0x0b,0x91,0xe9,0xca,0x26,0xff,0x26,0xff,0x26,0xeb,
		0x07,0xce,0x00,0x42,0x09,0x82,0x70,0x00,0x0b,0x44,0x08,0x02,0x01,
		0x83,0x07,0xf3,0x0e,0xc5,0x05,0x06,0x08,0x8d,0x03,0x46,0x00,0x00,
		0x01,0x84,0x0a,0x83,0xb8,0x26,0xeb,0x70,0x16,0x0b,0x01,0x84,0x26,
		0xcb,0x00,0x60,0x60,0x00,0x60,0x00,0x63,0x16,0x00,0x06,0x00,0x60,
		0x7f,0x06,0x26,0xc9,0x01,0x8f,0x21,0x8b,0x01,0x8e,0x17,0x85,0x08,
		0x86,0x1b,0x06,0x77,0x77,0x1b,0x06,0x2a,0x43,0x26,0xd0,0x06,0x26,
		0xc9,0x34,0x46,0x14,0x4b,0xe0,0x26,0xc2,0x08,0x02,0x26,0xc5,0x06,
		0x60,0x60,0x06,0x06,0x03,0x63,0x16,0x06,0x00,0x00,0x66,0x26,0xc3,
		0x3f,0xc7,0xff,0x26,0xe1,0x08,0x87,0x4a,0x45,0x26,0xc7,0x25,0x05,
		0x01,0x87,0x26,0xdf,0x36,0x06,0xdf,0x1b,0x4b,0x26,0xce,0x00,0x26,
		0xc3,0x27,0x02,0x4d,0xca,0x6c,0x0f,0x03,0x45,0xfc,0x41,0xc2,0x6f,
		0x8a,0x06,0xc6,0x2d,0xc7,0x9b,0xd3,0x26,0xd3,0x06,0x06,0xfd,0x1e,
		0xc3,0x26,0xda,0x22,0x02,0x26,0xc9,0x73,0x02,0x26,0xc3,0x60,0x9b,
		0xca,0xe5,0x4a,0x4f,0x1f,0xcb,0x4d,0xfe,0x60,0x00,0x4d,0xc9,0x70,
		0x26,0xc5,0xec,0x3e,0xc6,0x9b,0xc7,0x4d,0xc8,0x00,0x00,0x02,0x26,
		0xc2,0x00,0x00,0xff,0x4f,0x83,0x9b,0xeb,0x26,0xc7,0x9b,0xcd,0x26,
		0xcc,0x9b,0xc8,0x71,0x83,0x74,0xd3,0xff,0x26,0xc6,0xda,0xc7,0xe9,
		0xc6,0x26,0xc8,0xe9,0xce,0xcc,0x8b,0x34,0x08,0x71,0x46,0xf7,0x7a,
		0x0d,0xa4,0x94,0x74,0xce,0xe9,0xc6,0x60,0x26,0xcc,0xe9,0xcb,0x17,
		0xcc,0xdb,0x03,0x44,0xe9,0xca,0x15,0x02,0x85,0x01,0x86,0x26,0x13,
		0x85,0x01,0xbf,0xf7,0x01,0x8c,0x26,0xc2,0xda,0x03,0x26,0xcd,0x54,
		0x26,0xc3,0x0b,0x94,0x22,0x46,0xaa,0x26,0xc3,0x43,0x02,0x84,0x42,
		0x01,0x86,0x44,0x07,0xc4,0x53,0xc4,0x01,0xbf,0x01,0x8c,0x33,0x66,
		0x60,0x72,0x05,0x36,0x16,0x10,0x66,0x64,0x56,0x9e,0xc7,0x66,0x63,
		0x77,0x77,0xe0,0x0b,0x94,0x22,0x46,0x6c,0x83,0x74,0x11,0x33,0x33,
		0x33,0x20,0x21,0x26,0x01,0x87,0x12,0x44,0x44,0x44,0x31,0x68,0x36,
		0x01,0xbf,0x01,0x8b,0x35,0x1b,0x02,0x06,0x00,0x06,0x87,0x27,0xc2,
		0x36,0x44,0x33,0x33,0x19,0x83,0x00,0x02,0x01,0x82,0x78,0x36,0x48,
		0xc2,0x0d,0x54,0x22,0x45,0x26,0xc3,0x63,0x33,0x21,0x42,0x11,0x00,
		0x04,0x13,0x33,0x35,0x64,0x02,0x84,0x45,0xca,0x01,0xbf,0x01,0x8c,
		0x63,0x34,0x71,0xc2,0x60,0x26,0x82,0x06,0x12,0x66,0x36,0x33,0x1a,
		0x04,0x35,0x63,0x01,0x85,0x77,0x71,0x77,0x0c,0x15,0x07,0x46,0x26,
		0xc2,0x36,0x64,0x46,0x59,0x45,0x05,0x53,0x66,0x65,0x44,0x67,0x55,
		0x43,0x45,0x01,0xbf,0xc5,0x01,0x8c,0x98,0xc5,0x06,0x66,0x06,0x26,
		0xc2,0x23,0x74,0x44,0x27,0x34,0x33,0x01,0x85,0x57,0x77,0x0c,0x14,
		0x07,0x47,0x26,0xc3,0x9f,0xa7,0x88,0x36,0x66,0xd9,0x94,0x01,0xbe,
		0xbf,0xc7,0x26,0xc3,0xe0,0x86,0xfc,0xe2,0x47,0xe9,0xc3,0x0c,0x11,
		0xe9,0xca,0x26,0xff,0x26,0xec,0x60,0x00,0x86,0x50,0x42,0x63,0x16,
		0x00,0x60,0x00,0x02,0x26,0xf0,0x70,0x25,0x00,0x07,0x09,0x03,0x70,
		0x70,0x0a,0xc4,0x00,0x03,0x45,0x6c,0x07,0x00,0x42,0x0e,0x43,0x07,
		0x10,0x05,0x01,0x85,0x70,0x00,0xf0,0x03,0x52,0x03,0x02,0x06,0xcb,
		0x26,0xd1,0x60,0x66,0x00,0x06,0x01,0x63,0x16,0x06,0x06,0x00,0x00,
		0x00,0x26,0xc5,0xbe,0x0f,0x8c,0x70,0x03,0x43,0x26,0xcd,0xa9,0xc2,
		0xd2,0x02,0x26,0xc4,0x07,0xdf,0x07,0x82,0x18,0xc3,0x07,0x25,0x06,
		0x1c,0x45,0x2a,0x45,0x26,0xcd,0x2c,0x0d,0xfa,0x03,0x46,0x0c,0x07,
		0x0f,0x85,0x1a,0x84,0x26,0xcf,0x06,0x26,0xc4,0x06,0x77,0x00,0x4d,
		0xc6,0x13,0x0d,0x1a,0x03,0x16,0x08,0x82,0x57,0x02,0x26,0xc8,0x7f,
		0x00,0x03,0x83,0x26,0xc4,0x25,0x06,0x26,0xcc,0x09,0x42,0x26,0xe6,
		0x0a,0x46,0xf3,0x26,0xc7,0x4d,0xcb,0x3f,0x03,0x4d,0xc7,0x00,0x60,
		0x26,0xc8,0x3d,0x85,0xcf,0x0f,0x86,0x4f,0x84,0x16,0x66,0x7e,0x42,
		0x4d,0xcd,0x74,0xc5,0x3f,0xc8,0xff,0x1a,0x8c,0x21,0x8c,0x7b,0xc6,
		0x4d,0xd6,0x4c,0x06,0x26,0xd1,0x8d,0x03,0xc2,0xd2,0xf7,0x13,0x05,
		0x84,0x88,0x0d,0xc2,0x07,0x42,0x06,0x26,0xcd,0x4d,0xc7,0x18,0xcc,
		0xfb,0x68,0x87,0x26,0xef,0x05,0x43,0x26,0xd4,0x99,0xc3,0x00,0x74,
		0xc2,0x01,0x84,0xf3,0xc2,0xc5,0x1b,0xcd,0x26,0xc4,0x4d,0xcb,0x00,
		0x06,0x5a,0x83,0x26,0xe7,0xff,0x21,0x8e,0x05,0x13,0x4f,0x88,0x26,
		0xcf,0xe8,0x02,0x9b,0xc3,0x01,0x85,0x26,0xd8,0xff,0x9b,0xcb,0xe9,
		0xcc,0x8f,0x8d,0x76,0x8b,0xed,0x4d,0x53,0x0e,0x08,0x87,0xe9,0xd8,
		0xff,0x4d,0xc6,0x26,0xc4,0x01,0x85,0x26,0xc3,0x14,0xc6,0xe9,0xc7,
		0x9b,0xc5,0xe9,0xcb,0x87,0x00,0x05,0x65,0x46,0x66,0x26,0x13,0x85,
		0x01,0xbf,0x01,0x8c,0xb9,0x26,0xcb,0x15,0x72,0x82,0x25,0x02,0x01,
		0x86,0x47,0x77,0x0c,0x14,0x44,0x15,0x26,0xc9,0x46,0x64,0x56,0x0e,
		0x45,0x63,0x66,0x2d,0x63,0x44,0x07,0x44,0x53,0x01,0xbf,0x01,0x8c,
		0x46,0x3d,0x03,0x94,0x3f,0x05,0x43,0x43,0x01,0xc4,0x42,0x01,0x86,
		0x77,0x77,0xe1,0x0c,0x14,0x07,0x47,0x26,0xc2,0x74,0x33,0x11,0x33,
		0x00,0x03,0x00,0x31,0x13,0x33,0x36,0x74,0x12,0x44,0x44,0x30,0x44,
		0x31,0x01,0xbf,0x01,0x8e,0x33,0x33,0x21,0x23,0x89,0x18,0x44,0x11,
		0x36,0x74,0x1a,0x83,0x21,0x26,0x01,0x86,0xf2,0x48,0xc2,0x0c,0x14,
		0x07,0x46,0x26,0xc2,0x63,0x11,0x00,0x04,0x13,0x2d,0x56,0x42,0x01,
		0x83,0x14,0x01,0xbf,0x01,0x94,0x31,0x18,0xc5,0x6f,0x35,0x1a,0xc5,
		0x01,0x87,0x77,0x1e,0xc6,0x05,0x8e,0x07,0x47,0x26,0xc2,0x45,0x33,
		0x74,0x85,0x63,0x44,0x46,0x7b,0x44,0x54,0x01,0xbf,0x96,0x01,0x92,
		0x53,0x35,0x75,0x05,0x34,0x1a,0xc5,0x01,0x87,0x57,0xf8,0x1e,0xc6,
		0x05,0x8e,0x07,0x47,0x26,0xc2,0xc5,0x85,0x66,0x66,0x31,0x9d,0x7b,
		0x44,0x77,0x41,0x01,0xbf,0x01,0x93,0x18,0x86,0x63,0xe0,0x86,0xfc,
		0xe2,0x47,0x1e,0xc6,0x05,0x8e,0xe9,0xca,0x26,0xff,0x26,0xfc,0x60,
		0x06,0xd6,0xec,0x03,0x26,0xe3,0x70,0x13,0x84,0x70,0x05,0x02,0x15,
		0x43,0x00,0x7f,0x07,0x17,0x05,0x01,0x85,0x03,0x46,0x01,0x86,0x0a,
		0x45,0x05,0x08,0x03,0x4c,0xe2,0x26,0xcd,0x0a,0x44,0x26,0xd9,0x66,
		0x06,0x00,0x4d,0xdb,0x60,0x7f,0x00,0x00,0x43,0x26,0xc9,0x23,0x03,
		0x28,0x83,0x03,0x83,0x2a,0x48,0x03,0x47,0xfd,0x01,0x85,0x31,0x47,
		0x03,0x46,0x2f,0x85,0x03,0x48,0x26,0xd3,0x00,0x48,0x02,0x82,0x1d,
		0x82,0x60,0x60,0x66,0x00,0x00,0x01,0x82,0x06,0x7d,0x00,0x01,0x82,
		0x26,0xc5,0x4d,0xc3,0x03,0x83,0x26,0xca,0x06,0x26,0xc9,0x3f,0x66,
		0x66,0x0c,0x82,0x26,0xca,0x01,0x86,0x23,0x47,0x43,0x46,0x26,0xcc,
		0xf7,0x23,0x4d,0x4c,0x05,0x26,0xcd,0x36,0x8c,0x66,0x20,0x82,0x1c,
		0x42,0x26,0xc3,0x13,0x60,0x06,0x60,0x01,0x83,0x06,0x60,0x74,0xc6,
		0x4d,0xc4,0x3f,0x06,0x06,0x20,0x42,0x26,0xc9,0x23,0x42,0x4d,0xcb,
		0x26,0xcb,0x23,0x47,0xf3,0x1c,0x46,0x26,0xd9,0x25,0x0d,0x5a,0x0d,
		0x77,0x07,0x7f,0x4a,0x4d,0xc2,0xfe,0x4e,0x42,0x26,0xc4,0x48,0x82,
		0x01,0x83,0x49,0xc3,0xc2,0xc9,0x4d,0x82,0x60,0xbf,0x9d,0x83,0x00,
		0x09,0x04,0x32,0x42,0x4d,0xc9,0x00,0x43,0x26,0xcb,0x6d,0xcb,0xbf,
		0x18,0xc6,0x70,0x21,0x86,0x94,0xc7,0x23,0x4c,0x2d,0xce,0x5f,0x4b,
		0x4d,0xc9,0xff,0x1b,0xc3,0x74,0xc4,0x28,0x85,0x4d,0xc5,0x7a,0x42,
		0x2a,0xc3,0x4d,0xc3,0x53,0x82,0xff,0x9b,0xc8,0x23,0x82,0x9b,0xcf,
		0xb4,0xc5,0x46,0xce,0x26,0xc6,0x1c,0x46,0xa2,0xc5,0xff,0x26,0xd4,
		0xc2,0xd5,0x0f,0x84,0x9b,0xd3,0x26,0xc5,0x74,0xc2,0x9b,0xc5,0x4d,
		0xc4,0xfb,0xc2,0xc8,0x0a,0xc2,0xe9,0xd4,0x6a,0x47,0x66,0xc6,0x70,
		0x03,0x5a,0xef,0x0d,0xfd,0x25,0x0d,0x9d,0x8b,0xe9,0xd8,0x4d,0x83,
		0x2a,0xc2,0xe9,0xd7,0x15,0x0e,0x06,0x2c,0x32,0x67,0x13,0x84,0x42,
		0x01,0xbf,0x01,0x92,0x41,0x56,0xe2,0x26,0xc6,0x1a,0xc5,0x01,0x87,
		0x47,0x77,0x15,0x26,0x83,0x00,0xe8,0x05,0x8e,0x07,0x47,0x26,0xc2,
		0x43,0x0d,0xc5,0x64,0x24,0x47,0x9a,0x11,0x83,0x75,0x34,0x01,0xbf,
		0x01,0x93,0x36,0x18,0xc5,0x42,0xde,0x1a,0xc5,0x01,0x87,0x77,0x1e,
		0xc6,0x05,0x8e,0x07,0x47,0x26,0xc2,0x74,0x20,0x11,0x33,0x00,0x02,
		0x32,0x12,0x67,0x41,0x24,0x0d,0x44,0x44,0x43,0x13,0x01,0xbf,0x01,
		0x95,0x13,0x18,0xc3,0x37,0x21,0x26,0x1a,0xc4,0x01,0x88,0x77,0x1e,
		0xc5,0x05,0x8f,0x07,0x47,0xfe,0x8d,0xc3,0x00,0x3f,0x00,0x3f,0x00,
		0x17,0x26,0xff,0x00,0x3f,0x26,0xde,0x63,0x42,0x11,0x00,0x03,0x35,
		0x77,0x76,0x31,0x01,0xc3,0x13,0x63,0x57,0x05,0x42,0x04,0x85,0x11,
		0x13,0x56,0x04,0x84,0x07,0x02,0xfa,0x04,0x18,0x0b,0x42,0x0b,0x3f,
		0x0b,0x18,0x26,0xc2,0x33,0xd1,0x04,0x34,0x16,0x57,0x73,0x35,0xc7,
		0x84,0x45,0x26,0xc2,0x04,0x85,0x66,0x3f,0x63,0x43,0x04,0x84,0x07,
		0x02,0x04,0x18,0x0b,0x42,0x0b,0x3f,0x0b,0x18,0xae,0x26,0xc2,0x16,
		0xec,0x86,0x71,0x07,0x06,0x26,0xc2,0x04,0x85,0x66,0x2f,0x66,0x31,
		0x01,0xc6,0x63,0x04,0x18,0x0b,0x42,0x0b,0x3f,0x0b,0x18,0xf8,0x26,
		0xff,0x26,0xff,0x26,0xff,0x1b,0xbf,0x26,0xfb,0x00,0x60,0x60,0x41,
		0x00,0x26,0xc3,0x60,0x00,0x00,0x06,0x60,0x26,0xc6,0x33,0x60,0x66,
		0x00,0x83,0x0c,0x02,0x06,0x66,0x07,0x03,0x04,0x04,0x3e,0x00,0x06,
		0x04,0x05,0x02,0xc2,0x04,0x08,0x1b,0x84,0x06,0xcb,0x06,0xdc,0x0b,
		0x0e,0x0f,0x48,0x06,0x0b,0x06,0x01,0xc2,0x05,0x82,0x31,0x66,0x7d,
		0x60,0x09,0x04,0x06,0xc2,0x04,0x02,0x09,0x02,0x04,0x05,0x66,0x04,
		0x09,0xb3,0x26,0xc5,0x60,0x00,0x02,0x26,0xc4,0x60,0x60,0x26,0xd4,
		0x33,0x04,0xff,0x0e,0x04,0x1b,0x8e,0x02,0xc2,0x26,0xc7,0x13,0xc2,
		0x26,0xcd,0x04,0x08,0x32,0x08,0xe6,0x16,0x84,0x1b,0x02,0x26,0xc6,
		0x06,0x00,0x0b,0x05,0x04,0x04,0x60,0xf3,0x04,0x06,0x2b,0x03,0x04,
		0x06,0x4d,0xc8,0x60,0x00,0x26,0xc5,0x10,0x05,0x9f,0x1b,0x82,0x00,
		0x06,0x29,0x82,0x33,0x03,0x04,0x42,0x22,0x84,0x04,0x0a,0xff,0x32,
		0x43,0x04,0x04,0x13,0x02,0x26,0xc4,0x02,0x85,0x0b,0x05,0x06,0xc8,
		0x46,0xc4,0xff,0x64,0x85,0x04,0x05,0x26,0xc7,0x02,0x02,0x26,0xc5,
		0x14,0x42,0x22,0x84,0x04,0x0a,0x76,0x06,0x04,0x06,0x27,0x82,0x26,
		0xc5,0x06,0x4e,0x03,0x4d,0xc6,0x06,0x7f,0x06,0x4d,0xc8,0x1b,0x84,
		0x3e,0x4b,0x4d,0xc8,0x04,0x07,0x06,0xc2,0x4d,0xc8,0xff,0x0b,0x0f,
		0x4d,0xc7,0x0b,0x08,0x26,0xc6,0x04,0xc4,0x06,0xc4,0x70,0x87,0x0d,
		0x45,0xff,0x04,0x05,0x26,0xc3,0x6a,0xc6,0x4d,0xc6,0x00,0x03,0x9b,
		0xc5,0x2e,0x82,0xc2,0xc6,0xff,0x07,0xc4,0x0c,0x04,0x3e,0x45,0x04,
		0x02,0x90,0x85,0x04,0x02,0x1b,0x84,0x04,0x05,0xff,0x1b,0x8f,0x0b,
		0x11,0x04,0x07,0x9b,0xc7,0x32,0x45,0xbe,0x83,0x09,0x03,0x06,0xc3,
		0xfe,0x09,0x04,0x04,0x05,0x26,0xc5,0x04,0x04,0xe9,0xff,0xe9,0xff,
		0xe9,0xe0,0x15,0xbc,0x26,0xc7,0x56,0x26,0xc8,0x04,0x85,0x0c,0x02,
		0x04,0x85,0x66,0x63,0xfa,0x04,0x18,0x0b,0x42,0x0b,0x3f,0x0b,0x18,
		0x26,0xc2,0x43,0x02,0x84,0x42,0x13,0x77,0x74,0x36,0x01,0xc3,0x64,
		0x27,0x26,0xc2,0x04,0x85,0x1f,0x66,0x64,0x24,0x04,0x84,0x07,0x02,
		0x04,0x18,0x0b,0x42,0x0b,0x3f,0xc0,0x0b,0x18,0x26,0xc2,0x74,0x11,
		0x33,0x33,0x33,0x21,0x00,0x26,0x77,0x77,0x41,0x13,0x33,0x33,0x32,
		0x3f,0x12,0x67,0x26,0xc2,0x04,0x84,0x02,0xc3,0x04,0x83,0x07,0x03,
		0x04,0x19,0xff,0x0b,0x3f,0x0b,0x1a,0x26,0xc2,0x00,0x3f,0x00,0x3f,
		0x00,0x18,0x26,0xff,0x00,0x3f,0x80,0x26,0xdd};


typedef struct {
	UINT8	left;
	UINT8	keys;
	UINT8	left1;
	UINT8	left2;
	UINT8	base;
	UINT8	right;
} FULLKEY;

typedef struct {
	FULLKEY	fk[4];
	UINT8	cur0[5];
	UINT8	cur1[5];
	UINT8	ten[20];
} KEYTBL;

static const KEYTBL keytbl = {
		// fullkey 4
		   {{17, 13, 0x00, 0x00, 0x01, 0x0e},
			{24, 12, 0x0f, 0x0f, 0x10, 0x1c},
			{28, 12, 0x74, 0xf1, 0x1d, 0x1c},
			{34, 11, 0x70, 0x70, 0x29, 0x70}},

		// 220
		   {0x38, 0x36, 0x3a, 0x3b, 0x3d},
		   {0x39, 0x37, 0x3a, 0x3c, 0x3d},

		// 252
		   {0x3e, 0x3f, 0x40, 0x41,
			0x42, 0x43, 0x44, 0x45,
			0x46, 0x47, 0x48, 0x49,
			0x4a, 0x4b, 0x4c, 0x4d,
			0x4e, 0x4f, 0x50, 0x1c}};


static UINT getsoftkbd(int x, int y) {

	UINT		posy;
const FULLKEY	*fk;

	if ((y >= 2) && (y < 16)) {
		x -= 2;
		if (x < 0) {
			return(SOFTKEY_NC);
		}
		if (x < (21 - 4)) {
			return((x < 14)?0x60:SOFTKEY_NC);
		}
		x -= (21 - 4);
		if (x < (42 - 21)) {
			return((x < 14)?0x61:SOFTKEY_NC);
		}
		x -= (42 - 21);
		if (x < (132 - 42)) {
			x /= 17;
			return((x < 5)?(0x62 + x):SOFTKEY_NC);
		}
		x -= (132 - 42);
		if (x < (222 - 132)) {
			x /= 17;
			return((x < 5)?(0x67 + x):SOFTKEY_NC);
		}
		x -= (222 - 132);
		x /= 17;
		return((x < 5)?(0x52 + x):SOFTKEY_NC);
	}
	x -= 2;
	posy = (y - 18) / 14;
	if ((posy >= 5) || (x < 0)) {
		return(SOFTKEY_NC);
	}
	if (x < (220 - 4)) {			// fullkey
		if (posy < 4) {
			fk = keytbl.fk + posy;
			x -= fk->left;
			if (x < -14) {
				return(fk->left1);
			}
			else if (x < 0) {
				return(fk->left2);
			}
			x /= 14;
			if (x < (int)fk->keys) {
				return(fk->base + x);
			}
			return(fk->right);
		}
		else {
			x -= (31 - 4);
			if (x < 0) {
				return(SOFTKEY_NC);
			}
			x -= 14;
			if (x < 0) {
				return(0xf2);
			}
			x -= 14;
			if (x < 0) {
				return(0x73);
			}
			x -= 21;
			if (x < 0) {
				return(0x51);
			}
			x -= 91;
			if (x < 0) {
				return(0x34);
			}
			if (x < 21) {
				return(0x35);
			}
		}
		return(SOFTKEY_NC);
	}
	x -= (220 - 4);
	if (x < (252 - 220)) {			// cur
		if (x < 14) {
			return(keytbl.cur0[posy]);
		}
		else if (x < 28) {
			return(keytbl.cur1[posy]);
		}
		return(SOFTKEY_NC);
	}
	x -= (252 - 220);
	if (x < 14*5) {					// ten key
		x = x / 14;
		return(keytbl.ten[x + posy * 4]);
	}
	return(SOFTKEY_NC);
}

static void ledpaint(CMNVRAM *vram) {

	UINT	col;

	col = (softkbd.led & 4)?9:8;
	cmndraw_fill(vram, 6, 77, 3, 3, softkbd.pal[col]);
	col = (softkbd.led & 8)?9:8;
	cmndraw_fill(vram, 6, 83, 3, 3, softkbd.pal[col]);
}

