/**
 * @file	externalpsg.cpp
 * @brief	O PSG tNX̓̒`s܂
 */

#include "compiler.h"
#include "externalpsg.h"

/**
 * RXgN^
 * @param[in] pChip `bv
 */
CExternalPsg::CExternalPsg(IExternalChip* pChip)
	: m_pChip(pChip)
	, m_cPsgMix(0x3f)
{
}

/**
 * fXgN^
 */
CExternalPsg::~CExternalPsg()
{
	delete m_pChip;
}

/**
 * `bv ^Cv𓾂
 * @return `bv ^Cv
 */
IExternalChip::ChipType CExternalPsg::GetChipType()
{
	return m_pChip->GetChipType();
}

/**
 * Zbg
 */
void CExternalPsg::Reset()
{
	m_cPsgMix = 0x3f;
	m_pChip->Reset();
}

/**
 * WX^
 * @param[in] nAddr AhX
 * @param[in] cData f[^
 */
void CExternalPsg::WriteRegister(UINT nAddr, UINT8 cData)
{
	if (nAddr < 0x0e)
	{
		if (nAddr == 0x07)
		{
			// psg mix
			cData &= 0x3f;
			if (m_cPsgMix == cData)
			{
				return;
			}
			m_cPsgMix = cData;
		}
		WriteRegisterInner(nAddr, cData);
	}
}

/**
 * bZ[W
 * @param[in] nMessage bZ[W
 * @param[in] nParameter p[^
 * @return 
 */
INTPTR CExternalPsg::Message(UINT nMessage, INTPTR nParameter)
{
	switch (nMessage)
	{
		case kMute:
			Mute(nParameter != 0);
			break;
	}
	return 0;
}

/**
 * ~[g
 * @param[in] bMute ~[g
 */
void CExternalPsg::Mute(bool bMute) const
{
	WriteRegisterInner(0x07, (bMute) ? 0x3f : m_cPsgMix);
}

/**
 * WX^()
 * @param[in] nAddr AhX
 * @param[in] cData f[^
 */
void CExternalPsg::WriteRegisterInner(UINT nAddr, UINT8 cData) const
{
	m_pChip->WriteRegister(nAddr, cData);
}
