/**
 * @file	scciif.h
 * @brief	SCCI ANZX NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include "../externalchip.h"

class SoundChip;
class SoundInterfaceManager;

/**
 * @brief SCCI ANZX NX
 */
class CScciIf
{
public:
	CScciIf();
	~CScciIf();
	bool Initialize();
	void Deinitialize();
	void Reset();
	IExternalChip* GetInterface(IExternalChip::ChipType nChipType, UINT nClock);

private:
	HMODULE m_hModule;					/*!< W[ */
	SoundInterfaceManager* m_pManager;	/*!< }l[W */

	/**
	 * @brief `bv NX
	 */
	class Chip : public IExternalChip
	{
	public:
		Chip(CScciIf* pScciIf, SoundChip* pSoundChip);
		virtual ~Chip();
		operator SoundChip*();
		virtual ChipType GetChipType();
		virtual void Reset();
		virtual void WriteRegister(UINT nAddr, UINT8 cData);
		virtual INTPTR Message(UINT nMessage, INTPTR nParameter = 0);

	private:
		CScciIf* m_pScciIf;			/*!< eCX^X */
		SoundChip* m_pSoundChip;	/*!< `bv CX^X */
	};

	void Detach(Chip* pChip);
	friend class Chip;
};
