
// QVGA 320x40 (SUPPORT_SOFTKBD == 1 / QVGA)

static const UINT8 np2kbd_bmp[2179] = {
		0x76,0x19,0x00,
		0x04,0x05,0x42,0x4d,0x76,0x19,0x00,0x00,0x04,0x76,0x00,0x32,0x48,
		0x28,0x00,0x32,0x40,0x01,0x00,0x75,0x01,0x00,0x04,0xea,0x01,0x85,
		0x01,0xf6,0x00,0x03,0x10,0x00,0x32,0x0d,0x00,0xb6,0x60,0x00,0x60,
		0x60,0x00,0x7a,0x7a,0x7a,0x00,0x84,0x00,0x84,0x84,0x00,0x8c,0x8c,
		0x8c,0x00,0xac,0x00,0xac,0xac,0x00,0xbc,0xbc,0xbc,0x00,0xc6,0x00,
		0xc6,0xc6,0x00,0xce,0xce,0xce,0x00,0xe8,0x00,0xe8,0xe8,0x00,0xf0,
		0xf0,0xf0,0x00,0xf0,0x0c,0xff,0xff,0x00,0xff,0x00,0x32,0x00,0x0b,
		0xbb,0xbb,0x2e,0xbb,0xb0,0x00,0x62,0x0b,0x00,0x44,0x00,0xc2,0x00,
		0x0a,0x82,0x4b,0x22,0x00,0x04,0x5b,0xb8,0x00,0x75,0x25,0x01,0xaa,
		0x01,0x24,0x50,0x58,0x00,0x44,0x52,0x01,0xc4,0x55,0x84,0x24,0x22,
		0x65,0x42,0x00,0x2f,0x00,0x2b,0x26,0x85,0x04,0x45,0x5b,0x04,0x4e,
		0xae,0x06,0x25,0xbb,0x03,0xe3,0x26,0x00,0x49,0x07,0xa3,0x06,0xf7,
		0xb0,0x00,0x0c,0xcc,0x70,0xcc,0x00,0x00,0xcc,0x07,0x24,0x7c,0xc0,
		0x0a,0x0d,0x28,0x99,0x00,0x04,0x56,0xb2,0x4d,0x89,0x00,0x74,0x95,
		0x6b,0x01,0xa9,0x01,0x24,0x52,0x00,0x43,0x26,0x55,0x95,0x01,0xc4,
		0x59,0x4a,0x0d,0xbd,0x00,0x0f,0xbb,0x16,0xb6,0x59,0x59,0x04,0x44,
		0x96,0x04,0x4e,0x06,0x25,0xbb,0xb8,0x03,0xe3,0xb6,0x00,0x49,0x07,
		0xa3,0x06,0xf7,0x0c,0xcc,0xcc,0x00,0x0c,0xcc,0x0c,0xc0,0xcc,0xc0,
		0xcc,0xcc,0x40,0xc0,0x05,0x2c,0x29,0x99,0x09,0x99,0x10,0x09,0x81,
		0x09,0xf2,0x99,0x90,0x99,0x90,0x10,0x09,0x09,0xfc,0x00,0x90,0x91,
		0x90,0x99,0x52,0x90,0x11,0x91,0x00,0x09,0x55,0x95,0x71,0x10,0x90,
		0x10,0x19,0x30,0x59,0x2b,0x09,0x0f,0x09,0xff,0x59,0x57,0x10,0x09,
		0x34,0x01,0x01,0x09,0xfc,0x09,0xa3,0x11,0x09,0xf5,0x2b,0xbb,0x03,
		0x00,0xbb,0xb6,0x2b,0xbb,0x0b,0x00,0x43,0x02,0xc2,0xce,0x07,0xa3,
		0x06,0xf6,0xb0,0xcc,0x09,0xf2,0x09,0xb2,0x00,0x33,0xcc,0xd4,0x14,
		0x0c,0x02,0x43,0x79,0x09,0xf7,0x19,0x09,0xfd,0x91,0x10,0x00,0x91,
		0x19,0x52,0x91,0x01,0x11,0x00,0x55,0x03,0x95,0x73,0x00,0x10,0x30,
		0x09,0x09,0xff,0x00,0x0f,0x84,0x13,0xf3,0x03,0x01,0x03,0x00,0x09,
		0xff,0x90,0x00,0x45,0x09,0x09,0xf5,0xb0,0xbb,0x0b,0x09,0xa2,0xb0,
		0x09,0xf3,0x85,0x0a,0x92,0x29,0x90,0x00,0x19,0x06,0xf6,0x0c,0x1d,
		0xb3,0x8f,0x00,0x04,0x00,0x00,0x0c,0x14,0x0c,0x02,0x42,0x13,0x62,
		0x09,0xf3,0x10,0x00,0x09,0x11,0x09,0xfe,0x90,0x01,0x10,0x00,0x08,
		0x52,0x91,0x91,0x09,0x13,0xf2,0x70,0x10,0x90,0x73,0x30,0x13,0xff,
		0x00,0x0f,0x09,0xf5,0x09,0x03,0x13,0xff,0x13,0xf9,0xe4,0x09,0xf5,
		0x14,0x44,0x09,0xf3,0x99,0x09,0x06,0xf7,0xb0,0x00,0xde,0x14,0x24,
		0x14,0x53,0xcc,0x28,0x0d,0x13,0xf3,0x0d,0xd2,0x13,0xf4,0x10,0xc8,
		0x09,0xfe,0x01,0xa3,0x52,0x90,0x13,0xf3,0x85,0x71,0x10,0x38,0x10,
		0x10,0x13,0xff,0x00,0x0f,0x09,0xf2,0x56,0x57,0x10,0x3d,0x01,0x01,
		0x13,0xff,0x09,0xff,0x02,0x72,0x1d,0xf6,0x99,0x06,0xfa,0xc4,0x09,
		0xf6,0x3c,0x0f,0x28,0x99,0x10,0x13,0x92,0x99,0x48,0x09,0xb2,0x89,
		0x91,0x09,0x14,0x82,0x94,0x8b,0x2d,0xae,0x4b,0x44,0x00,0x43,0x45,
		0x65,0x2e,0x14,0x58,0x31,0xff,0x00,0x0f,0x2d,0xb5,0x56,0x31,0xf5,
		0x88,0x04,0x4e,0x09,0xf4,0x48,0x31,0xf2,0x1f,0x00,0xbb,0xb5,0x04,
		0x33,0x00,0x45,0x31,0xf2,0x06,0xfa,0x09,0xf5,0x09,0xc3,0x00,0x37,
		0x30,0x45,0xfd,0x25,0x55,0x00,0x02,0x09,0x42,0x8b,0xb8,0x22,0x00,
		0x73,0x54,0x28,0x45,0xfc,0xa8,0x01,0x82,0x88,0x00,0x44,0x52,0x02,
		0x53,0x42,0x58,0x84,0x31,0x46,0x66,0x00,0x0f,0x00,0x0b,0x65,0x28,
		0x85,0x04,0x53,0x3a,0x54,0x25,0x0e,0x4a,0x05,0x75,0x06,0x24,0xbb,
		0x03,0xe2,0x65,0x3c,0x28,0x94,0x00,0x48,0x07,0xa2,0x06,0xfb,0x3c,
		0x22,0xcc,0xcc,0x0c,0x70,0xb0,0xcc,0x70,0x4f,0xff,0x4f,0xfe,0x65,
		0x55,0x4f,0x55,0x00,0xb5,0x45,0x55,0x4f,0x04,0x4b,0x1a,0x00,0x4f,
		0x00,0x4f,0xbe,0x00,0x47,0x65,0x04,0x18,0x54,0x4a,0x4f,0xff,0x4f,
		0xfc,0x14,0x06,0xc7,0x18,0x0b,0xb0,0x3c,0x13,0xfd,0x4f,0xff,0x6b,
		0xbb,0x59,0x7e,0x99,0x4e,0xd5,0x00,0x63,0x4b,0x1e,0x00,0x4f,0x00,
		0x4f,0x00,0x47,0x59,0xbc,0x04,0x18,0x6b,0x54,0x49,0x4f,0xff,0x4f,
		0xfc,0x09,0xf3,0x03,0xcc,0x0f,0xcc,0x30,0x0b,0xbb,0x27,0xfe,0x31,
		0xf3,0x00,0x22,0x45,0xf5,0x42,0x01,0x09,0xf6,0x90,0x01,0x41,0x01,
		0x2b,0xb2,0x99,0x0d,0x99,0x2b,0xb0,0x00,0x2d,0x12,0x37,0x6a,0x11,
		0x00,0x42,0xfd,0x36,0xc2,0x01,0x36,0x01,0x85,0x4c,0xf7,0x00,0xe2,
		0x01,0xd4,0x0b,0x09,0xf2,0xa7,0x04,0x17,0x6b,0x05,0x73,0x99,0x52,
		0x06,0x24,0x4f,0xf2,0x45,0xa3,0xff,0x05,0x24,0x3b,0xf5,0x09,0xfb,
		0x64,0x12,0x00,0x02,0x63,0xde,0x09,0xf5,0x31,0xf2,0xe1,0x09,0xf4,
		0x00,0x22,0x09,0xf5,0x97,0x01,0x01,0x01,0x3f,0xb2,0xfb,0x09,0xf3,
		0x07,0x75,0x08,0xb8,0x09,0xf4,0x00,0xe4,0xb0,0x01,0x38,0x4c,0xf7,
		0xb2,0x0a,0x99,0x59,0x04,0x18,0x09,0xf2,0x10,0x11,0x09,0xf2,0x11,
		0x72,0x01,0x09,0xf8,0x02,0x54,0x03,0x93,0x29,0x91,0x4f,0xf8,0xbb,
		0xda,0x77,0x82,0x31,0xf5,0x30,0x78,0xd4,0x4f,0xfd,0x19,0x4f,0xf7,
		0x00,0x9e,0x13,0xf7,0x71,0x01,0x13,0xf6,0x4a,0xc8,0x0a,0x9b,0x00,
		0xe4,0x11,0xff,0x00,0x93,0x00,0x43,0x02,0x29,0x07,0xe5,0x09,0xf4,
		0x04,0x17,0x09,0xff,0x02,0x58,0xff,0x00,0x42,0x13,0xfd,0x0a,0x05,
		0x09,0xde,0x4f,0xf6,0x1d,0xf7,0x13,0xf7,0x19,0xd3,0xf7,0x6a,0x62,
		0x09,0xf3,0x13,0xa8,0x00,0x4f,0x0b,0x09,0xf8,0x4c,0xf7,0x02,0xc5,
		0xfe,0x09,0xf6,0x04,0x16,0x1d,0xfe,0x21,0x9c,0x13,0xfa,0x8b,0x82,
		0x4f,0xe5,0xcc,0x78,0xc7,0x50,0x0e,0x4f,0xf3,0x09,0xf2,0x4f,0xf4,
		0x91,0x01,0x99,0xc9,0x48,0xf2,0x31,0xfa,0x98,0x4a,0x22,0xc2,0xb5,
		0x4a,0x04,0xc2,0xff,0x4b,0x12,0x4b,0xb3,0x00,0x94,0x13,0xf2,0x00,
		0x97,0x01,0x84,0x4c,0xf7,0x00,0x49,0x9b,0x31,0xf8,0x98,0x8b,0x54,
		0x49,0x4f,0xf3,0xb0,0x02,0x03,0x50,0x44,0xf0,0x00,0x42,0x31,0xf3,
		0x4f,0xf8,0x1e,0x02,0x0c,0xc7,0x7c,0xc0,0xe1,0x96,0xc5,0x4f,0xff,
		0x4f,0xfc,0x85,0x55,0x55,0x24,0x01,0x34,0x1e,0x45,0x55,0x56,0x4a,
		0xc9,0x00,0x4f,0x00,0x4f,0x00,0x4c,0x95,0xaf,0x04,0x17,0x58,0x54,
		0x45,0x68,0x00,0x43,0x4f,0xff,0x4f,0xfd,0x31,0xd3,0x3f,0x00,0x07,
		0x50,0x13,0x9f,0xff,0x4f,0xff,0x49,0x64,0x00,0x44,0x4d,0xaf,0xff,
		0x00,0x4f,0x00,0x4f,0x00,0x4c,0x50,0x05,0x9f,0xff,0x4f,0xff,0x4f,
		0xf7,0xaa,0x53,0x1d,0xcc,0x00,0x03,0x27,0xf2,0x14,0x0e,0x4f,0xff,
		0x6b,0x01,0x14,0x7d,0x95,0x00,0x44,0x4d,0xaf,0x00,0x4f,0x00,0x4f,
		0x00,0x4b,0x55,0x04,0xe4,0x7f,0x88,0x4f,0xf5,0x9f,0xff,0x4f,0xff,
		0x77,0xd8,0x3c,0x13,0x4f,0xff,0x45,0xf2,0x70,0x19,0x31,0xf5,0x27,
		0xf2,0x02,0xf2,0x29,0x00,0x90,0x90,0x2f,0x05,0x29,0xbc,0x62,0x95,
		0x3a,0xeb,0x3c,0x28,0x54,0x02,0x51,0x1b,0xed,0x02,0x26,0x3c,0x78,
		0x02,0x23,0xb1,0x00,0x92,0x09,0xf5,0x95,0x31,0xf2,0xf4,0x9f,0xfb,
		0x3b,0xa3,0x01,0xd3,0x4f,0xf6,0x11,0x09,0xfc,0xc7,0xcc,0x3c,0xcc,
		0x7c,0x64,0x23,0x09,0xff,0x59,0xf9,0x3b,0xf4,0x29,0x09,0x01,0x90,
		0x90,0x95,0x29,0x09,0x13,0x70,0x09,0xf2,0xff,0x07,0x74,0x3b,0x8a,
		0x50,0xcc,0x50,0x76,0x0b,0x88,0x43,0xcc,0x09,0xff,0x8b,0xf5,0xbe,
		0x04,0xf3,0xb5,0x3b,0xf8,0x09,0xfe,0xa9,0xf3,0x09,0xff,0x4f,0xf4,
		0x70,0xf3,0x13,0xf4,0x4f,0xf2,0x13,0xf5,0x09,0xf5,0x10,0x07,0x13,
		0xf6,0x12,0x6b,0xff,0x00,0x93,0x59,0x84,0x0b,0x89,0x56,0xd5,0x46,
		0x29,0x09,0xff,0x09,0xfc,0x13,0xf8,0x8f,0x04,0xa3,0x29,0x90,0x11,
		0x95,0xf8,0x09,0xf9,0xb3,0xed,0x13,0xff,0x81,0x1d,0xf4,0x10,0x10,
		0x95,0x29,0x00,0x11,0x1d,0xf8,0xff,0x13,0x5a,0x5a,0x7c,0x09,0xf5,
		0x13,0xff,0x09,0xf9,0x05,0x82,0x09,0xf5,0xb3,0xf9,0xfe,0x02,0xc8,
		0x00,0x43,0x13,0xfb,0x09,0x83,0x09,0xf6,0x81,0xff,0x9f,0xf2,0x19,
		0xdf,0x4f,0xfb,0x49,0x64,0x48,0x00,0x43,0x4a,0xa7,0x4f,0x38,0x00,
		0x93,0x00,0xe5,0xf9,0x4f,0x85,0x00,0x97,0x06,0xd2,0x50,0x2b,0x12,
		0x12,0xb5,0x55,0x0e,0xd2,0x3d,0x00,0x69,0x09,0xf2,0x9f,0xff,0x04,
		0x57,0x4f,0xf3,0x11,0x4f,0xf8,0xcc,0xd1,0xc2,0x31,0xe5,0xc0,0x7c,
		0x95,0xfe,0x4f,0xff,0xbb,0x84,0xaf,0x49,0x62,0x26,0x49,0xb3,0x26,
		0x4d,0xaf,0x00,0x4f,0x00,0x4f,0x00,0x4a,0x27,0x26,0x65,0x19,0x74,
		0x95,0x6b,0x9f,0xff,0x4f,0xff,0x4f,0xe7,0x6f,0xc7,0xd1,0x93,0x00,
		0x02,0x07,0xdb,0xf7,0x47,0xd6,0x4f,0xff,0x9f,0xf2,0xbc,0xee,0xc4,
		0x24,0x9f,0xbf,0x00,0x4f,0x00,0x4f,0xa0,0x0d,0x56,0x95,0xfa,0x13,
		0xf2,0xc2,0xe3,0x9f,0xff,0x4f,0xff,0x59,0xe8,0x7c,0x8b,0xf5,0x33,
		0xff,0x09,0xf7,0x47,0xd6,0x4f,0xff,0x77,0xf2,0xba,0x34,0xee,0xc5,
		0x4d,0x5f,0x00,0x4f,0xef,0x00,0x4f,0xa0,0x08,0x72,0x33,0x09,0xcf,
		0xe3,0x9f,0xff,0x4f,0xff,0xe5,0xf7,0x28,0xc7,0xc7,0x09,0xf5,0x37,
		0x3c,0x07,0x29,0x00,0x09,0x70,0x00,0x30,0xd3,0x95,0xfb,0xe8,0xf4,
		0x59,0x59,0x90,0x90,0xff,0xee,0xc5,0x4d,0x58,0xa0,0x5a,0x96,0x03,
		0x00,0x45,0xa0,0xf8,0x8d,0xea,0x03,0x15,0x61,0x1b,0x09,0xf5,0xd9,
		0xe4,0xb2,0x90,0x00,0x10,0xf4,0x42,0xfa,0x96,0xd2,0x4f,0xf3,0x98,
		0x04,0x4f,0xff,0x3b,0xe5,0x70,0x1d,0xf5,0x03,0x43,0x7c,0x3c,0x06,
		0x29,0x09,0x09,0x90,0x09,0xf6,0xdb,0xf7,0x9f,0x09,0xf9,0x00,0x17,
		0xda,0xc2,0x44,0x95,0x94,0x74,0x07,0xc4,0x39,0xa4,0xfd,0x09,0xf8,
		0xa0,0xff,0x0a,0x44,0x8d,0x43,0x08,0x43,0x09,0xf5,0x00,0x09,0xf4,
		0xbf,0x1e,0x62,0x52,0x05,0x12,0x09,0xf4,0x3b,0xf5,0x3f,0xb6,0x4d,
		0xa2,0xe5,0xf8,0x3f,0xcc,0xc0,0x13,0xe2,0x8c,0x43,0x00,0x72,0x09,
		0xf7,0x44,0x62,0x09,0xf2,0xec,0x4f,0xf2,0x09,0x92,0x4f,0xf4,0x09,
		0x95,0xf5,0x13,0xf3,0x11,0x79,0xff,0x09,0xf2,0x07,0x74,0x09,0xf4,
		0x64,0x28,0x13,0x0b,0x09,0xfd,0x97,0x48,0x09,0xf9,0xff,0x45,0xf4,
		0x18,0xb2,0xea,0x43,0x13,0xf5,0xef,0xfa,0x59,0xfc,0x6d,0xe4,0x77,
		0x82,0xf8,0x96,0x54,0x1d,0xf7,0x09,0xf5,0x4f,0xfa,0xb3,0xf6,0x59,
		0x10,0x17,0x38,0x07,0x00,0x1d,0xf2,0x62,0x9b,0x09,0x0c,0xb1,0x11,
		0x1b,0xff,0x09,0xff,0x51,0x1a,0x09,0xfe,0x00,0x63,0x9f,0xf2,0x6d,
		0xf5,0x67,0xbc,0x13,0xfa,0xaf,0x31,0xf2,0xc0,0x81,0x74,0x00,0x00,
		0x82,0x31,0xf9,0x4e,0xd4,0x4f,0xf9,0x3f,0x90,0x00,0x9f,0xf4,0x5f,
		0xa5,0xee,0xc2,0x9f,0x1a,0x50,0x2c,0x9f,0xba,0x72,0x11,0x9d,0x07,
		0x01,0xd6,0x00,0xe4,0x1b,0xb5,0x09,0xf7,0x66,0xfd,0x9f,0xfd,0x4f,
		0xa8,0x4f,0xff,0xaa,0x02,0x63,0x66,0x00,0x88,0x92,0x47,0xd5,0xa9,
		0x4f,0xf8,0x29,0x9f,0xf8,0x52,0xe5,0x82,0x55,0x25,0x9f,0xbf,0xf3,
		0x00,0x4f,0x00,0x4f,0xa0,0x0e,0xa0,0x14,0x52,0x48,0xf4,0x4a,0x4f,
		0xff,0xff,0xef,0xff,0x00,0x0e,0x4f,0xff,0x9f,0xfc,0x9f,0xbf,0x00,
		0x4f,0x00,0x4f,0x00,0x4f,0xff,0x4d,0xd6,0x04,0xe2,0x4f,0xfb,0xa5,
		0x99,0x00,0x49,0x09,0x6f,0x9f,0x8c,0x4f,0xff,0xff,0x01,0x19,0x9f,
		0xbf,0x00,0x4f,0x00,0x4f,0x00,0x4f,0x4d,0xd5,0x27,0xf3,0x4f,0xfa,
		0xf7,0xa5,0x99,0x00,0x49,0xef,0xf9,0xd1,0x8f,0x00,0x83,0xd4,0x31,
		0xfb,0x9f,0xf8,0xfe,0x51,0x92,0xea,0xbe,0x9b,0xae,0x4c,0x9e,0x9f,
		0xba,0x00,0x45,0x33,0x62,0x29,0x12,0x91,0x01,0x10,0x45,0xf4,0x11,
		0x01,0x3b,0xf3,0x10,0x8b,0x3b,0xf2,0x29,0x01,0x00,0x91,0x92,0x01,
		0x31,0x52,0xdb,0xa4,0x77,0x29,0x39,0x12,0x09,0xff,0x09,0xfa,0x70,
		0x8a,0x12,0x09,0xfd,0x8b,0xf6,0x3b,0x04,0x97,0x55,0x82,0xea,0xbe,
		0x0a,0x95,0xb8,0x3a,0x99,0x4c,0x9c,0xe2,0x00,0x97,0xfa,0x88,0x43,
		0xd3,0x91,0x70,0x97,0x09,0xf4,0x10,0x02,0x00,0x19,0x52,0x90,0x11,
		0x10,0x13,0xf2,0x29,0xcf,0xbb,0xc2,0x91,0x92,0x19,0x01,0x09,0xa2,
		0x0a,0x44,0x56,0xf4,0x00,0x0f,0x8f,0x09,0xf7,0x07,0x11,0x01,0x4f,
		0xf6,0x09,0xf5,0x64,0xf2,0x13,0xf5,0x1f,0x04,0x90,0x79,0x09,0xf8,
		0x00,0x48,0x9b,0xad,0x4c,0x9e,0x0c,0x2a,0x83,0x47,0x68,0x29,0x91,
		0x17,0x10,0x79,0x13,0xf5,0x09,0xf2,0x4b,0x01,0x09,0xf4,0x01,0x00,
		0x9b,0x92,0x01,0x09,0xf3,0x13,0xf4,0xfb,0x4c,0xf5,0x00,0x0f,0x1d,
		0xf8,0x0c,0xc2,0x13,0xf5,0x90,0x13,0xf7,0x16,0xf4,0xfd,0x1d,0xf7,
		0xea,0xbc,0x9b,0xae,0xf1,0x7f,0x13,0xfa,0x03,0x63,0xa1,0x52,0x02,
		0x7f,0x29,0x1d,0x33,0x4f,0xfd,0x09,0x56,0x00,0x4a,0x4f,0xf8,0x00,
		0x0f,0x4f,0xfc,0xff,0x0a,0x22,0x4f,0xf4,0x00,0x72,0x9f,0xf6,0x9f,
		0xb3,0xea,0xbc,0x9b,0xae,0x4c,0x9e,0xfb,0x00,0x46,0xa0,0x08,0x51,
		0xb3,0x04,0x65,0x4f,0xf5,0x42,0x4f,0xf5,0x07,0x24,0xfd,0x00,0x4e,
		0xef,0xf7,0x00,0x0f,0x4f,0xf7,0x9e,0xd2,0x4f,0xf5,0x42,0x9f,0xfa,
		0xfb,0x00,0x72,0x4d,0x5f,0x00,0x4f,0x00,0x4f,0x00,0x4f,0x28,0x05,
		0xf2,0x04,0xe3,0x9f,0x05,0x73,0x42,0x88,0x00,0x43,0x4f,0xf2,0x07,
		0x23,0x00,0x4e,0x08,0xb4};


typedef struct {
	UINT8	left;
	UINT8	keys;
	UINT8	left1;
	UINT8	left2;
	UINT8	base;
	UINT8	right;
} FULLKEY;

typedef struct {
	FULLKEY	fk[4];
	UINT8	cur0[5];
	UINT8	cur1[5];
	UINT8	ten[20];
} KEYTBL;

static const KEYTBL keytbl = {
		// fullkey 90
		   {{12, 13, 0x00, 0x00, 0x01, 0x0e},
			{16, 12, 0x0f, 0x0f, 0x10, 0x1c},
			{20, 12, 0x74, 0xf1, 0x1d, 0x1c},
			{24, 11, 0x70, 0x70, 0x29, 0x70}},

		// 247
		   {0x38, 0x36, 0x3a, 0x3b, 0x3d},
		   {0x39, 0x37, 0x3a, 0x3c, 0x3d},

		// 270
		   {0x3e, 0x3f, 0x40, 0x41,
			0x42, 0x43, 0x44, 0x45,
			0x46, 0x47, 0x48, 0x49,
			0x4a, 0x4b, 0x4c, 0x4d,
			0x4e, 0x4f, 0x50, 0x1c}};


static UINT getsoftkbd(int x, int y) {

	UINT		posy;
const FULLKEY	*fk;

	if ((x >= 0) && (x < 32) && (y >= 8) && (y < 40)) {
		return(SOFTKEY_MENU);
	}
	x -= 40;
	posy = y >> 3;
	if ((posy >= 5) || (x < 0)) {
		return(SOFTKEY_NC);
	}
	if (x < (54 - 40)) {			// stop/copy
		if ((x < 10) && (posy < 2)) {
			return(0x60 + posy);
		}
		return(SOFTKEY_NC);
	}
	x -= (54 - 40);
	if (x < (90 - 54)) {			// function
		if (x < 15) {
			return(0x62 + posy);
		}
		if ((x >= 17) && (x < 32)) {
			return(0x67 + posy);
		}
		return(SOFTKEY_NC);
	}
	x -= (90 - 54);
	if (x < (247 - 90)) {			// fullkey
		if (posy < 4) {
			if (x < 153) {
				fk = keytbl.fk + posy;
				x -= fk->left;
				if (x < -10) {
					return(fk->left1);
				}
				else if (x < 0) {
					return(fk->left2);
				}
				x = (x * (((1 << 12) / 10) + 1)) >> 12;
				if (x < (int)fk->keys) {
					return(fk->base + x);
				}
				return(fk->right);
			}
		}
		else {
			x -= 19;
			if (x < 0) {
				return(SOFTKEY_NC);
			}
			x -= 10;
			if (x < 0) {
				return(0xf2);
			}
			x -= 10;
			if (x < 0) {
				return(0x73);
			}
			x -= 15;
			if (x < 0) {
				return(0x51);
			}
			x -= 66;
			if (x < 0) {
				return(0x34);
			}
			if (x < 15) {
				return(0x35);
			}
		}
		return(SOFTKEY_NC);
	}
	x -= (247 - 90);
	if (x < (270 - 247)) {			// cur
		if (x < 10) {
			return(keytbl.cur0[posy]);
		}
		else if (x < 20) {
			return(keytbl.cur1[posy]);
		}
		return(SOFTKEY_NC);
	}
	x -= (270 - 247);
	if (x < (310 - 270)) {			// ten key
		x = (x * (((1 << 12) / 10) + 1)) >> 12;
		return(keytbl.ten[x + posy * 4]);
	}
	return(SOFTKEY_NC);
}

#define	ledpaint(v)

