
#define	IDM_MAINMENU	128

#define	MAKE_MENUID(a, b)	((a << 16) | b)

// --------------------------------------------------------------- system menu

enum {
	IDM_APPLE			= 128,
	IDM_EMULATE			= 129,
	IDM_EDIT			= 130,
	IDM_STATSAVE		= 131,
	IDM_FDD1			= 132,
	IDM_FDD2			= 133,
	IDM_FDD3			= 134,
	IDM_FDD4			= 135,
	IDM_HARDDISK		= 136,
	IDM_SASI1			= 137,
	IDM_SASI2			= 138,
	IDM_SCSI0			= 139,
	IDM_SCSI1			= 140,
	IDM_SCSI2			= 141,
	IDM_SCSI3			= 142,
	IDM_SCREEN			= 143,
	IDM_DEVICE			= 144,
	IDM_KEYBOARD		= 145,
	IDM_SOUND			= 146,
	IDM_MEMORY			= 147,
	IDM_OTHER			= 148,

	IDM_ABOUT			= MAKE_MENUID(IDM_APPLE, 1),

	IDM_RESET			= MAKE_MENUID(IDM_EMULATE, 1),
	IDM_CONFIGURE		= MAKE_MENUID(IDM_EMULATE, 3),
	IDM_NEWDISK			= MAKE_MENUID(IDM_EMULATE, 4),
	IDM_FONT			= MAKE_MENUID(IDM_EMULATE, 5),
	IDM_EXIT			= MAKE_MENUID(IDM_EMULATE, 7),

	IDM_FDD1OPEN		= MAKE_MENUID(IDM_FDD1, 1),
	IDM_FDD1EJECT		= MAKE_MENUID(IDM_FDD1, 3),

	IDM_FDD2OPEN		= MAKE_MENUID(IDM_FDD2, 1),
	IDM_FDD2EJECT		= MAKE_MENUID(IDM_FDD2, 3),

	IDM_FDD3OPEN		= MAKE_MENUID(IDM_FDD3, 1),
	IDM_FDD3EJECT		= MAKE_MENUID(IDM_FDD3, 3),

	IDM_FDD4OPEN		= MAKE_MENUID(IDM_FDD4, 1),
	IDM_FDD4EJECT		= MAKE_MENUID(IDM_FDD4, 3),

	IDM_SASI1OPEN		= MAKE_MENUID(IDM_SASI1, 1),
	IDM_SASI1REMOVE		= MAKE_MENUID(IDM_SASI1, 3),

	IDM_SASI2OPEN		= MAKE_MENUID(IDM_SASI2, 1),
	IDM_SASI2REMOVE		= MAKE_MENUID(IDM_SASI2, 3),

	IDM_SCSI0OPEN		= MAKE_MENUID(IDM_SCSI0, 1),
	IDM_SCSI0REMOVE		= MAKE_MENUID(IDM_SCSI0, 3),

	IDM_SCSI1OPEN		= MAKE_MENUID(IDM_SCSI1, 1),
	IDM_SCSI1REMOVE		= MAKE_MENUID(IDM_SCSI1, 3),

	IDM_SCSI2OPEN		= MAKE_MENUID(IDM_SCSI2, 1),
	IDM_SCSI2REMOVE		= MAKE_MENUID(IDM_SCSI2, 3),

	IDM_SCSI3OPEN		= MAKE_MENUID(IDM_SCSI3, 1),
	IDM_SCSI3REMOVE		= MAKE_MENUID(IDM_SCSI3, 3),

	IDM_ROLNORMAL		= MAKE_MENUID(IDM_SCREEN, 1),
	IDM_ROLLEFT			= MAKE_MENUID(IDM_SCREEN, 2),
	IDM_ROLRIGHT		= MAKE_MENUID(IDM_SCREEN, 3),
	IDM_DISPSYNC		= MAKE_MENUID(IDM_SCREEN, 5),
	IDM_RASTER			= MAKE_MENUID(IDM_SCREEN, 6),
	IDM_NOWAIT			= MAKE_MENUID(IDM_SCREEN, 7),
	IDM_AUTOFPS			= MAKE_MENUID(IDM_SCREEN, 8),
	IDM_60FPS			= MAKE_MENUID(IDM_SCREEN, 9),
	IDM_30FPS			= MAKE_MENUID(IDM_SCREEN, 10),
	IDM_20FPS			= MAKE_MENUID(IDM_SCREEN, 11),
	IDM_15FPS			= MAKE_MENUID(IDM_SCREEN, 12),
	IDM_SCREENOPT		= MAKE_MENUID(IDM_SCREEN, 14),

	IDM_MOUSE			= MAKE_MENUID(IDM_DEVICE, 4),
	IDM_SEROPT			= MAKE_MENUID(IDM_DEVICE, 6),
	IDM_MIDIOPT			= MAKE_MENUID(IDM_DEVICE, 8),
	IDM_MIDIPANIC		= MAKE_MENUID(IDM_DEVICE, 9),
	IDM_SNDOPT			= MAKE_MENUID(IDM_DEVICE, 11),

	IDM_KEY				= MAKE_MENUID(IDM_KEYBOARD, 1),
	IDM_JOY1			= MAKE_MENUID(IDM_KEYBOARD, 2),
	IDM_JOY2			= MAKE_MENUID(IDM_KEYBOARD, 3),
	IDM_MOUSEKEY		= MAKE_MENUID(IDM_KEYBOARD, 4),
	IDM_XSHIFT			= MAKE_MENUID(IDM_KEYBOARD, 6),
	IDM_XCTRL			= MAKE_MENUID(IDM_KEYBOARD, 7),
	IDM_XGRPH			= MAKE_MENUID(IDM_KEYBOARD, 8),
	IDM_F11KANA			= MAKE_MENUID(IDM_KEYBOARD, 10),
	IDM_F11STOP			= MAKE_MENUID(IDM_KEYBOARD, 11),
	IDM_F11NFER			= MAKE_MENUID(IDM_KEYBOARD, 12),
	IDM_F11USER			= MAKE_MENUID(IDM_KEYBOARD, 13),
	IDM_F12MOUSE		= MAKE_MENUID(IDM_KEYBOARD, 15),
	IDM_F12COPY			= MAKE_MENUID(IDM_KEYBOARD, 16),
	IDM_F12XFER			= MAKE_MENUID(IDM_KEYBOARD, 17),
	IDM_F12USER			= MAKE_MENUID(IDM_KEYBOARD, 18),

	IDM_BEEPOFF			= MAKE_MENUID(IDM_SOUND, 1),
	IDM_BEEPLOW			= MAKE_MENUID(IDM_SOUND, 2),
	IDM_BEEPMID			= MAKE_MENUID(IDM_SOUND, 3),
	IDM_BEEPHIGH		= MAKE_MENUID(IDM_SOUND, 4),
	IDM_NOSOUND			= MAKE_MENUID(IDM_SOUND, 6),
	IDM_PC9801_14		= MAKE_MENUID(IDM_SOUND, 7),
	IDM_PC9801_26K		= MAKE_MENUID(IDM_SOUND, 8),
	IDM_PC9801_86		= MAKE_MENUID(IDM_SOUND, 9),
	IDM_PC9801_26_86	= MAKE_MENUID(IDM_SOUND, 10),
	IDM_PC9801_86_CB	= MAKE_MENUID(IDM_SOUND, 11),
	IDM_PC9801_118		= MAKE_MENUID(IDM_SOUND, 12),
	IDM_SPEAKBOARD		= MAKE_MENUID(IDM_SOUND, 13),
	IDM_SPARKBOARD		= MAKE_MENUID(IDM_SOUND, 14),
	IDM_AMD98			= MAKE_MENUID(IDM_SOUND, 15),
	IDM_JASTSND			= MAKE_MENUID(IDM_SOUND, 16),
	IDM_SEEKSND			= MAKE_MENUID(IDM_SOUND, 18),

	IDM_MEM640			= MAKE_MENUID(IDM_MEMORY, 1),
	IDM_MEM16			= MAKE_MENUID(IDM_MEMORY, 2),
	IDM_MEM36			= MAKE_MENUID(IDM_MEMORY, 3),
	IDM_MEM76			= MAKE_MENUID(IDM_MEMORY, 4),
	IDM_MEM116			= MAKE_MENUID(IDM_MEMORY, 5),
	IDM_MEM136			= MAKE_MENUID(IDM_MEMORY, 6),

	IDM_BMPSAVE			= MAKE_MENUID(IDM_OTHER, 1),
	IDM_S98LOGGING		= MAKE_MENUID(IDM_OTHER, 2),
	IDM_CALENDAR		= MAKE_MENUID(IDM_OTHER, 3),
	IDM_DISPCLOCK		= MAKE_MENUID(IDM_OTHER, 4),
	IDM_DISPFLAME		= MAKE_MENUID(IDM_OTHER, 5),
	IDM_JOYX			= MAKE_MENUID(IDM_OTHER, 6),
	IDM_RAPID			= MAKE_MENUID(IDM_OTHER, 7),
	IDM_MSRAPID			= MAKE_MENUID(IDM_OTHER, 8),
	IDM_I286SAVE		= MAKE_MENUID(IDM_OTHER, 9)
};


// -------------------------------------------------------------------- dialog

enum {
	IDOK				= 1,
	IDCANCEL			= 2,

	IDD_ABOUT			= 128,
	IDD_VERSION			= 4,

	IDD_RESUMEERROR		= 129,

	IDD_RESUMEWARNING	= 130,
	IDC_RESUMEEXIT		= 3,
	IDC_RESUMEREASON	= 6,

	IDD_CONFIGURE		= 131,
	IDC_BASECLOCK20		= 4,
	IDC_BASECLOCK25		= 5,
	IDC_MULTIPLE		= 7,
	IDC_CLOCKMSG		= 8,
	IDC_MODELVM			= 11,
	IDC_MODELVX			= 12,
	IDC_MODELEPSON		= 13,
	IDC_RATE11			= 16,
	IDC_RATE22			= 17,
	IDC_RATE44			= 18,
	IDC_SOUNDBUF		= 20,
	IDC_RESUME			= 22,

	IDD_NEWFDDDISK		= 132,
	IDD_NEWFDDDISK2		= 133,
	IDC_DISKLABEL		= 4,
	IDC_MAKE2DD			= 6,
	IDC_MAKE2HD			= 7,
	IDC_MAKE144			= 8,

	IDD_NEWHDDDISK		= 134,
	IDC_HDDSIZE			= 3,
	IDC_HDDLIMIT		= 6,

	IDD_NEWSASIHDD		= 135,
	IDC_NEWSASI5MB		= 3,
	IDC_NEWSASI10MB		= 4,
	IDC_NEWSASI15MB		= 5,
	IDC_NEWSASI20MB		= 6,
	IDC_NEWSASI30MB		= 7,
	IDC_NEWSASI40MB		= 8,

	IDD_SCREENOPT		= 136,
	IDC_LCD				= 23,
	IDC_LCDX			= 24,
	IDC_SKIPLINE		= 25,
	IDC_SKIPLIGHT		= 26,
	IDC_GDC7220			= 4,
	IDC_GDC72020		= 5,
	IDC_GRCGNON			= 7,
	IDC_GRCG			= 8,
	IDC_GRCG2			= 9,
	IDC_EGC				= 10,
	IDC_PC980124		= 11,
	IDC_TRAMWAIT		= 13,
	IDC_VRAMWAIT		= 16,
	IDC_GRCGWAIT		= 19,
	IDC_REALPAL			= 22,

	IDD_MPU98II			= 137,
	IDC_MPUPORT			= 3,
	IDC_MPUIRQ			= 4,
	IDC_MPUDEF			= 5,

	IDD_CALENDAR		= 138,
	IDC_CLNDREAL		= 3,
	IDC_CLNDVIR			= 4,
	IDC_VIRDATE			= 5,
	IDC_VIRTIME			= 6,
	IDC_SETNOW			= 7
};


// ------------------------------------------------------------------ Messages

enum {
	IDT_TITLE			= 128,
	IDT_NEWDISK			= 129,
	IDT_NEWHDDDISK		= 130
};

