
enum {
	RGB24_B	= 2,
	RGB24_G	= 1,
	RGB24_R	= 0
};

typedef struct {
	BYTE	*ptr;
	int		xalign;
	int		yalign;
	int		width;
	int		height;
	UINT	bpp;
	int		extend;
} SCRNSURF;

enum {
	SCRNMODE_FULLSCREEN		= 0x01,
	SCRNMODE_HIGHCOLOR		= 0x02,
	SCRNMODE_ROTATE			= 0x10,
	SCRNMODE_ROTATEDIR		= 0x20,
	SCRNMODE_ROTATELEFT		= (SCRNMODE_ROTATE + 0),
	SCRNMODE_ROTATERIGHT	= (SCRNMODE_ROTATE + SCRNMODE_ROTATEDIR),
	SCRNMODE_ROTATEMASK		= 0x30
};

enum {
	SCRNFLAG_FULLSCREEN		= 0x01,
	SCRNFLAG_HAVEEXTEND		= 0x02,
	SCRNFLAG_ENABLE			= 0x80
};


#ifdef __cplusplus
extern "C" {
#endif

void scrnmng_initialize(void);
BOOL scrnmng_create(BYTE scrnmode);
void scrnmng_destroy(void);

void scrnmng_setwidth(int posx, int width);
void scrnmng_setextend(int extend);
void scrnmng_setheight(int posy, int height);
const SCRNSURF *scrnmng_surflock(void);
void scrnmng_surfunlock(const SCRNSURF *surf);
#define scrnmng_update()
#define scrnmng_dispclock()

#define	scrnmng_isfullscreen()		(0)
#define	scrnmng_haveextend()		(0)
#ifdef NP2GCC
int	scrnmng_getbpp(void);
#else
#define	scrnmng_getbpp()			(32)
#endif
#define	scrnmng_allflash()
#define	scrnmng_palchanged()
#ifdef NP2GCC
UINT16 scrnmng_makepal16(RGB32 pal32);
#else
#define	scrnmng_makepal16(pal32)	(0)
#endif

#ifdef __cplusplus
}
#endif

