#include	"compiler.h"
#include	"parts.h"
#include	"np2.h"
#include	"scrnmng.h"
#include	"timemng.h"
#include	"dclock.h"
#include	"scrndraw.h"
#include	"palettes.h"


	_DCLOCK		dclock;
	DCLOCKPAL	dclockpal;


// ------------------------------------------------------------------ font1

static const UINT8 clockchr1[11][16] = {
			{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,},
			{0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78,},
			{0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,},
			{0x78, 0xcc, 0xcc, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xfc,},
			{0xfc, 0x18, 0x30, 0x70, 0x18, 0x0c, 0x0c, 0xcc, 0x78,},
			{0x18, 0x38, 0x78, 0xd8, 0xd8, 0xfc, 0x18, 0x18, 0x18,},
			{0xfc, 0xc0, 0xc0, 0xf8, 0x0c, 0x0c, 0x0c, 0x8c, 0x78,},
			{0x38, 0x60, 0xc0, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0x78,},
			{0xfc, 0x0c, 0x0c, 0x18, 0x18, 0x18, 0x30, 0x30, 0x30,},
			{0x78, 0xcc, 0xcc, 0xcc, 0x78, 0xcc, 0xcc, 0xcc, 0x78,},
			{0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x18, 0x70,}};

static const DCPOS dclockpos1[6] = {
						{dclock.dat + 0, (UINT16)(~0x00fc), 0, 0},
						{dclock.dat + 0, (UINT16)(~0xf801), 7, 0},
						{dclock.dat + 2, (UINT16)(~0x801f), 3, 0},
						{dclock.dat + 3, (UINT16)(~0x003f), 2, 0},
						{dclock.dat + 4, (UINT16)(~0xf003), 6, 0},
						{dclock.dat + 5, (UINT16)(~0xe007), 5, 0}};

static void resetfont1(void) {

	UINT32	pat;

	if (np2oscfg.clk_x) {
		if (np2oscfg.clk_x <= 4) {
			pat = 0x00008001;
		}
		else {
			pat = 0x30008001;
		}
		*(UINT32 *)(dclock.dat + 1 + ( 4 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + ( 5 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + ( 9 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + (10 * DCLOCK_YALIGN)) = pat;
	}
}


// ------------------------------------------------------------------ font2

// 5x9
static const UINT8 clockchr2[11][16] = {
			{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,},
			{0x00, 0x00, 0x30, 0x48, 0x88, 0x88, 0x88, 0x88, 0x70,},
			{0x10, 0x30, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x20,},
			{0x38, 0x44, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0xf8,},
			{0x7c, 0x08, 0x10, 0x30, 0x10, 0x08, 0x08, 0x90, 0x60,},
			{0x20, 0x40, 0x40, 0x88, 0x88, 0x90, 0x78, 0x10, 0x20,},
			{0x3c, 0x20, 0x20, 0x70, 0x08, 0x08, 0x08, 0x90, 0x60,},
			{0x10, 0x10, 0x20, 0x70, 0x48, 0x88, 0x88, 0x90, 0x60,},
			{0x7c, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40,},
			{0x38, 0x44, 0x44, 0x48, 0x30, 0x48, 0x88, 0x88, 0x70,},
			{0x18, 0x24, 0x40, 0x44, 0x48, 0x38, 0x10, 0x20, 0x20,}};

static const DCPOS dclockpos2[6] = {
						{dclock.dat + 0, (UINT16)(~0x00fc), 0, 0},
						{dclock.dat + 0, (UINT16)(~0xf003), 6, 0},
						{dclock.dat + 2, (UINT16)(~0x00fc), 0, 0},
						{dclock.dat + 2, (UINT16)(~0xf003), 6, 0},
						{dclock.dat + 4, (UINT16)(~0x00fc), 0, 0},
						{dclock.dat + 4, (UINT16)(~0xf003), 6, 0}};

static void resetfont2(void) {

	UINT32	pat;

	if (np2oscfg.clk_x) {
		if (np2oscfg.clk_x <= 4) {
			pat = 0x00000002;
		}
		else {
			pat = 0x00020002;
		}
		*(UINT32 *)(dclock.dat + 1 + ( 4 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + ( 5 * DCLOCK_YALIGN)) = pat;
		pat <<= 1;
		*(UINT32 *)(dclock.dat + 1 + ( 9 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + (10 * DCLOCK_YALIGN)) = pat;
	}
}


// ------------------------------------------------------------------ font3

// 4x9
static const UINT8 clockchr3[11][16] = {
			{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,},
			{0x60, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x60,},
			{0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,},
			{0x60, 0x90, 0x90, 0x10, 0x20, 0x40, 0x40, 0x80, 0xf0,},
			{0x60, 0x90, 0x90, 0x10, 0x60, 0x10, 0x90, 0x90, 0x60,},
			{0x20, 0x60, 0x60, 0xa0, 0xa0, 0xa0, 0xf0, 0x20, 0x20,},
			{0xf0, 0x80, 0x80, 0xe0, 0x90, 0x10, 0x90, 0x90, 0x60,},
			{0x60, 0x90, 0x90, 0x80, 0xe0, 0x90, 0x90, 0x90, 0x60,},
			{0xf0, 0x10, 0x10, 0x20, 0x20, 0x20, 0x40, 0x40, 0x40,},
			{0x60, 0x90, 0x90, 0x90, 0x60, 0x90, 0x90, 0x90, 0x60,},
			{0x60, 0x90, 0x90, 0x90, 0x70, 0x10, 0x90, 0x90, 0x60,}};

static const DCPOS dclockpos3[6] = {
						{dclock.dat + 0, (UINT16)(~0x00f0), 0, 0},
						{dclock.dat + 0, (UINT16)(~0x8007), 5, 0},
						{dclock.dat + 1, (UINT16)(~0xc003), 6, 0},
						{dclock.dat + 2, (UINT16)(~0x001e), 3, 0},
						{dclock.dat + 3, (UINT16)(~0x000f), 4, 0},
						{dclock.dat + 4, (UINT16)(~0x0078), 1, 0}};

static void resetfont3(void) {

	UINT32	pat;

	if (np2oscfg.clk_x) {
		if (np2oscfg.clk_x <= 4) {
			pat = 0x00000010;
		}
		else {
			pat = 0x00400010;
		}
		*(UINT32 *)(dclock.dat + 1 + ( 4 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + ( 5 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + ( 9 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + (10 * DCLOCK_YALIGN)) = pat;
	}
}


// ------------------------------------------------------------------ font4

// 5x8
static const UINT8 clockchr4[11][16] = {
			{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,},
			{0x00, 0x70, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70,},
			{0x00, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70,},
			{0x00, 0x70, 0x88, 0x08, 0x08, 0x30, 0x40, 0x88, 0xf8,},
			{0x00, 0x70, 0x88, 0x08, 0x30, 0x08, 0x08, 0x08, 0xf0,},
			{0x00, 0x10, 0x30, 0x50, 0x50, 0x90, 0xf8, 0x10, 0x10,},
			{0x00, 0x38, 0x40, 0x60, 0x10, 0x08, 0x08, 0x08, 0xf0,},
			{0x00, 0x18, 0x20, 0x40, 0xb0, 0xc8, 0x88, 0x88, 0x70,},
			{0x00, 0x70, 0x88, 0x88, 0x10, 0x10, 0x10, 0x20, 0x20,},
			{0x00, 0x70, 0x88, 0x88, 0x70, 0x50, 0x88, 0x88, 0x70,},
			{0x00, 0x70, 0x88, 0x88, 0x88, 0x78, 0x10, 0x20, 0xc0,}};

static void resetfont4(void) {

	UINT32	pat;

	if (np2oscfg.clk_x) {
		if (np2oscfg.clk_x <= 4) {
			pat = 0x00000004;
		}
		else {
			pat = 0x00040004;
		}
		*(UINT32 *)(dclock.dat + 1 + ( 5 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + ( 6 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + ( 9 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + (10 * DCLOCK_YALIGN)) = pat;
	}
}


// ------------------------------------------------------------------ font5

static const UINT8 clockchr5[11][16] = {
			{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,},
			{0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70,},
			{0x00, 0x00, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20,},
			{0x00, 0x00, 0x70, 0x88, 0x08, 0x10, 0x20, 0x40, 0xf8,},
			{0x00, 0x00, 0xf8, 0x10, 0x20, 0x10, 0x08, 0x88, 0x70,},
			{0x00, 0x00, 0x30, 0x50, 0x50, 0x90, 0xf8, 0x10, 0x10,},
			{0x00, 0x00, 0xf8, 0x80, 0xf0, 0x08, 0x08, 0x88, 0x70,},
			{0x00, 0x00, 0x30, 0x40, 0xf0, 0x88, 0x88, 0x88, 0x70,},
			{0x00, 0x00, 0xf8, 0x08, 0x10, 0x20, 0x20, 0x40, 0x40,},
			{0x00, 0x00, 0x70, 0x88, 0x88, 0x70, 0x88, 0x88, 0x70,},
			{0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x78, 0x10, 0x60,}};

static const DCPOS dclockpos5[6] = {
						{dclock.dat + 0, (UINT16)(~0x00f8), 0, 0},
						{dclock.dat + 0, (UINT16)(~0xe003), 6, 0},
						{dclock.dat + 2, (UINT16)(~0x007c), 1, 0},
						{dclock.dat + 2, (UINT16)(~0xf001), 7, 0},
						{dclock.dat + 4, (UINT16)(~0x003e), 2, 0},
						{dclock.dat + 5, (UINT16)(~0x00f8), 0, 0}};

static void resetfont5(void) {

	UINT32	pat;

	if (np2oscfg.clk_x) {
		if (np2oscfg.clk_x <= 4) {
			pat = 0x00000006;
		}
		else {
			pat = 0x00030006;
		}
		*(UINT32 *)(dclock.dat + 1 + ( 6 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + ( 7 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + ( 9 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + (10 * DCLOCK_YALIGN)) = pat;
	}
}


// ------------------------------------------------------------------ font6

// 4x6
static const UINT8 clockchr6[11][16] = {
			{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,},
			{0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0x90, 0x90, 0x60,},
			{0x00, 0x00, 0x00, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20,},
			{0x00, 0x00, 0x00, 0x60, 0x90, 0x10, 0x20, 0x40, 0xf0,},
			{0x00, 0x00, 0x00, 0xf0, 0x20, 0x60, 0x10, 0x90, 0x60,},
			{0x00, 0x00, 0x00, 0x40, 0x80, 0xa0, 0xa0, 0xf0, 0x20,},
			{0x00, 0x00, 0x00, 0xf0, 0x80, 0x60, 0x10, 0x90, 0x60,},
			{0x00, 0x00, 0x00, 0x40, 0x80, 0xe0, 0x90, 0x90, 0x60,},
			{0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x20, 0x20, 0x40,},
			{0x00, 0x00, 0x00, 0x60, 0x90, 0x60, 0x90, 0x90, 0x60,},
			{0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0x70, 0x20, 0x40,}};

static const DCPOS dclockpos6[6] = {
						{dclock.dat + 0, (UINT16)(~0x00f0), 0, 0},
						{dclock.dat + 0, (UINT16)(~0x8007), 5, 0},
						{dclock.dat + 1, (UINT16)(~0x000f), 4, 0},
						{dclock.dat + 2, (UINT16)(~0x0078), 1, 0},
						{dclock.dat + 3, (UINT16)(~0x00f0), 0, 0},
						{dclock.dat + 3, (UINT16)(~0x8007), 5, 0}};

static void resetfont6(void) {

	UINT32	pat;

	if (np2oscfg.clk_x) {
		if (np2oscfg.clk_x <= 4) {
			pat = 0x00000020;
		}
		else {
			pat = 0x00000220;
		}
		*(UINT32 *)(dclock.dat + 1 + ( 8 * DCLOCK_YALIGN)) = pat;
		*(UINT32 *)(dclock.dat + 1 + (10 * DCLOCK_YALIGN)) = pat;
	}
}


// ------------------------------------------------------------------------

typedef struct {
const UINT8	*fnt;
const DCPOS	*pos;
	void	(*init)(void);
} DCLOCKFNT;

static const DCLOCKFNT fonttype[] =
					{{clockchr1[0], dclockpos1, resetfont1},
					 {clockchr2[0], dclockpos2, resetfont2},
					 {clockchr3[0], dclockpos3, resetfont3},
					 {clockchr4[0], dclockpos2, resetfont4},
					 {clockchr5[0], dclockpos5, resetfont5},
					 {clockchr6[0], dclockpos6, resetfont6}};


// ------------------------------------------------------------------------

void dclock_init(void) {

	pal_makegrad(dclockpal.pal32, 4,
									np2oscfg.clk_color1, np2oscfg.clk_color2);
}

static void dclock_palset8(void) {

	UINT8	i;
	UINT8	j;
	UINT32	work = 0;							// vc++4.2

	for (i=0; i<16; i++) {
		for (j=1; j<0x10; j<<=1) {
			work <<= 8;
			if (i & j) {
				work++;
			}
		}
		for (j=0; j<4; j++) {
			dclockpal.pal8[j][i] = work * (START_PALORG + j);
		}
	}
}

static void dclock_palset16(void) {

	UINT	i;

	for (i=0; i<4; i++) {
		dclockpal.pal16[i] = scrnmng_makepal16(dclockpal.pal32[i]);
	}
}

void dclock_palset(UINT bpp) {

	switch(bpp) {
		case 8:
			dclock_palset8();
			break;

		case 16:
			dclock_palset16();
			break;
	}
}




void dclock_reset(void) {

const DCLOCKFNT *fnt;

	ZeroMemory(&dclock, sizeof(dclock));

	if (np2oscfg.clk_x) {
		if (np2oscfg.clk_x <= 4) {
			np2oscfg.clk_x = 4;
		}
		else if (np2oscfg.clk_x <= 6) {
			np2oscfg.clk_x = 6;
		}
		else {
			np2oscfg.clk_x = 0;
		}
	}
	if (np2oscfg.clk_fnt >= NELEMENTS(fonttype)) {
		np2oscfg.clk_fnt = 0;
	}

	dclock.clk_x = np2oscfg.clk_x;
	fnt = fonttype + np2oscfg.clk_fnt;
	dclock.fnt = fnt->fnt;
	dclock.pos = fnt->pos;
	fnt->init();
	dclock_callback();
	dclock_redraw();
}

void dclock_callback(void) {

	int			i;
	UINT8		count = 13;
	UINT8		buf[8];
	_SYSTIME	st;

	if ((scrnmng_isfullscreen()) && (dclock.clk_x)) {
		timemng_gettime(&st);
		buf[0] = (st.hour / 10) + 1;
		buf[1] = (st.hour % 10) + 1;
		buf[2] = (st.minute / 10) + 1;
		buf[3] = (st.minute % 10) + 1;
		if (dclock.clk_x > 4) {
			buf[4] = (st.second / 10) + 1;
			buf[5] = (st.second % 10) + 1;
		}
		for (i=dclock.clk_x; i--;) {
			if (dclock.now[i] != buf[i]) {
				dclock.now[i] = buf[i];
				dclock.flm[i] = count;
				dclock.drawing |= (1 << i);
				count += 4;
			}
		}
	}
}

void dclock_redraw(void) {

	dclock.drawing = 0x3f;
}

BOOL dclock_disp(void) {

	return((dclock.drawing != 0) ||
			(*(UINT32 *)(dclock.flm + 0) != 0) ||
			(*(UINT32 *)(dclock.flm + 4) != 0));
}

