@ECHO OFF

:: This script eschews absolute paths in case they contain Unicode characters

SET ERRORLEVEL=

IF "%~1"=="" GOTO NOT_FOUND
SET FILE="%~1"
SET  SIG="%~1.sig"
IF NOT EXIST %FILE% GOTO NOT_FOUND
IF NOT EXIST  %SIG% GOTO SIG_NOT_PRESENT

IF "%HOME%"=="" SET HOME=.
SET GPGV=%HOME%\gpgv.exe
SET OPTS=--homedir %HOME% --keyring %HOME%\pubring.gpg --ignore-time-conflict

IF NOT EXIST %GPGV% GOTO INSTALL_ERROR

:: This is necessary to stop the Application Data folder from getting created
IF NOT DEFINED GNUPGHOME SET GNUPGHOME=%HOME%

ECHO Attempting to verify %1
%GPGV% %OPTS% %SIG% %FILE% 2>NUL
SET RESULT=%ERRORLEVEL%

ECHO.
IF %RESULT% EQU 0 ECHO Signature is valid.
IF %RESULT% EQU 1 ECHO Signature is INVALID!

:: If signature check failed, delete this potentially compromised file
IF %RESULT% NEQ 0 (
DEL %FILE% 2>NUL
IF %RESULT% EQU 1 GOTO INVALID
ECHO.
ECHO Error code %RESULT% while checking signature.
ECHO.
PAUSE
)

ECHO.
EXIT /B %RESULT%

:NOT_FOUND
ECHO.
ECHO File not found %1
ECHO.
PAUSE
EXIT /B 10

:SIG_NOT_PRESENT
ECHO.
ECHO Signature file not found: %SIG%
ECHO.
PAUSE
EXIT /B 10

:INSTALL_ERROR
ECHO.
ECHO Installation error!
ECHO.
PAUSE
EXIT /B 20

:INVALID
ECHO.
ECHO The cryptographic signature does not match the contents of the file.
ECHO.
ECHO At best, this means that the downloaded file or signature is corrupt,
ECHO truncated, or something of that nature. The problem may resolve itself.
ECHO.
ECHO At worst, it could mean that the server has been compromised.
ECHO.
ECHO Please try again later.
ECHO.
ECHO If the signature check fails consistently, you should not attempt to visit
ECHO the website, for your own safety.
ECHO.
ECHO Any previously downloaded files that passed this signature check should
ECHO still be safe (unless they were somehow modified on your computer.)
ECHO.
ECHO Contact mijeto for assistance at gmail.
ECHO.
PAUSE
EXIT /B 99