//=================================================================================
//"CRT" shader by Tyson Jacobs
// 1024x768 recommended. crt.png mask recommended
//=================================================================================

#include "Scaling.inc"

// The name of this effect
string name : NAME = "TysonCRT";
string combineTechique : COMBINETECHNIQUE = "TysonCRT";

struct VS_OUTPUT
{
	float4 Position		: POSITION;
	float2 UV			: TEXCOORD0;
	float2 abspos		: TEXCOORD2;
};

VS_OUTPUT VS(float3 Position : POSITION, float2 TexCoord : TEXCOORD0)
{
	VS_OUTPUT Out =	(VS_OUTPUT)0;
	Out.Position = mul(float4(Position, 1), WorldViewProjection);
	Out.UV = TexCoord;
	Out.abspos = Out.Position.xy;
    //Out.abspos = Position.y < 0 ? 0 : 600;

	return Out;
}

static float weightSum;
static float4 sum;
static float2 texCoordUnit;
static float2 pixelCenter;
static float2 currentPixel;

void ProcessPixel(float2 off)
{
  float2 pixelCoord = off*texCoordUnit + pixelCenter;
  float4 color = tex2D(SourceSampler, pixelCoord);
  color.a = distance(pixelCoord*SourceDims, currentPixel);
  color.a = clamp(1.5 - color.a, 0, 1);
  weightSum += color.a;
  sum += color*color.a;
}

float4 PS(in VS_OUTPUT input) : COLOR
{
  weightSum = 0;
  sum = 0;
  texCoordUnit = 1/SourceDims;
  currentPixel = input.UV * SourceDims;
  pixelCenter = floor(currentPixel)/SourceDims + texCoordUnit*.5;
  float4 colors[9];
  ProcessPixel(float2(-1, -1));
  ProcessPixel(float2( 0, -1));
  ProcessPixel(float2( 1, -1));
  ProcessPixel(float2(-1,  0));
  ProcessPixel(float2( 0,  0));
  ProcessPixel(float2( 1,  0));
  ProcessPixel(float2(-1,  1));
  ProcessPixel(float2( 0,  1));
  ProcessPixel(float2( 1,  1));
  float4 baseResult = sum/weightSum*.9;
  float4 result = baseResult + sum*.09;
  result = lerp(smoothstep(0.0,1.0,result), result, .2);
  float largest = result.r > result.g ? result.r : result.g;
  largest = largest > result.b ? largest : result.b;
  result -= (largest - result)*.4;
  //if (frac(input.abspos.y * .5) < .5) result = baseResult*.9;
  //result = input.abspos.y % 255;
  return result;
}

technique TysonCRT
{
	pass P0
	{
		VertexShader = compile vs_3_0 VS();
		PixelShader  = compile ps_3_0 PS();
		AlphaBlendEnable = FALSE;
		ColorWriteEnable = RED|GREEN|BLUE|ALPHA;
		SRGBWRITEENABLE = FALSE;
	}  
}
