//=================================================================================
//"CRT" shader by Tyson Jacobs modified by Leandro Jardim
// 1024x768 recommended. crt.png mask recommended
// Modification: http://eab.abime.net/showpost.php?p=1045300&postcount=51
// source 1: http://eab.abime.net/showpost.php?p=900154&postcount=18
// source 2: http://gamedev.stackexchange.com/questions/28782/hue-saturation-brightness-contrast-effect-in-hlsl
//=================================================================================

#include "Scaling.inc"

// The name of this effect
string name : NAME = "TysonCRT";
string combineTechique : COMBINETECHNIQUE = "TysonCRT";

struct VS_OUTPUT
{
	float4 Position		: POSITION;
	float2 UV			: TEXCOORD0;
	float2 abspos		: TEXCOORD2;
};

VS_OUTPUT VS(float3 Position : POSITION, float2 TexCoord : TEXCOORD0)
{
	VS_OUTPUT Out =	(VS_OUTPUT)0;
	Out.Position = mul(float4(Position, 1), WorldViewProjection);
	Out.UV = TexCoord;
	Out.abspos = Out.Position.xy;
    //Out.abspos = Position.y < 0 ? 0 : 600;

	return Out;
}

static const float Hue = 0;
static const float Brightness = 0.0;
static const float Contrast = 0.0;
static const float Saturation = 1.0;

static const float3 lumCoeff = float3(0.2125, 0.7154, 0.0721);

static float weightSum;
static float4 sum;
static float2 texCoordUnit;
static float2 pixelCenter;
static float2 currentPixel;

void ProcessPixel(float2 off)
{
  float2 pixelCoord = off*texCoordUnit + pixelCenter;
  float4 color = tex2D(SourceSampler, pixelCoord);
  color.a = distance(pixelCoord*SourceDims, currentPixel);
  color.a = clamp(1.5 - color.a, 0, 1);
  weightSum += color.a;
  sum += color*color.a;
}

float3x3 QuaternionToMatrix(float4 quat)
{
    float3 cross = quat.yzx * quat.zxy;
    float3 square= quat.xyz * quat.xyz;
    float3 wimag = quat.w * quat.xyz;

    square = square.xyz + square.yzx;

    float3 diag = 0.5 - square;
    float3 a = (cross + wimag);
    float3 b = (cross - wimag);

    return float3x3(
    2.0 * float3(diag.x, b.z, a.y),
    2.0 * float3(a.z, diag.y, b.x),
    2.0 * float3(b.y, a.x, diag.z));
}

float4 PS(in VS_OUTPUT input) : COLOR
{
  weightSum = 0;
  sum = 0;
  texCoordUnit = 1/SourceDims;
  currentPixel = input.UV * SourceDims;
  pixelCenter = floor(currentPixel)/SourceDims + texCoordUnit*.5;
  ProcessPixel(float2(-1, -1));
  ProcessPixel(float2( 0, -1));
  ProcessPixel(float2( 1, -1));
  ProcessPixel(float2(-1,  0));
  ProcessPixel(float2( 0,  0));
  ProcessPixel(float2( 1,  0));
  ProcessPixel(float2(-1,  1));
  ProcessPixel(float2( 0,  1));
  ProcessPixel(float2( 1,  1));
  float4 baseResult = sum/weightSum*.9;
  float4 result = baseResult + sum*.09;
  float3 root3 = float3(0.57735, 0.57735, 0.57735);
  float half_angle = 0.5 * radians(Hue); // Hue is radians of 0 tp 360 degree
  float4 rot_quat = float4( (root3 * sin(half_angle)), cos(half_angle));
  float3x3 rot_Matrix = QuaternionToMatrix(rot_quat);     
  result.rgb = mul(rot_Matrix, result.rgb);
  result.rgb = (result.rgb - 0.5) *(Contrast + 1.0) + 0.5;  
  result.rgb = result.rgb + Brightness;         
  float3 intensity = float(dot(result.rgb, lumCoeff));
  result.rgb = lerp(intensity, result.rgb, Saturation );            
  result = lerp(smoothstep(0.0,1.0,result), result, .2);
  float largest = result.r > result.g ? result.r : result.g;
  largest = largest > result.b ? largest : result.b;
  result -= (largest - result)*.4;
  //if (frac(input.abspos.y * .5) < .5) result = baseResult*.9;
  //result = input.abspos.y % 255;
  return result;
}

technique TysonCRT
{
	pass P0
	{
		VertexShader = compile vs_3_0 VS();
		PixelShader  = compile ps_3_0 PS();
		AlphaBlendEnable = FALSE;
		ColorWriteEnable = RED|GREEN|BLUE|ALPHA;
		SRGBWRITEENABLE = FALSE;
	}  
}
