/*
  Bump mapping shader coded by guest.r
*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

Texture2D Texture;
SamplerState TextureSampler;

static const float glow  = 1.25;  // max brightness on borders
static const float shde  = 0.75;  // max darkening
static const float bump  = 1.33;  // effect strenght - lower values bring more effect
static const float range = 1.00;  // effect width


struct PS_INPUT
{
    float4 p : SV_Position;
    float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
    float4 c : SV_Target0;
};


PS_OUTPUT ps_main(PS_INPUT input)
{
    PS_OUTPUT output;
    float2 pos = input.t;   

    float x = range/2048.0;
    float y = range/2048.0;
    float2 dg1 = float2( x, y); float2 dg2 = float2(-x, y);
    float2 ddx = float2(x,0.0); float2 ddy = float2(0.0,y);

    float3 c11 = Texture.Sample(TextureSampler,pos.xy).xyz;
    float3 c00 = Texture.Sample(TextureSampler,pos.xy - dg1).xyz;
    float3 c22 = Texture.Sample(TextureSampler,pos.xy + dg1).xyz;
//    float3 c20 = Texture.Sample(TextureSampler,pos.xy - dg2).xyz;
//    float3 c02 = Texture.Sample(TextureSampler,pos.xy + dg2).xyz;
    float3 c10 = Texture.Sample(TextureSampler,pos.xy - ddy).xyz;
    float3 c21 = Texture.Sample(TextureSampler,pos.xy + ddx).xyz;
    float3 c12 = Texture.Sample(TextureSampler,pos.xy + ddy).xyz;
    float3 c01 = Texture.Sample(TextureSampler,pos.xy - ddx).xyz;   
    float3 d11 = c11;

    c11 = (-c00+c22-c01+c21-c10+c12+bump*d11)/bump;
    c11 = min(c11,glow*d11);
    c11 = max(c11,shde*d11);

    output.c.a = 1.0;
    output.c.xyz = c11;

    return output;
}

#endif