// Process only LUMA (1), or all colors (0)
#define LUMA_ONLY 1
// Do RAMP (1) or level correction (0)
#define DO_RAMP 1

#define LEVEL_MIN 16.0
#define LEVEL_MAX 235.0

#ifndef SHADER_MODEL
#define GLSL 1
#else
#define GLSL 0
#endif

#if GLSL
#define float2 vec2
#define float3 vec3
#define float4 vec4
#define sample(x) texture(TextureSampler, x)
in SHADER
{
    vec4 p;
    vec2 t;
    vec4 c;
} PSin;

layout(location = 0) out vec4 SV_Target0;
#else
#define sample(x) Texture.Sample(TextureSampler, x)
Texture2D Texture : register(t0);
SamplerState TextureSampler : register(s0);
struct VS_OUTPUT
{
    float4 p : SV_Position;
    float2 t : TEXCOORD0;
};
struct PS_OUTPUT
{
    float4 c : SV_Target0;
};
#endif

#if LUMA_ONLY
#if 0
#define KR 0.299
#define KG 0.587
#define KB 0.114
#else
#define KR 0.2126
#define KG 0.0722
#define KB 0.7152
#endif

float3 rgb_to_ycbcr(float3 rgb)
{
	float3 ycbcr;
	ycbcr.r = KR*rgb.r + KG*rgb.g + KB*rgb.b;
	ycbcr.g = -0.5*KR/(1-KB)*rgb.r -0.5*KG/(1-KB)*rgb.g + 0.5*rgb.b;
	ycbcr.b = 0.5*rgb.r -0.5*KG/(1-KR)*rgb.g -0.5*KB/(1-KR)*rgb.b;
	return ycbcr;
}

float3 ycbcr_to_rgb(float3 ycbcr)
{
	float3 rgb;
	rgb.r = ycbcr.r + (2-2*KR)*ycbcr.b;
	rgb.g = ycbcr.r -KB/KG*(2-2*KB)*ycbcr.g -KR/KG*(2-2*KR)*ycbcr.b;
	rgb.b = ycbcr.r + (2-2*KB)*ycbcr.g;
	return rgb;
}
#endif

#if DO_RAMP
float ramp(float c)
{
    return c > 0.5 ? c : 0.5*c + c*c;
}
#else
float level(float c)
{
	return (c - LEVEL_MIN/255.0) * (255.0/(LEVEL_MAX-LEVEL_MIN));
}
#endif

#if GLSL
void ps_main()
#else
float4 ps_main(VS_OUTPUT PSin) : SV_Target0
#endif
{
    float4 col = sample(PSin.t);

#if LUMA_ONLY
	col.rgb = rgb_to_ycbcr(col.rgb);
	#if DO_RAMP
	col.r = ramp(col.r);
	#else
	col.r = level(col.r);
	#endif
	col.rgb = ycbcr_to_rgb(col.rgb);
#else
	#if DO_RAMP
	col.r = ramp(col.r);
    col.g = ramp(col.g);
    col.b = ramp(col.b);
	#else
	col.r = level(col.r);
    col.g = level(col.g);
    col.b = level(col.b);
	#endif
#endif

#if GLSL
	SV_Target0 = col;
#else
    return col;
#endif
}
