/*================================ [4xMSAL Filter Shader HLSL Version by Asmodean@pcsx2.net] ========================================
===================================  [CONTROLS FOR FILTER SMOOTHENING LEVEL ON LINE: 60*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

#if SHADER_MODEL >= 0x400
Texture2D dx_Texture;
SamplerState dx_TextureSampler
{
    Texture   = <dx_Texture>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};
struct PS_OUTPUT
{
	float4 c : SV_Target;
};

#else 
sampler2D dx_TextureSampler : register(s0); 
struct PS_OUTPUT
{
	float4 c : COLOR;
};
#endif

struct PS_INPUT
{
	float4 p : SV_POSITION;
	float2 t1 : TEXCOORD;
	float2 t2 : TEXCOORD;
	float2 t3 : TEXCOORD;
	float2 t4 : TEXCOORD;
};

struct VS_OUTPUT
{
	float4 p : SV_POSITION;
	float2 t : TEXCOORD0;
};

struct VS_INPUT
{
	float3 p : SV_POSITION;
	float2 t : TEXCOORD0;
};


PS_OUTPUT ps_main(PS_INPUT Input)
{ 	
	PS_OUTPUT output;
	float SMOOTH_LEVEL = 1.5; /* <------------Controls the filter level, lower equals sharper, higher equals smoother.*/
	float2 dx = float2(1.0/4096.0,0.0);
	float2 dy = float2(0.0,1.0/2048.0);
	float3 dt = float3(1.0,1.0,1.0);

	float3 c00, c02, c20, c22, u, d, r, l;
	float m1, m2;
	
#if SHADER_MODEL >= 0x400
{
	c00 = dx_Texture.Sample(dx_TextureSampler, Input.t1.xy-dy*SMOOTH_LEVEL).xyz; 
	c20 = dx_Texture.Sample(dx_TextureSampler, Input.t2.xy-dy*SMOOTH_LEVEL).xyz; 
	c02 = dx_Texture.Sample(dx_TextureSampler, Input.t4.xy-dy*SMOOTH_LEVEL).xyz; 
	c22 = dx_Texture.Sample(dx_TextureSampler, Input.t3.xy-dy*SMOOTH_LEVEL).xyz; 

	m1 = dot(abs(c00-c22),dt)+0.001;
	m2 = dot(abs(c02-c20),dt)+0.001;

	u = .5*(m2*(c00+c22)+m1*(c02+c20))/(m1+m2);

	c00 = dx_Texture.Sample(dx_TextureSampler, Input.t1.xy+dy*SMOOTH_LEVEL).xyz; 
	c20 = dx_Texture.Sample(dx_TextureSampler, Input.t2.xy+dy*SMOOTH_LEVEL).xyz; 
	c02 = dx_Texture.Sample(dx_TextureSampler, Input.t4.xy+dy*SMOOTH_LEVEL).xyz; 
	c22 = dx_Texture.Sample(dx_TextureSampler, Input.t3.xy+dy*SMOOTH_LEVEL).xyz; 
	
	m1 = dot(abs(c00-c22),dt)+0.001;
	m2 = dot(abs(c02-c20),dt)+0.001;

	d = .5*(m2*(c00+c22)+m1*(c02+c20))/(m1+m2);

	c00 = dx_Texture.Sample(dx_TextureSampler, Input.t1.xy-dx*SMOOTH_LEVEL).xyz; 
	c20 = dx_Texture.Sample(dx_TextureSampler, Input.t2.xy-dx*SMOOTH_LEVEL).xyz; 
	c02 = dx_Texture.Sample(dx_TextureSampler, Input.t4.xy-dx*SMOOTH_LEVEL).xyz; 
	c22 = dx_Texture.Sample(dx_TextureSampler, Input.t3.xy-dx*SMOOTH_LEVEL).xyz; 

	m1 = dot(abs(c00-c22),dt)+0.001;
	m2 = dot(abs(c02-c20),dt)+0.001;

	l = .5*(m2*(c00+c22)+m1*(c02+c20))/(m1+m2);

	c00 = dx_Texture.Sample(dx_TextureSampler, Input.t1.xy+dx*SMOOTH_LEVEL).xyz; 
	c20 = dx_Texture.Sample(dx_TextureSampler, Input.t2.xy+dx*SMOOTH_LEVEL).xyz; 
	c02 = dx_Texture.Sample(dx_TextureSampler, Input.t4.xy+dx*SMOOTH_LEVEL).xyz; 
	c22 = dx_Texture.Sample(dx_TextureSampler, Input.t3.xy+dx*SMOOTH_LEVEL).xyz; 
	
	m1 = dot(abs(c00-c22),dt)+0.001;
	m2 = dot(abs(c02-c20),dt)+0.001;

	r = .5*(m2*(c00+c22)+m1*(c02+c20))/(m1+m2);

	output.c = 1.0;
	output.c.xyz = 0.25*(u+d+r+l);
	
	return output;
}
#else
	c00 = tex2D(dx_TextureSampler, Input.t1.xy-dy*SMOOTH_LEVEL).xyz; 
	c20 = tex2D(dx_TextureSampler, Input.t2.xy-dy*SMOOTH_LEVEL).xyz; 
	c02 = tex2D(dx_TextureSampler, Input.t4.xy-dy*SMOOTH_LEVEL).xyz; 
	c22 = tex2D(dx_TextureSampler, Input.t3.xy-dy*SMOOTH_LEVEL).xyz; 

	m1 = dot(abs(c00-c22),dt)+0.001;
	m2 = dot(abs(c02-c20),dt)+0.001;

	u = .5*(m2*(c00+c22)+m1*(c02+c20))/(m1+m2);

	c00 = tex2D(dx_TextureSampler, Input.t1.xy+dy*SMOOTH_LEVEL).xyz; 
	c20 = tex2D(dx_TextureSampler, Input.t2.xy+dy*SMOOTH_LEVEL).xyz; 
	c02 = tex2D(dx_TextureSampler, Input.t4.xy+dy*SMOOTH_LEVEL).xyz; 
	c22 = tex2D(dx_TextureSampler, Input.t3.xy+dy*SMOOTH_LEVEL).xyz; 
	
	m1 = dot(abs(c00-c22),dt)+0.001;
	m2 = dot(abs(c02-c20),dt)+0.001;

	d = .5*(m2*(c00+c22)+m1*(c02+c20))/(m1+m2);

	c00 = tex2D(dx_TextureSampler, Input.t1.xy-dx*SMOOTH_LEVEL).xyz; 
	c20 = tex2D(dx_TextureSampler, Input.t2.xy-dx*SMOOTH_LEVEL).xyz; 
	c02 = tex2D(dx_TextureSampler, Input.t4.xy-dx*SMOOTH_LEVEL).xyz; 
	c22 = tex2D(dx_TextureSampler, Input.t3.xy-dx*SMOOTH_LEVEL).xyz; 

	m1 = dot(abs(c00-c22),dt)+0.001;
	m2 = dot(abs(c02-c20),dt)+0.001;

	l = .5*(m2*(c00+c22)+m1*(c02+c20))/(m1+m2);

	c00 = tex2D(dx_TextureSampler, Input.t1.xy+dx*SMOOTH_LEVEL).xyz; 
	c20 = tex2D(dx_TextureSampler, Input.t2.xy+dx*SMOOTH_LEVEL).xyz; 
	c02 = tex2D(dx_TextureSampler, Input.t4.xy+dx*SMOOTH_LEVEL).xyz; 
	c22 = tex2D(dx_TextureSampler, Input.t3.xy+dx*SMOOTH_LEVEL).xyz; 
	
	m1 = dot(abs(c00-c22),dt)+0.001;
	m2 = dot(abs(c02-c20),dt)+0.001;

	r = .5*(m2*(c00+c22)+m1*(c02+c20))/(m1+m2);

	output.c = 1.0;
	output.c.xyz = 0.25*(u+d+r+l);
	
	return output;
#endif
		
}

#if SHADER_MODEL == 0x500
	technique FXAAPass
{
    pass p0
    {
		PixelShader  = compile ps_5_0 ps_main();
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		CullMode=NONE;
		AlphaBlendEnable=TRUE;
		AlphaTestEnable=TRUE;
		SEPARATEALPHABLENDENABLE=TRUE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
    }

}
#endif
#if SHADER_MODEL == 0x400
	technique FXAAPass
{
    pass p0
    {
		PixelShader  = compile ps_4_0 ps_main();
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		CullMode=NONE;
		AlphaBlendEnable=TRUE;
		AlphaTestEnable=TRUE;
		SEPARATEALPHABLENDENABLE=TRUE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
    }

}
#endif
#if SHADER_MODEL == 0x300 
	technique FXAAPass
{
    pass p0
    {
		PixelShader  = compile ps_3_0 ps_main();
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		CullMode=NONE;
		AlphaBlendEnable=TRUE;
		AlphaTestEnable=TRUE;
		SEPARATEALPHABLENDENABLE=TRUE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
    }

}
#endif
#if SHADER_MODEL == 0x200 
	technique FXAAPass
{
    pass p0
    {
		PixelShader  = compile ps_2_0 ps_main();
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		CullMode=NONE;
		AlphaBlendEnable=TRUE;
		AlphaTestEnable=TRUE;
		SEPARATEALPHABLENDENABLE=TRUE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
    }

}
#endif
#endif