// Process only LUMA (1) to avoid increasing saturation, or all colors (0)
#define LUMA_ONLY 0
// Control of the gamma-ish curve, 1.0 is neutral.
#define GAMMA_CURVE 1.4

#ifndef SHADER_MODEL
#define GLSL 1
#else
#define GLSL 0
#endif

#if GLSL
#define float2 vec2
#define float3 vec3
#define float4 vec4
#define sample(x) texture(TextureSampler, x)
in SHADER
{
    vec4 p;
    vec2 t;
    vec4 c;
} PSin;

layout(location = 0) out vec4 SV_Target0;
#else
#define sample(x) Texture.Sample(TextureSampler, x)
Texture2D Texture : register(t0);
SamplerState TextureSampler : register(s0);
struct VS_OUTPUT
{
    float4 p : SV_Position;
    float2 t : TEXCOORD0;
};
struct PS_OUTPUT
{
    float4 c : SV_Target0;
};
#endif

#if LUMA_ONLY
#define KR 0.2126
#define KG 0.0722
#define KB 0.7152

float3 rgb_to_ycbcr(float3 rgb)
{
	float3 ycbcr;
	ycbcr.r = KR*rgb.r + KG*rgb.g + KB*rgb.b;
	ycbcr.g = -0.5*KR/(1-KB)*rgb.r -0.5*KG/(1-KB)*rgb.g + 0.5*rgb.b;
	ycbcr.b = 0.5*rgb.r -0.5*KG/(1-KR)*rgb.g -0.5*KB/(1-KR)*rgb.b;
	return ycbcr;
}

float3 ycbcr_to_rgb(float3 ycbcr)
{
	float3 rgb;
	rgb.r = ycbcr.r + (2-2*KR)*ycbcr.b;
	rgb.g = ycbcr.r -KB/KG*(2-2*KB)*ycbcr.g -KR/KG*(2-2*KR)*ycbcr.b;
	rgb.b = ycbcr.r + (2-2*KB)*ycbcr.g;
	return rgb;
}
#endif

float func(float x, float a)
{
	return pow(2.0*x, a) * 0.5;
}

float curve(float x, float a)
{
	return x < 0.5 ? func(x,a*a) : 1 - func(1-x,a);
}

#if GLSL
void ps_main()
#else
float4 ps_main(VS_OUTPUT PSin) : SV_Target0
#endif
{
    float4 col = sample(PSin.t);

#if LUMA_ONLY
	col.rgb = rgb_to_ycbcr(col.rgb);
	col.r = func(col.r, GAMMA_CURVE);
	col.rgb = ycbcr_to_rgb(col.rgb);
#else
	col.r = func(col.r, GAMMA_CURVE);
    col.g = func(col.g, GAMMA_CURVE);
    col.b = func(col.b, GAMMA_CURVE);
#endif

#if GLSL
	SV_Target0 = col;
#else
    return col;
#endif
}
