// Process only LUMA (1) to avoid increasing saturation, or all colors (0)
#define LUMA_ONLY 0
// Strength of the effect, from 0 to 1
#define FX_STRENGTH 1.0

#ifndef SHADER_MODEL
#define GLSL 1
#else
#define GLSL 0
#endif

#if GLSL
#define float2 vec2
#define float3 vec3
#define float4 vec4
#define sample(x) texture(TextureSampler, x)
#define lerp(a,b,c) mix(a,b,c)
in SHADER
{
    vec4 p;
    vec2 t;
    vec4 c;
} PSin;

layout(location = 0) out vec4 SV_Target0;
#else
#define sample(x) Texture.Sample(TextureSampler, x)
Texture2D Texture : register(t0);
SamplerState TextureSampler : register(s0);
struct VS_OUTPUT
{
    float4 p : SV_Position;
    float2 t : TEXCOORD0;
};
struct PS_OUTPUT
{
    float4 c : SV_Target0;
};
#endif

#if LUMA_ONLY
#define KR 0.2126
#define KG 0.0722
#define KB 0.7152

float3 rgb_to_ycbcr(float3 rgb)
{
	float3 ycbcr;
	ycbcr.r = KR*rgb.r + KG*rgb.g + KB*rgb.b;
	ycbcr.g = -0.5*KR/(1-KB)*rgb.r -0.5*KG/(1-KB)*rgb.g + 0.5*rgb.b;
	ycbcr.b = 0.5*rgb.r -0.5*KG/(1-KR)*rgb.g -0.5*KB/(1-KR)*rgb.b;
	return ycbcr;
}

float3 ycbcr_to_rgb(float3 ycbcr)
{
	float3 rgb;
	rgb.r = ycbcr.r + (2-2*KR)*ycbcr.b;
	rgb.g = ycbcr.r -KB/KG*(2-2*KB)*ycbcr.g -KR/KG*(2-2*KR)*ycbcr.b;
	rgb.b = ycbcr.r + (2-2*KB)*ycbcr.g;
	return rgb;
}
#endif

float weird_curve(float x)
{
	return -0.11691*x*x*x*x -1.647374*x*x*x +2.675654*x*x + 0.08863033*x;
}

#if GLSL
void ps_main()
#else
float4 ps_main(VS_OUTPUT PSin) : SV_Target0
#endif
{
    float4 col = sample(PSin.t);
	float4 original = col;

#if LUMA_ONLY
	col.rgb = rgb_to_ycbcr(col.rgb);
	col.r = weird_curve(col.r);
	col.rgb = ycbcr_to_rgb(col.rgb);
#else
	col.r = weird_curve(col.r);
    col.g = weird_curve(col.g);
    col.b = weird_curve(col.b);
#endif

	col = lerp(original, col, FX_STRENGTH);

#if GLSL
	SV_Target0 = col;
#else

    return col;
#endif
}
