/*
   The GLSoft_smart_filter_very-high-res GLSL shader

   shader levels: 1 - normal
                  2 - bloom
                  3 - natural
                  4 - natural + bloom
*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

Texture2D Texture;
SamplerState TextureSampler;
static const float levels = 4.0;
static const float res_mult = 3.0;
static const float res_x = 512.0;
static const float res_y = 448.0;

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};

float bloom   = 0.50;
float natural = 1.15;

static const float3x3 matx1 = {0.299, 0.587, 0.114, 0.596,  -0.275, -0.321, 0.212, -0.523,  0.311};

static const float3x3 matx2 = {1.0, 0.95568806036115671171, 0.61985809445637075388, 1.0, -0.27158179694405859326,-0.64687381613840131330, 1.0,-1.1081773266826619523, 1.7050645599191817149};
						   


PS_OUTPUT ps_main(PS_INPUT input)
{
	PS_OUTPUT output;
	float2 pos = input.t;	
	float levell = levels - 1.0;

float x = 1.0/(res_x*res_mult);
float y = 1.0/(res_y*res_mult);
float2 dg1 = float2( x,y);  float2 dg2 = float2(-x,y);
float2 sd1 = dg1*0.5;     float2 sd2 = dg2*0.5;
float2 ddx = float2(x,0.0); float2 ddy = float2(0.0,y);

	float3 c11 = Texture.Sample(TextureSampler, pos.xy).xyz;
	float3 s00 = Texture.Sample(TextureSampler, pos.xy - sd1).xyz; 
	float3 s20 = Texture.Sample(TextureSampler, pos.xy - sd2).xyz; 
	float3 s22 = Texture.Sample(TextureSampler, pos.xy + sd1).xyz; 
	float3 s02 = Texture.Sample(TextureSampler, pos.xy + sd2).xyz; 
	float3 c00 = Texture.Sample(TextureSampler, pos.xy - dg1).xyz; 
	float3 c22 = Texture.Sample(TextureSampler, pos.xy + dg1).xyz; 
	float3 c20 = Texture.Sample(TextureSampler, pos.xy - dg2).xyz;
	float3 c02 = Texture.Sample(TextureSampler, pos.xy + dg2).xyz;
	float3 c10 = Texture.Sample(TextureSampler, pos.xy - ddy).xyz; 
	float3 c21 = Texture.Sample(TextureSampler, pos.xy + ddx).xyz; 
	float3 c12 = Texture.Sample(TextureSampler, pos.xy + ddy).xyz; 
	float3 c01 = Texture.Sample(TextureSampler, pos.xy - ddx).xyz;     
	float3 dt = float3(1.0,1.0,1.0);

	float d1=dot(abs(c00-c22),dt)+0.001;
	float d2=dot(abs(c20-c02),dt)+0.001;
	float hl=dot(abs(c01-c21),dt)+0.001;
	float vl=dot(abs(c10-c12),dt)+0.001;
	float m1=dot(abs(s00-s22),dt)+0.001;
	float m2=dot(abs(s02-s20),dt)+0.001;

	float3 mn1 = min(min(c00,c01),c02);
	float3 mn2 = min(min(c10,c11),c12);
	float3 mn3 = min(min(c20,c21),c22);
	float3 mx1 = max(max(c00,c01),c02);
	float3 mx2 = max(max(c10,c11),c12);
	float3 mx3 = max(max(c20,c21),c22);

	mn1 = min(min(mn1,mn2),mn3);
	mx1 = max(max(mx1,mx2),mx3);	

	float3 t1=(hl*(c10+c12)+vl*(c01+c21)+(hl+vl)*c11)/(3.0*(hl+vl));
	float3 t2=(d1*(c20+c02)+d2*(c00+c22)+(d1+d2)*c11)/(3.0*(d1+d2));
	
	c11 =.25*(t1+t2+(m2*(s00+s22)+m1*(s02+s20))/(m1+m2));
	
	float3 dif = mx1-mn1;	
	float filterparam = clamp(3.0*max(dif.x,max(dif.y,dif.z)),1.0,1.6);

	float3 dif1 = abs(c11-mn1) + 0.001*dt;
	float3 dif2 = abs(c11-mx1) + 0.001*dt;

	dif1=float3(pow(dif1.x,filterparam),pow(dif1.y,filterparam),pow(dif1.z,filterparam));
	dif2=float3(pow(dif2.x,filterparam),pow(dif2.y,filterparam),pow(dif2.z,filterparam));

	c11.r = (dif1.x*mx1.x + dif2.x*mn1.x)/(dif1.x + dif2.x);
	c11.g = (dif1.y*mx1.y + dif2.y*mn1.y)/(dif1.y + dif2.y);
	c11.b = (dif1.z*mx1.z + dif2.z*mn1.z)/(dif1.z + dif2.z);

float bloom2   = 0.50;
float natural2 = 1.15;


	if  (levell < 2.0) natural2 = 1.0;
    c11 = float3((matx1._11*c11.x+matx1._12*c11.y+matx1._13*c11.z), (matx1._21*c11.x+matx1._22*c11.y+matx1._23*c11.z), (matx1._31*c11.x+matx1._32*c11.y+matx1._33*c11.z));
	c11 = float3(pow(c11.x,natural2),c11.yz*natural2);
	c11 = float3((matx2._11*c11.x+matx2._12*c11.y+matx2._13*c11.z), (matx2._21*c11.x+matx2._22*c11.y+matx2._23*c11.z), (matx2._31*c11.x+matx2._32*c11.y+matx2._33*c11.z));
	float k1 = length(c11); bloom2 = (levell%2)*bloom2;
	output.c.a = 1.0;
	output.c.xyz = (1.0-bloom2)*c11 + bloom2*lerp(k1,normalize(float2(k1*k1,0.82)).x*1.74,0.577*k1)*normalize(c11);

	return output;

}

#endif



