/* COMPATIBILITY
   - Cg   compilers
*/

/*
   Reverse Antialiasing Shader
   http://kdepepo.wordpress.com/2012/08/15/reverse-antialiasing-for-image-scaling/
  
   Adapted from the C source (see Copyright below) to shader
   cg language by Hyllian/Jararaca - sergiogdb@gmail.com

   This shader works best using 2x scale. 

*/

/*
	Destroyed by KrossX for PCSX2...
*/

/*  source: http://imagezero.maxiom.de/files/ppmdouble.c
 *
 *  Copyright (c) 2012, Christoph Feck <christoph@maxiom.de>
 *  All Rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *    * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

Texture2D Texture;
SamplerState Sampler;

#define TEX_SIZE_X (512)
#define TEX_SIZE_Y (448)

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0_centroid;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};

float4 ps_main(PS_INPUT input) : SV_Target0
{
	const float3 off1 = float3(1.0 / TEX_SIZE_X, 1.0 / TEX_SIZE_Y, 0.0);
	const float3 off2 = float3(2.0 / TEX_SIZE_X, 2.0 / TEX_SIZE_Y, 0.0);	
	const float2 pos = input.t;
	const float2 fp = frac(pos* float2(TEX_SIZE_X, TEX_SIZE_Y));
		
	float3 B1 = Texture.Sample(Sampler, pos - off2.zy).xyz;
	float3 B  = Texture.Sample(Sampler, pos - off1.zy).xyz;
	float3 D  = Texture.Sample(Sampler, pos - off1.xz).xyz;
	float3 E  = Texture.Sample(Sampler, pos          ).xyz;
	float3 F  = Texture.Sample(Sampler, pos + off1.xy).xyz;
	float3 H  = Texture.Sample(Sampler, pos + off1.zy).xyz;
	float3 H5 = Texture.Sample(Sampler, pos + off2.zy).xyz;
	float3 D0 = Texture.Sample(Sampler, pos - off2.xz).xyz;
	float3 F4 = Texture.Sample(Sampler, pos + off2.xz).xyz;	
	
	float3 n1 = B1, n2 = B, n3 = H, n4 = H5, s = E;
	float3 aa = n2 - n1, bb = s - n2, cc = n3 - s, dd = n4 - n3;
	
	float3 t = (7 * (bb + cc) - 3 * (aa + dd)) / 16;
    float3 m = (s < 0.5) ? 2*s : 2*(1.0-s);
	
	m = min(m, 2*abs(bb));
    m = min(m, 2*abs(cc));

    t = clamp(t, -m, m);
   
    const float3 s1 = s + t/2;
    const float3 s0 = s1 - t;
	
	n1 = D0; n2 = D; n3 = F; n4 = F4;
	aa = n2-n1; dd = n4-n3;
	
	if(fp.y < 0.5)
	{
		s = s0; 
		bb = s-n2; cc = n3-s;

		t = (7 * (bb + cc) - 3 * (aa + dd)) / 16;

		m = (s < 0.5) ? 2*s : 2*(1.0-s);

		m = min(m, 2*abs(bb));
		m = min(m, 2*abs(cc));

		t = clamp(t, -m, m);		
	}
	else
	{
		s = s1;
		bb = s-n2; cc = n3-s;

		t = (7 * (bb + cc) - 3 * (aa + dd)) / 16;

		m = (s < 0.5) ? 2*s : 2*(1.0-s);

		m = min(m, 2*abs(bb));
		m = min(m, 2*abs(cc));

		t = clamp(t, -m, m);
	}
	
	return float4(fp.x < 0.50 ? s - t/2  : s + t/2, 1.0);
}

#endif
