/*
Bilinear / Scanlines by KrossX
***********************************

v1.0 
*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency


#if SHADER_MODEL >= 0x400

Texture2D Texture;
SamplerState TextureSampler;

cbuffer cb0
{
	float4 _rcpFrame;		// (1/x, 1/y, 0, 0) for FXAA
	float4 _rcpFrameOpt;	// (0,0,0,0) for FXAA (not used for PC preset)
};

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};

#define TexSample(t,p) t.Sample(TextureSampler, p)

#else

struct PS_INPUT
{
#if SHADER_MODEL < 0x300
	float4 p : TEXCOORD1;
#else
	float4 p : VPOS;
#endif
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : COLOR;
};

sampler Texture : register(s0);

float4 _rcpFrame : register(c0);
float4 _rcpFrameOpt : register(c1);

#define TexSample(t,p) tex2D(t, p)

#endif

#define BILINEAR_ENABLED 1	// Enables/Disables Bilinear filtering
#define SCAN_ENABLED 1		// Enables/Disables Scanlines
#define SCAN_SIZE 0.5 		// Line size, depends on resolution. Try values between 0.0 and 1.0.
#define SCAN_OPACITY 0.5 	// Multiplier, with 0.5 being 50% darker.

PS_OUTPUT ps_main(PS_INPUT input)
{
	PS_OUTPUT output;

	float2 pos = input.t;	
	float4 color = TexSample(Texture, pos);

#if BILINEAR_ENABLED
	float4 color_ox = TexSample(Texture, pos + _rcpFrame.xz);
	float4 color_oy = TexSample(Texture, pos + _rcpFrame.zy);
	float4 color_xy = TexSample(Texture, pos + _rcpFrame.xy);
	
	float2 dxy = frac(pos * float2(1.0, 0.5) / _rcpFrame.xy);
	float4 color_h1 = lerp(color, color_ox, dxy.x);
	float4 color_h2 = lerp(color_oy, color_xy, dxy.x);
	
	color = lerp(color_h1, color_h2, dxy.y);
#endif
	
#if SCAN_ENABLED
	float height = (SCAN_SIZE / _rcpFrame.y);
	float dy = frac(pos.y * height);
	
	if(dy > 0.5) color *= SCAN_OPACITY;
#endif
	
	output.c = color;
	
	return output;
}

#endif
