/*
Bloom
*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

Texture2D Texture;
SamplerState TextureSampler;

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};


PS_OUTPUT ps_main(PS_INPUT input)
{
	PS_OUTPUT output;
	float2 pos = input.t;	

	float3 c11 = Texture.Sample(TextureSampler, pos.xy).xyz;

	float bloom   = 0.50;
	
	float k1 = length(c11); 
	output.c.a = 1.0;
	output.c.xyz = (1.0-bloom)*c11 + bloom*lerp(k1,normalize(float2(k1*k1,0.82)).x*1.74,0.577*k1)*normalize(c11);

	return output;

}

#endif



