/*
   AA shader v2.o - Daisy
   
   Copyright (C) 2006 guest(r) - guest.r@gmail.com

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   
   ** 2013/04/07 - Update
   ** 2012/02/14 - HLSL port for PCSX2 by KrossX    
*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency


#if SHADER_MODEL >= 0x400

Texture2D Texture;
SamplerState TextureSampler;

cbuffer cb0
{
	float4 _rcpFrame;		// (1/x, 1/y, 0, 0) for FXAA
	float4 _rcpFrameOpt;	// (0,0,0,0) for FXAA (not used for PC preset)
//	float4 GSDXsize;		// (x,y,1/x,1/y)
};

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};

#define TexSample(t,p) t.Sample(TextureSampler, p)

#else

struct PS_INPUT
{
#if SHADER_MODEL < 0x300
	float4 p : TEXCOORD1;
#else
	float4 p : VPOS;
#endif
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : COLOR;
};

sampler Texture : register(s0);

float4 _rcpFrame : register(c0);
float4 _rcpFrameOpt : register(c1);
//float4 GSDXsize : register(c2);

#define TexSample(t,p) tex2D(t, p)

#endif

float hd(float x)
{ 
  float y = x*1.1547-1.0;
  y = (sin(y*1.5707)+1.1)*0.83;
  return (x+y+y)/3.0;
}

#define OFFSET 1.0 // Higher number for stronger effect (eg, 2.0)

PS_OUTPUT ps_main(PS_INPUT input)
{
	PS_OUTPUT output;
	float2 pos = input.t;	
	
	const float2 dx = float2(_rcpFrame.x, 0.0) * OFFSET;
	const float2 dy = float2(0.0, _rcpFrame.y) * OFFSET;
	float2 dg1 = dx + dy;
	float2 dg2 = dy - dx;
	
	float4 colorU = TexSample(Texture, pos + dy);
		
	float3 c00 = TexSample(Texture, pos - dg1).xyz; 
	float3 c10 = TexSample(Texture, pos - dy).xyz; 
	float3 c20 = TexSample(Texture, pos + dg2).xyz; 
	float3 c01 = TexSample(Texture, pos - dx).xyz; 
	float3 c11 = TexSample(Texture, pos).xyz; 
	float3 c21 = TexSample(Texture, pos + dx).xyz; 
	float3 c02 = TexSample(Texture, pos - dg2).xyz; 
	float3 c12 = TexSample(Texture, pos + dy).xyz; 
	float3 c22 = TexSample(Texture, pos + dg1).xyz; 
	float3 dt = float3(1.0,1.0,1.0); 			

	float d1=dot(abs(c00-c22),dt)+0.0001;
	float d2=dot(abs(c20-c02),dt)+0.0001;
	float hl=dot(abs(c01-c21),dt)+0.0001;
	float vl=dot(abs(c10-c12),dt)+0.0001;	
	
	float md = d1+d2;   float mc = hl+vl;
	hl*=  md;vl*= md;   d1*=  mc;d2*= mc;
	
    float ww = d1+d2+hl+vl;
        
	c11 = (hl*(c10+c12)+vl*(c01+c21)+d1*(c20+c02)+d2*(c00+c22)+ww*c11)/(3.0*ww);		
	
	output.c.a = 1.0;
	output.c.xyz = c11; //hd(length(c11))*normalize(c11);
	return output;
}

#endif
