/*======HDR and Bloom Multi Shader, by Asmodean.
========This shader will run of shader model 5 if you have a DX11 gpu, else SM3 
========Comment out #define HDR on line: 7, to disable HDR, and enable Bloom
========Extra tweakables on line: 205*/

#ifdef SHADER_MODEL

float4	BloomParameters;
float4	TempParameters;
float	ScreenSize = 4096.0;
float BloomRadius3 = 64;
float BloomRadius4 = 128;
float4 BloomContrast = 1.5;
float MixFactor = 0.3;
float Smoothness = 8;

float3 violetpremierepasse = float3(1.0, 1.0, 1.0);
float3 violetsoleil = float3(0.75, 0.75, 0.68);
float3 couleurglobale = float3(1.0, 1.0, 1.0);

texture2D texColor;
SamplerState SamplerColor
{
    Texture   = <texColor>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

texture2D texBloom1;
SamplerState SamplerBloom1
{
    Texture   = <texBloom1>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

texture2D texBloom2;
SamplerState SamplerBloom2
{
    Texture   = <texBloom2>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

texture2D texBloom3;
SamplerState SamplerBloom3
{
    Texture   = <texBloom3>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

texture2D texBloom4;
SamplerState SamplerBloom4
{
    Texture   = <texBloom4>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

texture2D texBloom5;
SamplerState SamplerBloom5
{
    Texture   = <texBloom5>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

texture2D texBloom6;
SamplerState SamplerBloom6
{
    Texture   = <texBloom6>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

texture2D texBloom7;
SamplerState SamplerBloom7
{
    Texture   = <texBloom7>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

texture2D texBloom8;
SamplerState SamplerBloom8
{
    Texture   = <texBloom8>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = NONE;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

struct VS_OUTPUT
{
    float4 vpos : SV_POSITION;
	float2 tex : TEXCOORD0;
	
};
struct VS_INPUT
{
    float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader - HDR shading
//--------------------------------------------------------------------------------------
VS_OUTPUT VS_HDR(VS_INPUT IN)
{
   	VS_OUTPUT OUT;
	float4 pos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0); 

	OUT.vpos=pos; 
	OUT.tex.xy=IN.tex.xy; 

	return OUT;

}

//--------------------------------------------------------------------------------------
// Pixel Shader - HDR shading
//--------------------------------------------------------------------------------------
float4 ps_main(VS_OUTPUT In) : SV_Target
{
	float tempF1;
	float4 bloomuv;
	float4 bloomuv2;
	float4 overbright;
	float bthreshold = 60.0;
	
//=======These Temp variables Control HDR settings******************* 
	float tempF7=1.0; //hue sat
	float tempF8=1.95; //lum darkness
	float tempF9=5.0; //Ambient brightness
	float tempF0=0.15; //Ambient darkness and saturation

	float4 bloom = texBloom1.Sample(SamplerBloom1, In.tex); 
	float4 uvsrc=0; 
	uvsrc.xy=In.tex; 
	
	
	const float2 offset[16]=
 {
	 float2(-0.94201624, -0.39906216),
	 float2( 0.94558609, -0.76890725),
	 float2(-0.09418410, -0.92938870),
	 float2( 0.34495938,  0.29387760),
	 float2(-0.91588581,  0.45771432),
	 float2(-0.81544232, -0.87912464),
	 float2(-0.38277543,  0.27676845),
	 float2( 0.97484398,  0.75648379),
	 float2( 0.44323325, -0.97511554),
	 float2( 0.53742981, -0.47373420),
	 float2(-0.26496911, -0.41893023),
	 float2( 0.79197514,  0.19090188),
	 float2(-0.24188840,  0.99706507),
	 float2(-0.81409955,  0.91437590),
	 float2( 0.19984126,  0.78641367),
	 float2( 0.14383161, -0.14100790)
 }; 
	float4 coord=1.0; 
	coord.xy=In.tex.xy; 
	
	float4 origcolor=texColor.Sample(SamplerColor, coord.xy); 
	float origgray=max(origcolor.r, max(origcolor.g, origcolor.b)); 
	bloom+=origcolor; 
	float range=0.7*tempF1/ScreenSize; 
	
	float2 screenfact=1.0;
	screenfact.xy*=TempParameters.z*Smoothness;
	float4 srcbloom=bloom;
	float step=(TempParameters.w-0.5);//*1.5;
	screenfact.xy*=step;

	float4 color=bloom; //tex2Dbias(SamplerColor, uvsrc); 

	float tf7=tempF7; 
	float tf8=tempF8*0.55; 

	float4 rotvec=0.0;
	sincos(0.3927, rotvec.x, rotvec.y);
	
	for (int i=0; i<16; i++)
	{
		bloomuv.xy=offset[i];
		bloomuv.xy=reflect(bloomuv.xy, rotvec.xy);
		bloomuv.xy*=BloomParameters.y;
		bloomuv.xy=(bloomuv.xy*screenfact.xy)+In.tex.xy;//-(1.0/256.0);//-(1.0/512.0);

		float4 tempbloom1 = texBloom1.Sample(SamplerBloom1, bloomuv.xy);

		bloomuv2.xy=offset[i];
		bloomuv2.xy=reflect(bloomuv2.xy, rotvec.xy);
		bloomuv2.xy*=BloomRadius4;
		bloomuv2.xy=(bloomuv2.xy*screenfact.xy)+In.tex.xy;//-(1.0/256.0);//-(1.0/512.0);
		float4 tempbloom2 = texBloom1.Sample(SamplerBloom1, bloomuv2.xy);
		float4 tempbloom = lerp(tempbloom1, tempbloom2, MixFactor);
		
		overbright = texBloom1.Sample(SamplerBloom1, bloomuv.xy);
		overbright.w = dot(overbright.xyz, 0.3333);
		overbright.w = saturate(overbright.w - bthreshold);
		if(overbright.w)	bloom.xyz += overbright.xyz;
		else
		{
			bloomuv.xy=offset[i];
			bloomuv.xy=(bloomuv.xy*screenfact.xy)+In.tex.xy;//-(1.0/256.0);//-(1.0/512.0);
			bloom+=texBloom1.Sample(SamplerBloom1, bloomuv.xy);
		}
		bloom+=tempbloom;
	}
	
	float3 violet=violetpremierepasse;
	float ttt=dot(bloom.xyz, 0.333)-dot(srcbloom.xyz, 0.333);
	ttt=max(ttt, 0.0);
	float gray=BloomParameters.z*ttt;//max(srcbloom.x, max(srcbloom.y, srcbloom.z));
	float mixfact=(gray/(1.0+gray));
	mixfact*=1.0-saturate((TempParameters.w-1.0)*0.5);
	violet.xy+=saturate((TempParameters.w-1.0)*0.3);
	violet.xy=saturate(violet.xy);
	bloom.xyz*=lerp(1.0, violet.xyz, mixfact);
	
	
	float4 temp;
	
	bloom+=texBloom2.Sample(SamplerBloom2, In.tex);
	bloom+=texBloom3.Sample(SamplerBloom3, In.tex);
	bloom+=texBloom4.Sample(SamplerBloom4, In.tex);
	bloom+=texBloom5.Sample(SamplerBloom5, In.tex);
	bloom+=texBloom6.Sample(SamplerBloom6, In.tex);
	bloom+=texBloom7.Sample(SamplerBloom7, In.tex);
	bloom+=texBloom8.Sample(SamplerBloom8, In.tex);
	bloom*=0.2;
	temp = bloom;
	
	float4 bloom1=texBloom2.Sample(SamplerBloom2, In.tex);
	float4 bloom2=texBloom3.Sample(SamplerBloom3, In.tex);
	float4 bloom3=texBloom4.Sample(SamplerBloom4, In.tex);
	float4 bloom4=texBloom5.Sample(SamplerBloom5, In.tex);
	float4 bloom5=texBloom6.Sample(SamplerBloom6, In.tex);
	float4 bloom6=texBloom7.Sample(SamplerBloom7, In.tex);
	float4 bloom7=texBloom8.Sample(SamplerBloom8, In.tex);
	bloom=max(bloom1, bloom2);
	bloom=max(bloom, bloom3);
	bloom=max(bloom, bloom4);
	bloom=max(bloom, bloom5);
	bloom=max(bloom, bloom6);
	bloom=max(bloom, bloom7);
	
#ifdef HDR
{	
	float3 correctedcolor=((1.0-color*tempF9*0.24)*tempF0*0.16); 
	bloom.rgb=color.rgb-correctedcolor; 
	bloom.rgb=pow(bloom.rgb,tf8)*tf7; 
//========bloom below controls Contrast
	bloom*=1.1;
}
#else
	bloom*=1.2;
#endif
	return bloom;
}



//--------------------------------------------------------------------------------------

#if SHADER_MODEL >= 0x500
	technique BloomPrePass
{
    pass p0
    {
		VertexShader = compile vs_5_0 VS_HDR();
		PixelShader  = compile ps_5_0 ps_main();
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		CullMode=NONE;
		AlphaBlendEnable=TRUE;
		AlphaTestEnable=TRUE;
		SEPARATEALPHABLENDENABLE=TRUE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
    }

}
#else 
	technique BloomPrePass
{
    pass p0
    {
		VertexShader = compile vs_3_0 VS_HDR();
		PixelShader  = compile ps_3_0 ps_main();
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		CullMode=NONE;
		AlphaBlendEnable=TRUE;
		AlphaTestEnable=TRUE;
		SEPARATEALPHABLENDENABLE=TRUE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
    }

}
#endif
#endif
