/*
  Bump mapping shader with AA coded by guest.r
*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

Texture2D Texture;
SamplerState TextureSampler;

static const float glow  = 1.25;  // max brightness on borders
static const float shde  = 0.75;  // max darkening
static const float bump  = 1.33;  // effect strenght - lower values bring more effect
static const float range = 1.00;  // effect width


struct PS_INPUT
{
    float4 p : SV_Position;
    float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
    float4 c : SV_Target0;
};



float3 TextureSample (float2 texcoord){
    float x = 1.0/1024;
    float y = 1.0/1024;
    float4 yx = float4(x,y,-x,-y)*0.5;

    float3 c11 = Texture.Sample(TextureSampler, texcoord).xyz;
    float3 s00 = Texture.Sample(TextureSampler, texcoord + yx.zw).xyz;
    float3 s20 = Texture.Sample(TextureSampler, texcoord + yx.xw).xyz;
    float3 s22 = Texture.Sample(TextureSampler, texcoord + yx.xy).xyz;
    float3 s02 = Texture.Sample(TextureSampler, texcoord + yx.zy).xyz;
    float3 c00 = Texture.Sample(TextureSampler, texcoord + float2( -x, -y)).xyz;
    float3 c22 = Texture.Sample(TextureSampler, texcoord + float2(  x,  y)).xyz;
    float3 c20 = Texture.Sample(TextureSampler, texcoord + float2(  x, -y)).xyz;
    float3 c02 = Texture.Sample(TextureSampler, texcoord + float2( -x,  y)).xyz;
    float3 c10 = Texture.Sample(TextureSampler, texcoord + float2(0.0, -y)).xyz;
    float3 c21 = Texture.Sample(TextureSampler, texcoord + float2(  x,0.0)).xyz;
    float3 c12 = Texture.Sample(TextureSampler, texcoord + float2(0.0,  y)).xyz;
    float3 c01 = Texture.Sample(TextureSampler, texcoord + float2( -x,0.0)).xyz;   
    float3 dt = float3(1.0,1.0,1.0);

    float d1=dot(abs(c00-c22),dt)+0.001;
    float d2=dot(abs(c20-c02),dt)+0.001;
    float hl=dot(abs(c01-c21),dt)+0.001;
    float vl=dot(abs(c10-c12),dt)+0.001;
    float m1=dot(abs(s00-s22),dt)+0.001;
    float m2=dot(abs(s02-s20),dt)+0.001;

    float3 t1=(hl*(c10+c12)+vl*(c01+c21)+(hl+vl)*c11)/(3.0*(hl+vl));
    float3 t2=(d1*(c20+c02)+d2*(c00+c22)+(d1+d2)*c11)/(3.0*(d1+d2));
   
    c11 =.25*(t1+t2+(m2*(s00+s22)+m1*(s02+s20))/(m1+m2));

    return c11;
}


PS_OUTPUT ps_main(PS_INPUT input)
{
    PS_OUTPUT output;
    float2 pos = input.t;   

    float x = range/2048.0;
    float y = range/2048.0;
    float2 dg1 = float2( x, y); float2 dg2 = float2(-x, y);
    float2 ddx = float2(x,0.0); float2 ddy = float2(0.0,y);

    float3 c11 = TextureSample(pos.xy).xyz;
    float3 c00 = TextureSample(pos.xy - dg1).xyz;
    float3 c22 = TextureSample(pos.xy + dg1).xyz;
//    float3 c20 = TextureSample(pos.xy - dg2).xyz;
//    float3 c02 = TextureSample(pos.xy + dg2).xyz;
    float3 c10 = TextureSample(pos.xy - ddy).xyz;
    float3 c21 = TextureSample(pos.xy + ddx).xyz;
    float3 c12 = TextureSample(pos.xy + ddy).xyz;
    float3 c01 = TextureSample(pos.xy - ddx).xyz;   
    float3 d11 = c11;

    c11 = (-c00+c22-c01+c21-c10+c12+bump*d11)/bump;
    c11 = min(c11,glow*d11);
    c11 = max(c11,shde*d11);

    output.c.a = 1.0;
    output.c.xyz = c11;

    return output;
}

#endif