/*
   NatAA shader ShadX
   
   Copyright (C) 2006 guest(r) - guest.r@gmail.com

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

#define OFFSET 0.001 // Messed with it until it looked fine (like Shader Level)

Texture2D Texture;
SamplerState TextureSampler;

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};


static const float3x3 matx1 = {0.299, 0.587, 0.114, 0.596,  -0.275, -0.321, 0.212, -0.523,  0.311};


static const float3x3 matx2 = {1.0, 0.95568806036115671171, 0.61985809445637075388, 1.0, -0.27158179694405859326,-0.64687381613840131330, 1.0,-1.1081773266826619523, 1.7050645599191817149};


static const float3 val00 = {1.2, 1.2, 1.2};


PS_OUTPUT ps_main(PS_INPUT input)
{
	PS_OUTPUT output;
	float2 pos = input.t;	
	
	float2 dx = float2(OFFSET, 0.0);
	float2 dy = float2(0.0, OFFSET);
	float2 dg1 = dx + dy;
	float2 dg2 = dy - dx;
	
	float4 colorU = Texture.Sample(TextureSampler, pos + dy);
		
	float3 c00 = Texture.Sample(TextureSampler, pos - dg1).xyz; 
	float3 c10 = Texture.Sample(TextureSampler, pos - dy).xyz; 
	float3 c20 = Texture.Sample(TextureSampler, pos + dg2).xyz; 
	float3 c01 = Texture.Sample(TextureSampler, pos - dx).xyz; 
	float3 c11 = Texture.Sample(TextureSampler, pos).xyz; 
	float3 c21 = Texture.Sample(TextureSampler, pos + dx).xyz; 
	float3 c02 = Texture.Sample(TextureSampler, pos - dg2).xyz; 
	float3 c12 = Texture.Sample(TextureSampler, pos + dy).xyz; 
	float3 c22 = Texture.Sample(TextureSampler, pos + dg1).xyz; 
	float3 dt = float3(1.0,1.0,1.0); 			

	float d1=dot(abs(c00-c22),dt)+0.0001;
	float d2=dot(abs(c20-c02),dt)+0.0001;
	float hl=dot(abs(c01-c21),dt)+0.0001;
	float vl=dot(abs(c10-c12),dt)+0.0001;	
	
	float md = d1+d2;   float mc = hl+vl;
	hl*=  md;vl*= md;   d1*=  mc;d2*= mc;
	
    float ww = d1+d2+hl+vl;
	
	float3 re1=((hl*(c10+c12)+vl*(c01+c21)+d1*(c20+c02)+d2*(c00+c22)+ww*c11)/(3.0*ww));    
	
    c00 = float3((matx1._11*re1.x+matx1._12*re1.y+matx1._13*re1.z), (matx1._21*re1.x+matx1._22*re1.y+matx1._23*re1.z), (matx1._31*re1.x+matx1._32*re1.y+matx1._33*re1.z));
    
    c00 = float3(pow(c00.x,val00.x),c00.y*val00.y, c00.z*val00.z);    
	c00 = float3((matx2._11*c00.x+matx2._12*c00.y+matx2._13*c00.z), (matx2._21*c00.x+matx2._22*c00.y+matx2._23*c00.z), (matx2._31*c00.x+matx2._32*c00.y+matx2._33*c00.z));
	
	output.c.a = 1.0;
	output.c.xyz = c00;
	return output;
}

#endif
