/*
Overlay Bloom by KrossX (HLSL port)
***********************************

It applies a sort of common Photoshop effect of duplicating the background
layer, blurring it and setting it on top with the overlay blending mode.

The shader level controls the strength of the effect. And, there are some 
more options near the top of the fragment file.

v1.2 - Ported to HLSL with a more expensive blur.

v1.1 - Removed a leftover and another f that was still there.

v1.0 - Reworked the shader a bit, added some option macros, removed all the f's
	   and also added this description.
*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

Texture2D Texture;
SamplerState TextureSampler;

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};

PS_OUTPUT ps_main(PS_INPUT input)
{
	PS_OUTPUT output;

	float2 pos = input.t;
	
	float4 color = Texture.Sample(TextureSampler, pos);
	float4 blur = color * 0.22520613262190495;	

#define OFFSET 0.003

	float2 dx = float2(OFFSET, 0.0);
	float2 dy = float2(0.0, OFFSET);
	float2 dx2 = 2 * dx;
	float2 dy2 = 2 * dy;
	
	float4 colorU = Texture.Sample(TextureSampler, pos + dy);
	blur += 0.002589001911021066 * Texture.Sample(TextureSampler, pos -dx2 +dy2); 
	blur += 0.010778807494659370 * Texture.Sample(TextureSampler, pos -dx +dy2); 
	blur += 0.024146616900339800 * Texture.Sample(TextureSampler, pos +dy2); 
	blur += 0.010778807494659370 * Texture.Sample(TextureSampler, pos +dx +dy2); 
	blur += 0.002589001911021066 * Texture.Sample(TextureSampler, pos +dx2 +dy2); 

	blur += 0.010778807494659370 * Texture.Sample(TextureSampler, pos -dx2 +dy);
	blur += 0.044875475183061630 * Texture.Sample(TextureSampler, pos -dx +dy);
	blur += 0.100529757860782610 * Texture.Sample(TextureSampler, pos +dy);
	blur += 0.044875475183061630 * Texture.Sample(TextureSampler, pos +dx +dy);
	blur += 0.010778807494659370 * Texture.Sample(TextureSampler, pos +dx2 +dy);

	blur += 0.024146616900339800 * Texture.Sample(TextureSampler, pos -dx2);
	blur += 0.100529757860782610 * Texture.Sample(TextureSampler, pos -dx);	
	blur += 0.100529757860782610 * Texture.Sample(TextureSampler, pos +dx);
	blur += 0.024146616900339800 * Texture.Sample(TextureSampler, pos +dx2);

	blur += 0.010778807494659370 * Texture.Sample(TextureSampler, pos -dx2 -dy);
	blur += 0.044875475183061630 * Texture.Sample(TextureSampler, pos -dx -dy);
	blur += 0.100529757860782610 * Texture.Sample(TextureSampler, pos -dy);
	blur += 0.044875475183061630 * Texture.Sample(TextureSampler, pos +dx -dy);
	blur += 0.010778807494659370 * Texture.Sample(TextureSampler, pos +dx2 -dy);

	blur += 0.002589001911021066 * Texture.Sample(TextureSampler, pos -dx2 -dy2);
	blur += 0.010778807494659370 * Texture.Sample(TextureSampler, pos -dx -dy2);
	blur += 0.024146616900339800 * Texture.Sample(TextureSampler, pos -dy2);
	blur += 0.010778807494659370 * Texture.Sample(TextureSampler, pos +dx -dy2);
	blur += 0.002589001911021066 * Texture.Sample(TextureSampler, pos +dx2 -dy2);				
	
	output.c = lerp(color, blur, 0.5);
	return output;
}

#endif
