#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

Texture2D Texture;
SamplerState TextureSampler;

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};


PS_OUTPUT ps_main(PS_INPUT input)
{
	PS_OUTPUT output;

	float2 pos = input.t;
	
	float4 color = Texture.Sample(TextureSampler, pos);
	color -= Texture.Sample(TextureSampler, pos+0.0001)*4.0f;//sharpen
	color += Texture.Sample(TextureSampler, pos-0.0001)*4.0f;//^
	color.rgba += (color.rgba * 0.4f); //decrease colors

	if (color.r>0.8) color.r = 0.2f;
	if (color.g>0.8) color.g = 0.2f;
	if (color.b>0.8) color.b = 0.2f;
	if (color.r<0.2) color.r = 0.8f;
	if (color.g<0.2) color.g = 0.8f;
	if (color.b<0.2) color.b = 0.8f;


	output.c = smoothstep(color, color*1.2, 0.25);
	return output;
}

#endif
