#ifndef SHADER_MODEL
#define GLSL 1
#else
#define GLSL 0
#endif

#if GLSL
#define float2 vec2
#define float3 vec3
#define float4 vec4
#define sample(x) texture(TextureSampler, x)
#define lerp(a,b,c) mix(a,b,c)
in SHADER
{
    vec4 p;
    vec2 t;
    vec4 c;
} PSin;

layout(location = 0) out vec4 SV_Target0;
#else
#define sample(x) Texture.Sample(TextureSampler, x)
Texture2D Texture : register(t0);
SamplerState TextureSampler : register(s0);
struct VS_OUTPUT
{
    float4 p : SV_Position;
    float2 t : TEXCOORD0;
};
struct PS_OUTPUT
{
    float4 c : SV_Target0;
};
#endif

float overlay(float base, float blend)
{
	float result = 0.0;
	
	if( base < 0.5 ) 
		result = 2.0 * base * blend;
	else   
		result = 1.0 - (1.0 - 2.0*(base-0.5)) * (1.0-blend);
		
	return result;
}

#if GLSL
void ps_main()
#else
float4 ps_main(VS_OUTPUT PSin) : SV_Target0
#endif
{
	float2 pos = PSin.t;
	
	float4 color = sample(pos);
	float4 blur = color * 0.22520613262190495;	

#define OFFSET 0.003

	float2 dx = float2(OFFSET, 0.0);
	float2 dy = float2(0.0, OFFSET);
	float2 dx2 = 2 * dx;
	float2 dy2 = 2 * dy;
	
	blur += 0.002589001911021066 * sample(pos -dx2 +dy2); 
	blur += 0.010778807494659370 * sample(pos -dx +dy2); 
	blur += 0.024146616900339800 * sample(pos +dy2); 
	blur += 0.010778807494659370 * sample(pos +dx +dy2); 
	blur += 0.002589001911021066 * sample(pos +dx2 +dy2); 

	blur += 0.010778807494659370 * sample(pos -dx2 +dy);
	blur += 0.044875475183061630 * sample(pos -dx +dy);
	blur += 0.100529757860782610 * sample(pos +dy);
	blur += 0.044875475183061630 * sample(pos +dx +dy);
	blur += 0.010778807494659370 * sample(pos +dx2 +dy);

	blur += 0.024146616900339800 * sample(pos -dx2);
	blur += 0.100529757860782610 * sample(pos -dx);	
	blur += 0.100529757860782610 * sample(pos +dx);
	blur += 0.024146616900339800 * sample(pos +dx2);

	blur += 0.010778807494659370 * sample(pos -dx2 -dy);
	blur += 0.044875475183061630 * sample(pos -dx -dy);
	blur += 0.100529757860782610 * sample(pos -dy);
	blur += 0.044875475183061630 * sample(pos +dx -dy);
	blur += 0.010778807494659370 * sample(pos +dx2 -dy);

	blur += 0.002589001911021066 * sample(pos -dx2 -dy2);
	blur += 0.010778807494659370 * sample(pos -dx -dy2);
	blur += 0.024146616900339800 * sample(pos -dy2);
	blur += 0.010778807494659370 * sample(pos +dx -dy2);
	blur += 0.002589001911021066 * sample(pos +dx2 -dy2);				
	
	float4 newcolor = float4(overlay(color.r,blur.r),
							overlay(color.g,blur.g),
							overlay(color.b,blur.b),
							1.0);
	
	float4 c  = lerp(color, newcolor, 0.5);
	float lum = dot(c.rgb, float3(0.2125, 0.7154, 0.0721));
	c.rgb = lerp(c.rgb, float3(lum,lum,lum), 0.15);
	
	
#if GLSL
	SV_Target0 = c;
#else
    return c;
#endif
}
