/*
Screen Bloom by KrossX
***********************************

Just like the overlay bloom, but with a higher spread blur and screen blend.

v1.0 
*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency


#if SHADER_MODEL >= 0x400

Texture2D Texture;
SamplerState TextureSampler;

cbuffer cb0
{
	float4 _rcpFrame;		// (1/x, 1/y, 0, 0) for FXAA
	float4 _rcpFrameOpt;	// (0,0,0,0) for FXAA (not used for PC preset)
};

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};

#define TexSample(t,p) t.Sample(TextureSampler, p)

#else

struct PS_INPUT
{
#if SHADER_MODEL < 0x300
	float4 p : TEXCOORD1;
#else
	float4 p : VPOS;
#endif
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : COLOR;
};

sampler Texture : register(s0);

float4 _rcpFrame : register(c0);
float4 _rcpFrameOpt : register(c1);

#define TexSample(t,p) tex2D(t, p)

#endif

float screen(float base, float blend)
{
	return (1 - (1 - base) * (1 - blend));
}

static const float blurspread = 2.0f;


PS_OUTPUT ps_main(PS_INPUT input)
{
	PS_OUTPUT output;

	float2 pos = input.t;
	
	float4 color = TexSample(Texture, pos);
	float4 blur = color * 0.22520613262190495;	

	const float2 dx = float2(_rcpFrame.x * blurspread, 0.0);
	const float2 dy = float2(0.0, _rcpFrame.y * 2.0f * blurspread);
	const float2 dx2 = 2 * dx;
	const float2 dy2 = 2 * dy;
	
	float4 colorU = TexSample(Texture, pos + dy);
	blur += 0.002589001911021066 * TexSample(Texture, pos -dx2 +dy2); 
	blur += 0.010778807494659370 * TexSample(Texture, pos -dx +dy2); 
	blur += 0.024146616900339800 * TexSample(Texture, pos +dy2); 
	blur += 0.010778807494659370 * TexSample(Texture, pos +dx +dy2); 
	blur += 0.002589001911021066 * TexSample(Texture, pos +dx2 +dy2); 

	blur += 0.010778807494659370 * TexSample(Texture, pos -dx2 +dy);
	blur += 0.044875475183061630 * TexSample(Texture, pos -dx +dy);
	blur += 0.100529757860782610 * TexSample(Texture, pos +dy);
	blur += 0.044875475183061630 * TexSample(Texture, pos +dx +dy);
	blur += 0.010778807494659370 * TexSample(Texture, pos +dx2 +dy);

	blur += 0.024146616900339800 * TexSample(Texture, pos -dx2);
	blur += 0.100529757860782610 * TexSample(Texture, pos -dx);	
	blur += 0.100529757860782610 * TexSample(Texture, pos +dx);
	blur += 0.024146616900339800 * TexSample(Texture, pos +dx2);

	blur += 0.010778807494659370 * TexSample(Texture, pos -dx2 -dy);
	blur += 0.044875475183061630 * TexSample(Texture, pos -dx -dy);
	blur += 0.100529757860782610 * TexSample(Texture, pos -dy);
	blur += 0.044875475183061630 * TexSample(Texture, pos +dx -dy);
	blur += 0.010778807494659370 * TexSample(Texture, pos +dx2 -dy);

	blur += 0.002589001911021066 * TexSample(Texture, pos -dx2 -dy2);
	blur += 0.010778807494659370 * TexSample(Texture, pos -dx -dy2);
	blur += 0.024146616900339800 * TexSample(Texture, pos -dy2);
	blur += 0.010778807494659370 * TexSample(Texture, pos +dx -dy2);
	blur += 0.002589001911021066 * TexSample(Texture, pos +dx2 -dy2);				
	
	float4 newcolor = float4(screen(color.r,blur.r),
							screen(color.g,blur.g),
							screen(color.b,blur.b),
							1.0);
	
	output.c = lerp(color, newcolor, 0.8);
	
	return output;
}

#endif
