// By Uhyve on http://forums.pcsx2.net/Thread-Custom-Shaders-for-GSdx?pid=258396#pid258396

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

Texture2D Texture;
SamplerState TextureSampler;

// Technically, I think the wasteful behavior is more accurate, but it looks fine 
// without it as long as smooth is on.
//#define Wasteful
#define Smooth
#define Curved
#define Illuminate
//#define Scanlines
//#define SplitRGB
//#define Vignette

// This controls how many pixels are made. I'd suggest using your monitors native
// resolution divided by 3-4ish (this is set up for 1080p). Also depends on what 
// scale you're using in GSdx.
#define ResX 512.0
#define ResY 360.0
#define PixelX 1.0/ResX
#define PixelY 1.0/ResY
#define Strength 1.0
#define fCurviness 0.05
#define fDarkStrength 1.5

#ifdef Curved
float2 radialDistortion(float2 coord)
{
	float2 cc = coord - 0.5;
	float dist = dot(cc, cc) * fCurviness;				
	return (coord + cc * (1.0 + dist) * dist);
}
#endif

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};

PS_OUTPUT ps_main(PS_INPUT input)
{
	PS_OUTPUT output;	

	#ifdef Curved
	input.t = radialDistortion(input.t);

	// Again wasteful, but for some reason, I couldn't set BORDER as a samplerstate
	if( input.t.x > 1.0 || input.t.x < 0.0 || input.t.y > 1.0 || input.t.y < 0.0 )
	{
		output.c = float4(0.0,0.0,0.0,1.0);
		return output;
	}
	#endif

	float2 vPixelPos;
	vPixelPos.x = (input.t.x * ResX) + 0.5;
	vPixelPos.y = (input.t.y * ResY) + 0.5;
	
	float2 vPixel = round(vPixelPos);
	float2 vPixelDist = vPixelPos - vPixel;

	#ifdef Scanlines
	vPixelDist.x = 0.0;
	#endif

	#ifdef Wasteful
	input.t.x = vPixel.x / ResX;
	input.t.y = vPixel.y / ResY;
	#endif

	float4 color = Texture.Sample(TextureSampler, input.t);
	
	#ifdef Smooth
	float2 coord = input.t;
	float fXDiff = PixelX * 0.33;
	float fYDiff = PixelY * 0.33;
	coord.x -= fXDiff;
	coord.y -= fYDiff;
	color += Texture.Sample(TextureSampler, coord);
	coord.x += fXDiff;
	color += Texture.Sample(TextureSampler, coord);
	coord.x += fXDiff;
	color += Texture.Sample(TextureSampler, coord);
	coord.y += fYDiff;
	color += Texture.Sample(TextureSampler, coord);
	coord.y += fYDiff;
	color += Texture.Sample(TextureSampler, coord);
	coord.x -= fXDiff;
	color += Texture.Sample(TextureSampler, coord);
	coord.x -= fXDiff;
	color += Texture.Sample(TextureSampler, coord);
	coord.y -= fYDiff;
	color += Texture.Sample(TextureSampler, coord);
	color /= 9;
	#endif

	#ifdef Vignette
	color *= saturate(1.3 - (pow(input.t.x-0.5,2) + pow(input.t.y-0.5,2)) );
	#endif

	// Shame this doesn't work, not entirely sure why either. Should split the RGB slightly.
	#if SplitRGB
	float fTexelPos = (vPixelDist.x + 1.0) * 0.7854;
	color.x *= 1.0 - sin(fTexelPos+0.00) * 0.25;
	color.y *= 1.0 - sin(fTexelPos+0.52) * 0.25;
	color.z *= 1.0 - sin(fTexelPos+1.04) * 0.25;
	color.xyz *= 1.5;
	#endif

	float fSize = Strength;

	#ifdef Illuminate
	float fDarkness = 1.0 - ((color.x + color.y + color.z) / 3.0);
	fSize *= (fDarkness * fDarkStrength) + 0.2;
	#endif

	vPixelDist *= fSize;
	float fPixelDist = saturate( 1.0 - sqrt( pow( abs(vPixelDist.x),2 ) + pow( abs(vPixelDist.y),2 ) ) * 0.8 );

	color.xyz *= fPixelDist;
	output.c = color;
	return output;
}

#endif