/*
 * Decompiled with CFR 0.152.
 */
package jmce.altair;

import jmce.altair.AltairConstants;
import jmce.altair.Console;
import jmce.altair.FDC;
import jmce.altair.Memory;
import jmce.altair.SIMH;
import jmce.sim.Loadable;
import jmce.sim.MemoryReadListener;
import jmce.sim.SIMException;
import jmce.sim.terminal.Terminal;
import jmce.zilog.z80.Z80;

public class Altair
extends Z80
implements MemoryReadListener,
AltairConstants {
    private int SR = 0;

    @Override
    protected void initMemories() {
        if (this.getHardware((Class)Memory.class) == null) {
            this.addHardware(new Memory());
        }
        super.initMemories();
    }

    @Override
    protected void initPeripherals() throws SIMException {
        if (this.getHardware((Class)Loadable.class) == null) {
            Loadable boot = new Loadable("altair/boot.rom", 65280);
            this.setResetAddress(65280);
            this.addHardware(boot);
        }
        if (this.getHardware((Class)Console.class) == null) {
            Console c = new Console();
            Terminal t = Terminal.createTerminal();
            c.addHardware(t);
            c.setConnected(t);
            this.addHardware(c);
        }
        if (this.getHardware((Class)FDC.class) == null) {
            FDC fdc = new FDC();
            fdc.addAltairFD("altair/altcpm.dsk");
            this.addHardware(fdc);
        }
        this.addIOReadListener(255, this);
        if (this.getHardware((Class)SIMH.class) == null) {
            this.addHardware(new SIMH());
        }
        super.initPeripherals();
    }

    @Override
    public int readMemory(jmce.sim.Memory m, int address, int value) throws SIMException {
        return this.SR;
    }

    public void setSR(int sr) {
        this.SR = sr;
    }

    public int getSR() {
        return this.SR;
    }
}

