/*
 * Decompiled with CFR 0.152.
 */
package jmce.commodore.vic20;

import jmce.mos.VIA6522;
import jmce.sim.CPU;
import jmce.sim.CycleListener;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.TapeEventListener;
import jmce.sim.TapePulse;
import jmce.sim.tape.TapeFile;
import jmce.sim.tape.TapeFileC64;
import jmce.util.Hex;
import jmce.util.Logger;

public class Tape
extends TapeFile
implements TapeEventListener,
CycleListener,
MemoryWriteListener {
    private static Logger log = Logger.getLogger(Tape.class);
    private VIA6522 via2;
    private VIA6522 via1;
    private int pulse;
    long cycle;

    public Tape() {
        super("VIC20-Tape");
        this.addDecoder(new TapeFileC64());
        this.setConfig("commodore/vic20/invaders.tap");
        this.addTapeEventListener(this);
    }

    public void setVia2(VIA6522 via) {
        this.via2 = via;
    }

    public void setVia1(VIA6522 via) {
        this.via1 = via;
    }

    @Override
    public void tapeStop(jmce.sim.Tape tape) {
        log.info("Stop");
        this.setSense(false);
    }

    @Override
    public void tapePlay(jmce.sim.Tape tape) {
        this.setSense(true);
        log.info("Play");
    }

    @Override
    public void tapePower(jmce.sim.Tape tape) {
    }

    @Override
    public void tapeRec(jmce.sim.Tape tape) {
        log.info("Rec");
        this.setSense(true);
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.pulse = 0;
        this.stop();
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addCycleListener(this);
        this.via2.addPortBWriteListener(this);
        this.via1.addCA2MemoryWriteListener(new MemoryWriteListener(){

            @Override
            public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
                if (value == 0 != Tape.this.getPower()) {
                    Tape.this.setPower(value == 0);
                }
            }
        });
    }

    @Override
    public void cycle(int n) throws SIMException {
        if (!this.isPlay() || !this.getPower()) {
            return;
        }
        if (this.pulse < 0) {
            return;
        }
        while (n > 0) {
            if (this.pulse >= n) {
                this.pulse -= n;
                n = 0;
            } else {
                n -= this.pulse;
                this.pulse = 0;
            }
            if (this.pulse != 0) continue;
            this.via2.writeCA1(false);
            this.via2.writeCA1(true);
            TapePulse tp = this.nextPulse();
            if (tp == null) {
                this.pulse = -1;
                break;
            }
            this.pulse = tp.getWidth();
        }
    }

    private void setSense(boolean mode) {
        try {
            int a = this.via1.readPortA();
            a = !mode ? (a |= 0x40) : (a &= 0xFFFFFFBF);
            this.via1.writePortA(a);
        }
        catch (SIMException sIMException) {
            // empty catch block
        }
    }

    @Override
    public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
        if (!this.isRecording()) {
            return;
        }
        if ((value & 8) != (oldValue & 8)) {
            boolean edge;
            boolean bl = edge = (value & 8) != 0;
            if (!edge) {
                long now = this.cpu.getCycle();
                int delta = (int)(now - this.cycle) / 8;
                log.info("Rec " + edge + " delta " + delta + " " + Hex.formatWord(delta));
                this.cycle = now;
            }
        }
    }
}

