/*
 * Decompiled with CFR 0.152.
 */
package jmce.mos;

import java.io.PrintStream;
import jmce.mos.M65XXConstants;
import jmce.sim.Hardware;
import jmce.sim.Interrupt;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.cpu.AbstractCPU;
import jmce.sim.cpu.AbstractOpcode;
import jmce.sim.cpu.StandardRegister;
import jmce.sim.memory.PlainMemory;
import jmce.util.Hex;

public class M6502
extends AbstractCPU
implements M65XXConstants {
    int A;
    int X;
    int Y;
    int P;
    int S;
    int PC;
    OperandGeneric ac = new OperandA();
    OperandGeneric zp = new OperandZeroPage();
    OperandGeneric zpi = new OperandZeroPageIndirect();
    OperandGeneric zpix = new OperandZeroPageIndexIndirectX();
    OperandGeneric zpiy = new OperandZeroPageIndexIndirectY();
    OperandGeneric zpx = new OperandZeroPageIndexedX();
    OperandGeneric zpy = new OperandZeroPageIndexedY();
    OperandGeneric im = new OperandImmediate();
    OperandGeneric absx = new OperandAbsoluteIndexedX();
    OperandGeneric absy = new OperandAbsoluteIndexedY();
    OperandGeneric abs = new OperandAbsolute();

    public M6502() {
        super("M6502");
        this.setEndian(0);
        this.setClock(1000000L);
        this.setClockPerCycle(1);
    }

    public int vectorToAddress(int irq) throws SIMException {
        return this.getWord(65534 - irq * 2);
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.pc(this.vectorToAddress(1));
    }

    @Override
    public final void setWord(int a, int v) throws SIMException {
        this.memory.setMemory(a + 0, v & 0xFF);
        this.memory.setMemory(a + 1, v >>> 8);
    }

    @Override
    public final int getWord(int a) throws SIMException {
        return this.memory.getMemory(a + 0) | this.memory.getMemory(a + 1) << 8;
    }

    protected void initRegisters() {
        this.addRegister(new StandardRegister("PC", 1, 16, 0){

            @Override
            public int getRegister() {
                return M6502.this.PC;
            }

            @Override
            public void setRegister(int value) {
                M6502.this.PC = value;
            }
        });
        this.addRegister(new StandardRegister("S", 4, 8){

            @Override
            public int getRegister() {
                return M6502.this.S;
            }

            @Override
            public void setRegister(int value) {
                M6502.this.S = value;
            }
        });
        this.addRegister(new StandardRegister("P", 6, 8){

            @Override
            public String descValue() {
                String s = "";
                s = s + "[" + Hex.formatByte(M6502.this.P) + "]";
                s = M6502.this.P(128) ? s + "S" : s + "-";
                s = M6502.this.P(64) ? s + "V" : s + "-";
                s = M6502.this.P(32) ? s + "E" : s + "-";
                s = M6502.this.P(16) ? s + "B" : s + "-";
                s = M6502.this.P(8) ? s + "D" : s + "-";
                s = M6502.this.P(4) ? s + "I" : s + "-";
                s = M6502.this.P(2) ? s + "Z" : s + "-";
                s = M6502.this.P(1) ? s + "C" : s + "-";
                return s;
            }

            @Override
            public int getRegister() {
                return M6502.this.P;
            }

            @Override
            public void setRegister(int value) {
                M6502.this.P = value;
            }
        });
        this.addRegister(new StandardRegister("A", 2, 8){

            @Override
            public int getRegister() {
                return M6502.this.A;
            }

            @Override
            public void setRegister(int value) {
                M6502.this.A = value;
            }
        });
        this.addRegister(new StandardRegister("X", 3, 8){

            @Override
            public int getRegister() {
                return M6502.this.X;
            }

            @Override
            public void setRegister(int value) {
                M6502.this.X = value;
            }
        });
        this.addRegister(new StandardRegister("Y", 3, 8){

            @Override
            public int getRegister() {
                return M6502.this.Y;
            }

            @Override
            public void setRegister(int value) {
                M6502.this.Y = value;
            }
        });
    }

    private void initOpcodes() {
        OpcodeExecuter exec = new OpcodeExecuter("INC", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                ge.setValue(pc, M6502.this.inc8(ge.getValue(pc)));
            }
        };
        this.setOpcode(230, exec, this.zp);
        this.setOpcode(246, exec, this.zpx);
        this.setOpcode(238, exec, this.abs);
        this.setOpcode(254, exec, this.absx);
        exec = new OpcodeExecuter("STY", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                ge.setValue(pc, M6502.this.Y);
            }
        };
        this.setOpcode(132, exec, this.zp);
        this.setOpcode(148, exec, this.zpx);
        this.setOpcode(140, exec, this.abs);
        exec = new OpcodeExecuter("STX", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                ge.setValue(pc, M6502.this.X);
            }
        };
        this.setOpcode(134, exec, this.zp);
        this.setOpcode(150, exec, this.zpy);
        this.setOpcode(142, exec, this.abs);
        exec = new OpcodeExecuter("LDX", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                M6502.this.X = ge.getValue(pc);
                M6502.this.setFlagZS(M6502.this.X);
            }
        };
        this.setOpcode(162, exec, this.im);
        this.setOpcode(166, exec, this.zp);
        this.setOpcode(182, exec, this.zpy);
        this.setOpcode(174, exec, this.abs);
        this.setOpcode(190, exec, this.absy);
        exec = new OpcodeExecuter("STA", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                ge.setValue(pc, M6502.this.A);
            }
        };
        this.setOpcode(133, exec, this.zp);
        this.setOpcode(149, exec, this.zpx);
        this.setOpcode(141, exec, this.abs);
        this.setOpcode(157, exec, this.absx);
        this.setOpcode(153, exec, this.absy);
        this.setOpcode(129, exec, this.zpix);
        this.setOpcode(145, exec, this.zpiy);
        exec = new OpcodeExecuter("LDY", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                M6502.this.Y = ge.getValue(pc);
                M6502.this.setFlagZS(M6502.this.Y);
            }
        };
        this.setOpcode(160, exec, this.im);
        this.setOpcode(164, exec, this.zp);
        this.setOpcode(180, exec, this.zpx);
        this.setOpcode(172, exec, this.abs);
        this.setOpcode(188, exec, this.absx);
        exec = new OpcodeExecuter("BIT", 3){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                int v = ge.getValue(pc);
                M6502.this.P(128, (v & 0x80) != 0);
                M6502.this.P(64, (v & 0x40) != 0);
                M6502.this.P(2, (v &= M6502.this.A) == 0);
            }
        };
        this.setOpcode(36, exec, this.zp);
        this.setOpcode(44, exec, this.abs);
        exec = new OpcodeExecuter("ROR", 1){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                int v = ge.getValue(pc);
                boolean c = (v & 1) != 0;
                v >>>= 1;
                if (M6502.this.P(1)) {
                    v |= 0x80;
                }
                M6502.this.P(1, c);
                ge.setValue(pc, v);
                M6502.this.setFlagZS(v);
            }
        };
        this.setOpcode(106, exec, this.ac);
        this.setOpcode(102, exec, this.zp);
        this.setOpcode(118, exec, this.zpx);
        this.setOpcode(110, exec, this.abs);
        this.setOpcode(126, exec, this.absx);
        exec = new OpcodeExecuter("ROL", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                int v = ge.getValue(pc);
                boolean c = (v & 0x80) != 0;
                v <<= 1;
                if (M6502.this.P(1)) {
                    v |= 1;
                }
                M6502.this.P(1, c);
                ge.setValue(pc, v &= 0xFF);
                M6502.this.setFlagZS(v);
            }
        };
        this.setOpcode(42, exec, this.ac);
        this.setOpcode(38, exec, this.zp);
        this.setOpcode(54, exec, this.zpx);
        this.setOpcode(46, exec, this.abs);
        this.setOpcode(62, exec, this.absx);
        exec = new OpcodeExecuter("CPY", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                M6502.this.cmp8(M6502.this.Y, ge.getValue(pc));
            }
        };
        this.setOpcode(192, exec, this.im);
        this.setOpcode(196, exec, this.zp);
        this.setOpcode(204, exec, this.abs);
        exec = new OpcodeExecuter("CPX", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                M6502.this.cmp8(M6502.this.X, ge.getValue(pc));
            }
        };
        this.setOpcode(224, exec, this.im);
        this.setOpcode(228, exec, this.zp);
        this.setOpcode(236, exec, this.abs);
        exec = new OpcodeExecuter("ASL", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                int value = ge.getValue(pc) << 1;
                M6502.this.P(1, (value & 0x100) != 0);
                ge.setValue(pc, value &= 0xFF);
                M6502.this.setFlagZS(value);
            }
        };
        this.setOpcode(10, exec, this.ac);
        this.setOpcode(6, exec, this.zp);
        this.setOpcode(22, exec, this.zpx);
        this.setOpcode(14, exec, this.abs);
        this.setOpcode(30, exec, this.absx);
        exec = new OpcodeExecuter("LSR", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                int value = ge.getValue(pc);
                M6502.this.P(1, (value & 1) != 0);
                ge.setValue(pc, value >>>= 1);
                M6502.this.setFlagZS(value);
            }
        };
        this.setOpcode(74, exec, this.ac);
        this.setOpcode(70, exec, this.zp);
        this.setOpcode(86, exec, this.zpx);
        this.setOpcode(78, exec, this.abs);
        this.setOpcode(94, exec, this.absx);
        exec = new OpcodeExecuter("DEC", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                int value = ge.getValue(pc);
                value = M6502.this.dec8(value);
                ge.setValue(pc, value);
            }
        };
        this.setOpcode(198, exec, this.zp);
        this.setOpcode(214, exec, this.zpx);
        this.setOpcode(206, exec, this.abs);
        this.setOpcode(222, exec, this.absx);
        this.setOpcodeAll(new OpcodeExecuter(97, "ADC", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                int v = ge.getValue(pc);
                int a = M6502.this.A + v;
                if (M6502.this.P(1)) {
                    ++a;
                }
                M6502.this.P(1, a > 255);
                boolean o = ((M6502.this.A ^ v ^ 0x80) & (v ^ a) & 0x80) != 0;
                M6502.this.P(64, o);
                M6502.this.setAcc(a);
            }
        });
        this.setOpcodeAll(new OpcodeExecuter(225, "SBC", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                int c = M6502.this.P(1) ? 0 : 1;
                int v = ge.getValue(pc);
                int a = M6502.this.A - v - c;
                M6502.this.P(1, (a & 0x100) == 0);
                boolean o = ((v ^ M6502.this.A) & (M6502.this.A ^ a) & 0x80) != 0;
                M6502.this.P(64, o);
                M6502.this.setAcc(a);
            }
        });
        this.setOpcodeAll(new OpcodeExecuter(65, "EOR", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                M6502.this.setAcc(M6502.this.A ^ ge.getValue(pc));
            }
        });
        this.setOpcodeAll(new OpcodeExecuter(1, "ORA", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                M6502.this.setAcc(M6502.this.A | ge.getValue(pc));
            }
        });
        this.setOpcodeAll(new OpcodeExecuter(33, "AND", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                M6502.this.setAcc(M6502.this.A & ge.getValue(pc));
            }
        });
        this.setOpcodeAll(new OpcodeExecuter(161, "LDA", 2){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                M6502.this.setAcc(ge.getValue(pc));
            }
        });
        this.setOpcodeAll(new OpcodeExecuter(193, "CMP", 3){

            @Override
            public void exec(OperandGeneric ge, int pc) throws SIMException {
                M6502.this.cmp8(M6502.this.A, ge.getValue(pc));
            }
        });
        this.setOpcode(new AbstractOpcode(96, 1, 6, "RTS"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.PC = M6502.this.pop16() + 1 & 0xFFFF;
                return 6;
            }
        });
        this.setOpcode(new AbstractOpcode(64, 1, 6, "RTI"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.P = M6502.this.pop() & 0xFFFFFFEF;
                M6502.this.PC = M6502.this.pop16();
                return 6;
            }
        });
        this.setOpcode(new AbstractOpcode(232, 1, 2, "INX"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.X = M6502.this.inc8(M6502.this.X);
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(200, 1, 2, "INY"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.Y = M6502.this.inc8(M6502.this.Y);
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(202, 1, 2, "DEX"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.X = M6502.this.dec8(M6502.this.X);
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(136, 1, 2, "DEY"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.Y = M6502.this.dec8(M6502.this.Y);
                return 2;
            }
        });
        this.setOpcode(new BR(48, 2, 3, 2, "BMI\t%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (M6502.this.P(128)) {
                    return this.jr(pc, M6502.this.getByte(pc + 1));
                }
                return 2;
            }
        });
        this.setOpcode(new BR(80, 2, 3, 2, "BVC\t%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (!M6502.this.P(64)) {
                    return this.jr(pc, M6502.this.getByte(pc + 1));
                }
                return 2;
            }
        });
        this.setOpcode(new BR(112, 2, 3, 2, "BVS\t%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (M6502.this.P(64)) {
                    return this.jr(pc, M6502.this.getByte(pc + 1));
                }
                return 2;
            }
        });
        this.setOpcode(new BR(16, 2, 3, 2, "BPL\t%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (!M6502.this.P(128)) {
                    return this.jr(pc, M6502.this.getByte(pc + 1));
                }
                return 2;
            }
        });
        this.setOpcode(new BR(208, 2, 3, 2, "BNE\t%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (!M6502.this.P(2)) {
                    return this.jr(pc, M6502.this.getByte(pc + 1));
                }
                return 2;
            }
        });
        this.setOpcode(new BR(240, 2, 3, 2, "BEQ\t%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (M6502.this.P(2)) {
                    return this.jr(pc, M6502.this.getByte(pc + 1));
                }
                return 2;
            }
        });
        this.setOpcode(new BR(176, 2, 3, 2, "BCS\t%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (M6502.this.P(1)) {
                    return this.jr(pc, M6502.this.getByte(pc + 1));
                }
                return 2;
            }
        });
        this.setOpcode(new BR(144, 2, 3, 2, "BCC\t%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (!M6502.this.P(1)) {
                    return this.jr(pc, M6502.this.getByte(pc + 1));
                }
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(0, 2, 7, "BRK"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.push16(M6502.this.PC);
                M6502.this.push(M6502.this.P | 0x10);
                M6502.this.P |= 4;
                M6502.this.pc(M6502.this.vectorToAddress(0));
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(234, 1, 2, "NOP"){

            @Override
            public int exec(int pc) {
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(76, 3, 6, "JMP\t%word"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.PC = M6502.this.getWord(pc + 1);
                return 6;
            }
        });
        this.setOpcode(new AbstractOpcode(108, 3, 9, "JMP\t(%word)"){

            @Override
            public int exec(int pc) throws SIMException {
                int add = M6502.this.getWord(pc + 1);
                M6502.this.PC = M6502.this.getWord(add);
                return 9;
            }
        });
        this.setOpcode(new AbstractOpcode(32, 3, 6, "JSR\t%word"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.push16(M6502.this.PC - 1);
                M6502.this.PC = M6502.this.getWord(pc + 1);
                return 6;
            }
        });
        this.setOpcode(new AbstractOpcode(138, 1, 2, "TXA"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.setAcc(M6502.this.X);
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(152, 1, 2, "TYA"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.setAcc(M6502.this.Y);
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(170, 1, 2, "TAX"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.X = M6502.this.A;
                M6502.this.setFlagZS(M6502.this.X);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(168, 1, 2, "TAY"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.Y = M6502.this.A;
                M6502.this.setFlagZS(M6502.this.Y);
                return 2;
            }
        });
        this.setOpcode(new AbstractOpcode(154, 1, 2, "TXS"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.S = M6502.this.X;
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(186, 1, 2, "TSX"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.X = M6502.this.S;
                M6502.this.setFlagZS(M6502.this.X);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(72, 1, 3, "PHA"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.push(M6502.this.A);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(104, 1, 4, "PLA"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.setAcc(M6502.this.pop());
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(8, 1, 3, "PHP"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.push(M6502.this.P);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(40, 1, 4, "PLP"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.P = M6502.this.pop();
                if (M6502.this.P(8)) {
                    throw new SIMException("Decimal mode not supported");
                }
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(24, 1, 2, "CLC"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.P(1, false);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(56, 1, 2, "SEC"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.P(1, true);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(88, 1, 2, "CLI"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.P(4, false);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(120, 1, 2, "SEI"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.P(4, true);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(184, 1, 2, "CLV"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.P(64, false);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(216, 1, 2, "CLD"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.P(8, false);
                return this.getTimes();
            }
        });
        this.setOpcode(new AbstractOpcode(248, 1, 2, "SED"){

            @Override
            public int exec(int pc) throws SIMException {
                M6502.this.P(8, true);
                throw new SIMException("Decimal mode not supported");
            }
        });
    }

    private void setOpcode(int opcode, OpcodeExecuter exec, OperandGeneric ge) {
        class Opcode6502
        extends AbstractOpcode {
            OpcodeExecuter exec;
            OperandGeneric ge;

            Opcode6502(int opcode, OpcodeExecuter _exec, OperandGeneric _ge) {
                super(opcode, _ge.getLength(), _exec.getBaseTime() + _ge.getAddTime(), _exec.getOpcodeName() + "\t" + _ge.getOperandName());
                this.exec = _exec;
                this.ge = _ge;
                if (this.ge.getLength() == 0) {
                    System.out.println(this.getDescription());
                    System.exit(0);
                }
            }

            @Override
            public int exec(int pc) throws SIMException {
                this.ge.incCounter();
                this.exec.exec(this.ge, pc);
                return this.getTimes();
            }
        }
        this.setOpcode(new Opcode6502(opcode, exec, ge));
    }

    private void setOpcodeAll(OpcodeExecuter exec) {
        this.setOpcode(exec.getOpcode() + 0, exec, this.zpix);
        this.setOpcode(exec.getOpcode() + 4, exec, this.zp);
        this.setOpcode(exec.getOpcode() + 8, exec, this.im);
        this.setOpcode(exec.getOpcode() + 12, exec, this.abs);
        this.setOpcode(exec.getOpcode() + 17, exec, this.zpi);
        this.setOpcode(exec.getOpcode() + 16, exec, this.zpiy);
        this.setOpcode(exec.getOpcode() + 20, exec, this.zpx);
        this.setOpcode(exec.getOpcode() + 28, exec, this.absx);
        this.setOpcode(exec.getOpcode() + 24, exec, this.absy);
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.initMemories();
        this.initPeripherals();
        this.initRegisters();
        this.initOpcodes();
        super.init(parent);
    }

    protected void initPeripherals() throws SIMException {
    }

    protected void initMemories() throws SIMException {
        Memory m = this.getMemoryForName("MEMORY");
        if (m == null) {
            m = new PlainMemory("MEMORY", 65536);
            this.addHardware(m);
        }
        this.setMemory(m);
        this.setIO(m);
    }

    private final void P(int mask, boolean mode) throws SIMException {
        this.P = mode ? (this.P |= mask) : (this.P &= ~mask);
    }

    private final boolean P(int mask) {
        return (this.P & mask) != 0;
    }

    protected void push16(int value) throws SIMException {
        this.push(value >>> 8);
        this.push(value);
    }

    protected int pop16() throws SIMException {
        int value = this.pop();
        return value |= this.pop() << 8;
    }

    protected void push(int value) throws SIMException {
        this.setByte(this.S | 0x100, value);
        this.S = this.S - 1 & 0xFF;
    }

    protected int pop() throws SIMException {
        this.S = this.S + 1 & 0xFF;
        int result = this.getByte(this.S | 0x100);
        return result;
    }

    @Override
    public void pc(int pc) throws SIMException {
        this.PC = pc;
    }

    private void setAcc(int a) throws SIMException {
        this.A = a &= 0xFF;
        this.setFlagZS(this.A);
    }

    private void setFlagZS(int value) throws SIMException {
        this.P(2, (value &= 0xFF) == 0);
        this.P(128, (value & 0x80) != 0);
    }

    private final int inc8(int v) throws SIMException {
        this.P(2, (v = v + 1 & 0xFF) == 0);
        this.P(128, (v & 0x80) != 0);
        return v;
    }

    private final void cmp8(int r, int v) throws SIMException {
        this.P(1, r >= v);
        this.setFlagZS((r -= v) & 0xFF);
    }

    private final int dec8(int v) throws SIMException {
        this.P(2, (v = v - 1 & 0xFF) == 0);
        this.P(128, (v & 0x80) != 0);
        return v;
    }

    @Override
    public int pc() throws SIMException {
        return this.PC;
    }

    @Override
    public int fireISR(Interrupt irq) throws SIMException {
        this.push16(this.PC);
        this.push(this.P);
        this.P |= 4;
        this.PC = this.vectorToAddress(irq.getVector());
        return 7;
    }

    @Override
    public boolean isInterruptEnabled() {
        return (this.P & 4) == 0;
    }

    private void dumpOperand(PrintStream ps, OperandGeneric o) {
        this.dumpValue(ps, o.getCounter(), o.getOperandName());
    }

    @Override
    public void dumpStatistics(PrintStream ps) {
        super.dumpStatistics(ps);
        this.dumpTitle(ps, "Execution#", "Addressing mode");
        this.dumpOperand(ps, this.ac);
        this.dumpOperand(ps, this.zp);
        this.dumpOperand(ps, this.zpi);
        this.dumpOperand(ps, this.zpix);
        this.dumpOperand(ps, this.zpiy);
        this.dumpOperand(ps, this.zpx);
        this.dumpOperand(ps, this.zpy);
        this.dumpOperand(ps, this.im);
        this.dumpOperand(ps, this.absx);
        this.dumpOperand(ps, this.absy);
        this.dumpOperand(ps, this.abs);
    }

    abstract class BR
    extends AbstractOpcode {
        private int tjmp;

        BR(int opcode, int l, int tjmp, int tnojmp, String s) {
            super(opcode, l, tnojmp, s);
            this.tjmp = tjmp;
        }

        protected final int jr(int pc, int offset) {
            M6502.this.PC = M6502.this.addOffset(M6502.this.PC, offset);
            return this.tjmp;
        }
    }

    class OperandZeroPageIndexIndirectY
    extends OperandGeneric {
        OperandZeroPageIndexIndirectY() {
            super("(%byte),Y", 2, 5);
        }

        @Override
        public final int getAddress(int pc) throws SIMException {
            int a = M6502.this.getByte(pc + 1);
            a = M6502.this.getWord(a);
            return a + M6502.this.Y & 0xFFFF;
        }
    }

    class OperandZeroPageIndexedY
    extends OperandGeneric {
        OperandZeroPageIndexedY() {
            super("%byte,Y", 2, 3);
        }

        @Override
        public final int getAddress(int pc) throws SIMException {
            return M6502.this.getByte(pc + 1) + M6502.this.Y & 0xFF;
        }
    }

    class OperandZeroPageIndexedX
    extends OperandGeneric {
        OperandZeroPageIndexedX() {
            super("%byte,X", 2, 3);
        }

        @Override
        public final int getAddress(int pc) throws SIMException {
            return M6502.this.getByte(pc + 1) + M6502.this.X & 0xFF;
        }
    }

    class OperandAbsoluteIndexedY
    extends OperandGeneric {
        OperandAbsoluteIndexedY() {
            super("%word,Y", 3, 3);
        }

        @Override
        public final int getAddress(int pc) throws SIMException {
            int a = M6502.this.getWord(pc + 1);
            return a + M6502.this.Y & 0xFFFF;
        }
    }

    class OperandAbsoluteIndexedX
    extends OperandGeneric {
        OperandAbsoluteIndexedX() {
            super("%word,X", 3, 3);
        }

        @Override
        public final int getAddress(int pc) throws SIMException {
            int a = M6502.this.getWord(pc + 1);
            return a + M6502.this.X & 0xFFFF;
        }
    }

    class OperandAbsolute
    extends OperandGeneric {
        OperandAbsolute() {
            super("%word", 3, 2);
        }

        @Override
        public final int getAddress(int pc) throws SIMException {
            return M6502.this.getWord(pc + 1);
        }
    }

    class OperandZeroPageIndexIndirectX
    extends OperandGeneric {
        OperandZeroPageIndexIndirectX() {
            super("(%byte,X)", 2, 4);
        }

        @Override
        public final int getAddress(int pc) throws SIMException {
            int a = M6502.this.getByte(pc + 1) + M6502.this.X & 0xFF;
            return M6502.this.getWord(a);
        }
    }

    class OperandZeroPage
    extends OperandGeneric {
        OperandZeroPage() {
            super("%byte", 2, 1);
        }

        @Override
        public final int getAddress(int pc) throws SIMException {
            return M6502.this.getByte(pc + 1);
        }
    }

    class OperandZeroPageIndirect
    extends OperandGeneric {
        OperandZeroPageIndirect() {
            super("(%byte)", 2, 3);
        }

        @Override
        public final int getAddress(int pc) throws SIMException {
            return M6502.this.getWord(M6502.this.getByte(pc + 1));
        }
    }

    class OperandA
    extends OperandGeneric {
        OperandA() {
            super("A", 1, 0);
        }

        @Override
        public int getAddress(int pc) throws SIMException {
            throw new SIMException("Invalid address mode A");
        }

        @Override
        public void setValue(int pc, int value) throws SIMException {
            M6502.this.setAcc(value);
        }

        @Override
        public int getValue(int pc) throws SIMException {
            return M6502.this.A;
        }
    }

    class OperandImmediate
    extends OperandGeneric {
        OperandImmediate() {
            super("#%byte", 2, 0);
        }

        @Override
        public int getAddress(int pc) throws SIMException {
            throw new SIMException("Invalid address mode immediate");
        }

        @Override
        public int getValue(int pc) throws SIMException {
            return M6502.this.getByte(pc + 1);
        }
    }

    abstract class OperandGeneric {
        private int length;
        private int addTimes;
        private String operand;
        private long counter = 0L;

        public OperandGeneric(String operand, int length, int addTimes) {
            this.length = length;
            this.addTimes = addTimes;
            this.operand = operand;
        }

        public int getAddTime() {
            return this.addTimes;
        }

        public int getLength() {
            return this.length;
        }

        abstract int getAddress(int var1) throws SIMException;

        public int getValue(int pc) throws SIMException {
            return M6502.this.getByte(this.getAddress(pc));
        }

        public void setValue(int pc, int value) throws SIMException {
            M6502.this.setByte(this.getAddress(pc), value);
        }

        public String getOperandName() {
            return this.operand;
        }

        public final void incCounter() {
            ++this.counter;
        }

        public long getCounter() {
            return this.counter;
        }

        public void resetCounter() {
            this.counter = 0L;
        }
    }

    abstract class OpcodeExecuter {
        private String name;
        private int baseTime;
        private int opcode;

        public OpcodeExecuter(String name, int baseTime) {
            this(0, name, baseTime);
        }

        public OpcodeExecuter(int opcode, String name, int baseTime) {
            this.opcode = opcode;
            this.name = name;
            this.baseTime = baseTime;
        }

        public int getOpcode() {
            return this.opcode;
        }

        public int getBaseTime() {
            return this.baseTime;
        }

        public String getOpcodeName() {
            return this.name;
        }

        public abstract void exec(OperandGeneric var1, int var2) throws SIMException;
    }
}

