/*
 * Decompiled with CFR 0.152.
 */
package jmce.nec;

import jmce.nec.PD765Constants;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.disk.AbstractDiskController;
import jmce.util.RingBuffer;

public class PD765
extends AbstractDiskController
implements PD765Constants {
    private RingBuffer<Integer> result = new RingBuffer(9216);
    private RingBuffer<Integer> data = new RingBuffer(9216);
    private RingBuffer<Integer> cmds = new RingBuffer(16);
    private int base = 0;
    private int msr;
    private int cmd;
    private boolean reset = false;

    public void setBase(int base) {
        this.base = base;
    }

    public int getBase() {
        return this.base;
    }

    public void setReset(boolean mode) {
        this.reset = mode;
        if (mode) {
            this.msr = 128;
            this.result.purge();
            this.data.purge();
            this.cmds.purge();
        }
    }

    public void writeMemory(Memory m, int address, int v, int oldValue) throws SIMException {
        if (this.reset) {
            return;
        }
        if ((this.msr & 0x10) == 0) {
            if (this.cmds.isEmpty()) {
                this.cmd = v;
            }
            this.cmds.put(v);
            switch (this.cmd) {
                case 7: {
                    if (this.cmds.count() != 2) break;
                    this.cmdRecalibrate();
                }
            }
        }
    }

    boolean checkDrive(int drive) {
        if (drive >= this.getDiskCount()) {
            return false;
        }
        try {
            this.setDrive(drive);
            if (!this.disk.mount()) {
                return false;
            }
        }
        catch (SIMException e) {
            return false;
        }
        return true;
    }

    public void cmdRecalibrate() {
        this.cmds.get();
        this.drive = this.cmds.get() & 3;
        this.msr |= 0x10;
        this.msr |= 0xFFFFFF7F;
        if (!this.checkDrive(this.drive)) {
            // empty if block
        }
    }

    public int readMemory(Memory m, int a, int v) throws SIMException {
        if (this.reset) {
            return v;
        }
        if (a == this.base + 0) {
            v = this.msr;
        } else if (a == this.base + 1) {
            v = (this.msr & 0x20) != 0 ? this.sendByte() : this.sendResult();
        }
        return v;
    }

    private void endCommand() {
        this.msr &= 0xFFFFFFCF;
    }

    public int sendByte() {
        int v = this.data.get();
        if (this.data.isEmpty()) {
            this.msr &= 0xFFFFFFBF;
            this.endCommand();
        }
        return v;
    }

    public int sendResult() {
        int v = 0;
        if (!this.result.isEmpty()) {
            v = this.result.get();
            if (this.result.isEmpty()) {
                this.msr &= 0xFFFFFFBF;
            }
        }
        return v;
    }
}

